/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.stats.datastructures;

public class PairedData {
    protected int n = 0;
    protected double[] x = null;
    protected double[] y = null;

    public PairedData(double[][] data) {
        this.n = data.length;
        this.x = new double[this.n];
        this.y = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.x[i] = data[i][0];
            this.y[i] = data[i][1];
        }
    }

    public PairedData(double[] x, double[] y) {
        this.n = x.length;
        if (y.length != this.n) {
            throw new IllegalArgumentException("length of arrays must be equal");
        }
        this.x = new double[this.n];
        this.y = new double[this.n];
        System.arraycopy(x, 0, this.x, 0, this.n);
        System.arraycopy(y, 0, this.y, 0, this.n);
    }

    double[] differences() {
        double[] result = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            result[i] = this.y[i] - this.x[i];
        }
        return result;
    }

    public int getN() {
        return this.n;
    }

    public double[] getX() {
        return this.x;
    }

    public double[] getY() {
        return this.y;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.n; ++i) {
            sb.append(this.x[i]);
            sb.append(' ');
            sb.append(this.y[i]);
            sb.append('\n');
        }
        return sb.toString();
    }
}

