/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import uk.ac.rhul.cs.utils.Pair;

public class ArrayUtils {
    public static Double getMedian(double[] array) {
        if (array.length == 0) {
            return null;
        }
        double[] copy = (double[])array.clone();
        int midpoint = copy.length / 2;
        Arrays.sort(copy);
        if (copy.length % 2 == 0) {
            return (copy[midpoint - 1] + copy[midpoint]) / 2.0;
        }
        return copy[midpoint];
    }

    public static double[] getRanks(double[] array, double tolerance) {
        int j;
        int i;
        int n = array.length;
        ArrayList<Pair<Double, Integer>> valuesAndIndices = new ArrayList<Pair<Double, Integer>>(n);
        double[] ranks = new double[n];
        if (n == 0) {
            return ranks;
        }
        for (i = 0; i < n; ++i) {
            valuesAndIndices.add(Pair.create(array[i], i));
        }
        Collections.sort(valuesAndIndices, new Comparator<Pair<Double, Integer>>(){

            @Override
            public int compare(Pair<Double, Integer> foo, Pair<Double, Integer> bar) {
                return foo.getLeft().compareTo(bar.getLeft());
            }
        });
        int sumRanks = 0;
        int dupCount = 1;
        Pair prev = (Pair)valuesAndIndices.get(0);
        for (i = 1; i < n; ++i) {
            Pair curr = (Pair)valuesAndIndices.get(i);
            if (Math.abs((Double)curr.getLeft() - (Double)prev.getLeft()) < tolerance) {
                ++dupCount;
                sumRanks += i;
            } else {
                double rank = (double)sumRanks / (double)dupCount + 1.0;
                for (j = i - dupCount; j < i; ++j) {
                    ranks[((Integer)((Pair)valuesAndIndices.get((int)j)).getRight()).intValue()] = rank;
                }
                dupCount = 1;
                sumRanks = i;
            }
            prev = curr;
        }
        double rank = (double)sumRanks / (double)dupCount + 1.0;
        for (j = n - dupCount; j < n; ++j) {
            ranks[((Integer)((Pair)valuesAndIndices.get((int)j)).getRight()).intValue()] = rank;
        }
        return ranks;
    }

    public static double min(double[] array) {
        if (array.length == 0) {
            throw new IllegalArgumentException("array must not be empty");
        }
        double result = array[0];
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            if (!(array[i] < result)) continue;
            result = array[i];
        }
        return result;
    }

    public static double max(double[] array) {
        if (array.length == 0) {
            throw new IllegalArgumentException("array must not be empty");
        }
        double result = array[0];
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            if (!(array[i] > result)) continue;
            result = array[i];
        }
        return result;
    }
}

