/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries;

import ec.tstoolkit.design.IntValue;

public enum DayOfWeek implements IntValue
{
    Sunday(0),
    Monday(1),
    Tuesday(2),
    Wednesday(3),
    Thursday(4),
    Friday(5),
    Saturday(6);

    private final int value;

    public static DayOfWeek fromCalendar(int dayofweek) {
        return DayOfWeek.valueOf((dayofweek - 1 + 6) % 7);
    }

    public static int toCalendar(DayOfWeek dayofWeek) {
        switch (dayofWeek) {
            case Sunday: {
                return 1;
            }
            case Monday: {
                return 2;
            }
            case Tuesday: {
                return 3;
            }
            case Wednesday: {
                return 4;
            }
            case Thursday: {
                return 5;
            }
            case Friday: {
                return 6;
            }
            case Saturday: {
                return 7;
            }
        }
        throw new RuntimeException();
    }

    public static DayOfWeek valueOf(int value) {
        return IntValue.valueOf(DayOfWeek.class, value).orElse(null);
    }

    private DayOfWeek(int value) {
        this.value = value;
    }

    @Override
    public int intValue() {
        return this.value;
    }
}

