/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.calendars;

import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.DayOfWeek;
import ec.tstoolkit.timeseries.Month;
import ec.tstoolkit.timeseries.calendars.IDayInfo;
import ec.tstoolkit.timeseries.calendars.ISpecialDay;
import ec.tstoolkit.timeseries.calendars.Utilities;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.util.Iterator;
import java.util.Objects;

public class FixedWeekDay
implements ISpecialDay {
    public final DayOfWeek dayOfWeek;
    public final int week;
    public final Month month;
    private final double weight;
    public static final FixedWeekDay LaborDay = new FixedWeekDay(0, DayOfWeek.Monday, Month.September);
    public static final FixedWeekDay ThanksGiving = new FixedWeekDay(3, DayOfWeek.Thursday, Month.November);

    public FixedWeekDay(int week, DayOfWeek day, Month month) {
        this.week = week;
        this.dayOfWeek = day;
        this.month = month;
        this.weight = 1.0;
    }

    public FixedWeekDay(int week, DayOfWeek day, Month month, double weight) {
        this.week = week;
        this.dayOfWeek = day;
        this.month = month;
        this.weight = weight;
    }

    public FixedWeekDay reweight(double nweight) {
        return new FixedWeekDay(this.week, this.dayOfWeek, this.month, nweight);
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public boolean match(ISpecialDay.Context context) {
        return true;
    }

    public Day calcDay(int year) {
        Day d = Utilities.firstWeekDay(this.dayOfWeek, year, this.month);
        if (this.week > 0) {
            d = d.plus(this.week * 7);
        }
        return d;
    }

    public static FixedWeekDay add(FixedWeekDay fd, int offset) {
        if (offset == 0) {
            return fd;
        }
        int pos = fd.week * 7 + offset + fd.dayOfWeek.intValue();
        if (pos < 0 || pos >= 28) {
            return null;
        }
        return new FixedWeekDay(pos / 7, DayOfWeek.valueOf(pos % 7), fd.month, fd.weight);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof FixedWeekDay && this.equals((FixedWeekDay)obj);
    }

    private boolean equals(FixedWeekDay other) {
        return other.dayOfWeek == this.dayOfWeek && other.month == this.month && other.week == this.week && other.weight == this.weight;
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + Objects.hashCode(this.dayOfWeek);
        hash = 89 * hash + this.week;
        hash = 89 * hash + Objects.hashCode(this.month);
        return hash;
    }

    @Override
    public Iterable<IDayInfo> getIterable(TsFrequency freq, Day start, Day end) {
        return new FixedWeekDayIterable(freq, this, start, end);
    }

    @Override
    public double[][] getLongTermMeanEffect(int freq) {
        int w = this.dayOfWeek.intValue();
        if (w == 0) {
            return null;
        }
        int c = 12 / freq;
        int imonth = this.month.intValue();
        int p = imonth / c;
        double[] m = new double[7];
        m[--w] = this.weight;
        m[6] = -this.weight;
        double[][] rslt = new double[freq][];
        rslt[p] = m;
        return rslt;
    }

    @Override
    public TsDomain getSignificantDomain(TsFrequency freq, Day start, Day end) {
        TsPeriod pstart = new TsPeriod(freq, start);
        TsPeriod pend = new TsPeriod(freq, end);
        Day sday = Utilities.firstWeekDay(this.dayOfWeek, pstart.getYear(), this.month);
        if (this.week > 0) {
            sday = sday.plus(this.week * 7);
        }
        if (start.isAfter(sday)) {
            pstart.move(1);
        }
        Day eday = Utilities.firstWeekDay(this.dayOfWeek, pend.getYear(), this.month);
        if (this.week > 0) {
            eday = eday.plus(this.week * 7);
        }
        if (end.isBefore(eday)) {
            pend.move(-1);
        }
        int n = pend.minus(pstart) + 1;
        return new TsDomain(pstart, Math.max(0, n));
    }

    static class FixedWeekDayIterable
    implements Iterable<IDayInfo> {
        private final FixedWeekDay fday;
        private final TsPeriod pstart;
        private final int m_n;

        FixedWeekDayIterable(TsFrequency freq, FixedWeekDay fday, Day fstart, Day fend) {
            this.fday = fday;
            int ystart = fstart.getYear();
            int yend = fend.getYear();
            Day xday = fday.calcDay(ystart);
            Day yday = fday.calcDay(yend);
            this.pstart = new TsPeriod(freq);
            this.pstart.set(xday);
            TsPeriod pend = new TsPeriod(freq);
            pend.set(yday);
            if (xday.isNotBefore(fstart)) {
                this.pstart.move(-freq.intValue());
            }
            if (yday.isAfter(fend)) {
                pend.move(-freq.intValue());
            }
            this.m_n = pend.getYear() - this.pstart.getYear();
        }

        @Override
        public Iterator<IDayInfo> iterator() {
            return new Iterator<IDayInfo>(){
                private int m_cur = -1;
                private FixedWeekDayInfo m_info = new FixedWeekDayInfo(FixedWeekDayIterable.access$000(this), FixedWeekDayIterable.access$100(this));

                @Override
                public boolean hasNext() {
                    return this.m_cur < m_n - 1;
                }

                @Override
                public IDayInfo next() {
                    this.m_info.move(1);
                    ++this.m_cur;
                    return this.m_info;
                }
            };
        }

        static /* synthetic */ TsPeriod access$000(FixedWeekDayIterable x0) {
            return x0.pstart;
        }

        static /* synthetic */ FixedWeekDay access$100(FixedWeekDayIterable x0) {
            return x0.fday;
        }
    }

    static class FixedWeekDayInfo
    implements IDayInfo {
        final TsPeriod m_period;
        final FixedWeekDay m_fday;

        FixedWeekDayInfo(TsPeriod period, FixedWeekDay fday) {
            this.m_fday = fday;
            this.m_period = period.clone();
        }

        @Override
        public Day getDay() {
            Day d = Utilities.firstWeekDay(this.m_fday.dayOfWeek, this.m_period.getYear(), this.m_fday.month);
            if (this.m_fday.week > 0) {
                d = d.plus(this.m_fday.week * 7);
            }
            return d;
        }

        @Override
        public TsPeriod getPeriod() {
            return this.m_period;
        }

        @Override
        public DayOfWeek getDayOfWeek() {
            return this.getDay().getDayOfWeek();
        }

        public void move(int n) {
            this.m_period.move(n * this.m_period.getFrequency().intValue());
        }
    }
}

