/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.Feature_Selection.evolutionary_algorithms.CHC.wrapper;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import keel.Algorithms.Preprocess.Feature_Selection.Datos;
import keel.Algorithms.Preprocess.Feature_Selection.evolutionary_algorithms.Cromosoma;
import keel.Algorithms.Preprocess.Feature_Selection.evolutionary_algorithms.CromosomaBinario;
import keel.Dataset.Attributes;
import org.core.Fichero;
import org.core.Randomize;

public class CHCBinaryLVO {
    private Datos data;
    private Parametros params;
    private Cromosoma[] poblacion;
    private Cromosoma mejorIndividuo;
    private int nEvalMejorIndividuo;

    public CHCBinaryLVO(String ficParametros) {
        this.params = new Parametros(ficParametros);
        Randomize.setSeed(this.params.seed);
        this.data = new Datos(this.params.trainFileNameInput, this.params.testFileNameInput, this.params.paramKNN);
        this.poblacion = new Cromosoma[this.params.tamPoblacion];
        this.mejorIndividuo = new CromosomaBinario(this.data.returnNumFeatures());
        this.nEvalMejorIndividuo = -1;
        for (int i = 0; i < this.params.tamPoblacion; ++i) {
            this.poblacion[i] = new CromosomaBinario(this.data.returnNumFeatures());
        }
    }

    private double fitness(Cromosoma cr) {
        if (cr == null) {
            System.err.println("ERROR: Chromosome doesn't exist");
            System.exit(0);
        }
        boolean[] fv = cr.devolverFeaturesVector();
        double precision = this.data.LVO(fv);
        int numCaracSel = 0;
        for (int i = 0; i < fv.length; ++i) {
            if (!fv[i]) continue;
            ++numCaracSel;
        }
        return (1.0 - this.params.alfa) * (1.0 - precision) - this.params.alfa * ((double)numCaracSel / (double)fv.length);
    }

    private int reemplazar(Cromosoma[] descendientes) {
        int nuevos = 0;
        while (descendientes.length > 0) {
            int i;
            int peor = 0;
            double fitnessPeor = this.poblacion[0].getFitness();
            for (i = 1; i < this.params.tamPoblacion; ++i) {
                if (!(fitnessPeor > this.poblacion[i].getFitness())) continue;
                fitnessPeor = this.poblacion[i].getFitness();
                peor = i;
            }
            int mejor = 0;
            double fitnessMejor = descendientes[0].getFitness();
            for (i = 1; i < descendientes.length - nuevos; ++i) {
                if (!(fitnessMejor < descendientes[i].getFitness())) continue;
                fitnessMejor = descendientes[i].getFitness();
                mejor = i;
            }
            if (fitnessMejor > fitnessPeor) {
                this.poblacion[peor] = descendientes[mejor];
                for (i = mejor; i < descendientes.length - nuevos - 1; ++i) {
                    descendientes[i] = descendientes[i + 1];
                }
                ++nuevos;
                continue;
            }
            return nuevos;
        }
        return nuevos;
    }

    private void restart() {
        this.poblacion[0].copy(this.mejorIndividuo);
        for (int i = 1; i < this.params.tamPoblacion; ++i) {
            this.poblacion[i].initPlantilla(this.mejorIndividuo, this.params.divergenceRatio);
        }
    }

    private Cromosoma[] generarDescendientes(int umbral) {
        Vector<CromosomaBinario> v = new Vector<CromosomaBinario>();
        int i = 0;
        while (i + 1 < this.params.tamPoblacion) {
            CromosomaBinario hijo2;
            CromosomaBinario hijo1 = new CromosomaBinario(this.data.returnNumFeatures());
            if (this.poblacion[i].cruzarHUX(this.poblacion[i + 1], hijo1, hijo2 = new CromosomaBinario(this.data.returnNumFeatures()), umbral)) {
                v.addElement(hijo1);
                v.addElement(hijo2);
            }
            i += 2;
        }
        Cromosoma[] a = new Cromosoma[v.size()];
        v.toArray(a);
        return a;
    }

    private void comprobarCromosomasVacios(Cromosoma[] pobl) {
        int i = 0;
        while (i < pobl.length) {
            boolean vacio = true;
            for (int j = 0; j < pobl[i].devolverTamCromosoma() && vacio; ++j) {
                if (pobl[i].devolverGen(j) == 0) continue;
                vacio = false;
            }
            if (vacio) {
                pobl[i].initRand();
                pobl[i].setFitness(-1.0);
                continue;
            }
            ++i;
        }
    }

    private void CHC() {
        int i;
        for (i = 0; i < this.params.tamPoblacion; ++i) {
            this.poblacion[i].initRand();
        }
        this.comprobarCromosomasVacios(this.poblacion);
        int nEvaluaciones = 0;
        int umbral = this.poblacion[0].devolverTamCromosoma() / 4;
        while (nEvaluaciones < this.params.numEvaluaciones) {
            for (i = 0; i < this.params.tamPoblacion; ++i) {
                if (this.poblacion[i].getFitness() != -1.0) continue;
                ++nEvaluaciones;
                this.poblacion[i].setFitness(this.fitness(this.poblacion[i]));
                if (this.nEvalMejorIndividuo != -1 && !(this.poblacion[i].getFitness() > this.mejorIndividuo.getFitness())) continue;
                this.mejorIndividuo.copy(this.poblacion[i]);
                this.nEvalMejorIndividuo = nEvaluaciones;
            }
            Cromosoma[] descendientes = this.generarDescendientes(umbral);
            this.comprobarCromosomasVacios(descendientes);
            for (i = 0; i < descendientes.length; ++i) {
                descendientes[i].setFitness(this.fitness(descendientes[i]));
                ++nEvaluaciones;
            }
            if (this.reemplazar(descendientes) != 0 || --umbral >= 0) continue;
            this.restart();
            umbral = (int)(this.params.divergenceRatio * (1.0 - this.params.divergenceRatio) * (double)this.poblacion[0].devolverTamCromosoma());
        }
    }

    public void ejecutar() {
        Date d = new Date();
        String resultado = "RESULTS generated at " + String.valueOf(d) + " \n--------------------------------------------------\n";
        resultado = resultado + "Algorithm Name: " + this.params.nameAlgorithm + "\n";
        this.CHC();
        resultado = resultado + "\nPARTITION Filename: " + this.params.trainFileNameInput + "\n---------------\n\n";
        resultado = resultado + "Features selected: \n";
        boolean[] features = this.mejorIndividuo.devolverFeaturesVector();
        int numFeatures = 0;
        for (int i = 0; i < features.length; ++i) {
            if (!features[i]) continue;
            resultado = resultado + Attributes.getInputAttribute(i).getName() + " - ";
            ++numFeatures;
        }
        resultado = resultado + "\n Best individual find at " + this.nEvalMejorIndividuo + "evaluation. ";
        resultado = resultado + "\n\n" + String.valueOf(numFeatures) + " features of " + Attributes.getInputNumAttributes() + "\n\n";
        resultado = resultado + "Error in test (using train for prediction): " + String.valueOf(this.data.validacionCruzada(features)) + "\n";
        resultado = resultado + "Error in test (using test for prediction): " + String.valueOf(this.data.LVOTest(features)) + "\n";
        resultado = resultado + "---------------\n";
        System.out.println("Experiment completed successfully");
        Fichero.escribeFichero(this.params.extraFileNameOutput, resultado);
        this.data.generarFicherosSalida(this.params.trainFileNameOutput, this.params.testFileNameOutput, features);
    }

    private class Parametros {
        String nameAlgorithm;
        int paramKNN;
        String trainFileNameInput;
        String testFileNameInput;
        String testFileNameOutput;
        String trainFileNameOutput;
        String extraFileNameOutput;
        double divergenceRatio;
        double alfa;
        int tamPoblacion;
        long seed;
        int numEvaluaciones;

        Parametros(String nombreFicheroParametros) {
            try {
                String fichero = Fichero.leeFichero(nombreFicheroParametros);
                fichero = fichero + "\n";
                fichero = fichero.replace('\r', ' ');
                StringTokenizer lineasFichero = new StringTokenizer(fichero, "\n");
                int i = 0;
                while (lineasFichero.hasMoreTokens()) {
                    String linea = lineasFichero.nextToken();
                    ++i;
                    StringTokenizer tokens = new StringTokenizer(linea, " ,\t");
                    if (!tokens.hasMoreTokens()) continue;
                    String tok = tokens.nextToken();
                    if (tok.equalsIgnoreCase("algorithm")) {
                        this.nameAlgorithm = this.getParamString(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("inputdata")) {
                        this.getInputFiles(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("outputdata")) {
                        this.getOutputFiles(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("paramKNN")) {
                        this.paramKNN = this.getParamInt(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("divergenceRatio")) {
                        this.divergenceRatio = this.getParamDouble(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("seed")) {
                        this.seed = this.getParamInt(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("nEval")) {
                        this.numEvaluaciones = this.getParamInt(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("alfa")) {
                        this.alfa = this.getParamDouble(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("popLength")) {
                        this.tamPoblacion = this.getParamInt(tokens);
                        continue;
                    }
                    throw new IOException("Syntax error on line " + i + ": [" + tok + "]\n");
                }
            }
            catch (FileNotFoundException e) {
                System.err.println(e + "Parameter file");
            }
            catch (IOException e) {
                System.err.println(e + "Aborting program");
                System.exit(-1);
            }
            String contents = "-- Parameters echo --- \n";
            contents = contents + "Algorithm name: " + this.nameAlgorithm + "\n";
            contents = contents + "Input Train File: " + this.trainFileNameInput + "\n";
            contents = contents + "Input Test File: " + this.testFileNameInput + "\n";
            contents = contents + "Output Train File: " + this.trainFileNameOutput + "\n";
            contents = contents + "Output Test File: " + this.testFileNameOutput + "\n";
            contents = contents + "Parameter k of KNN Algorithm: " + this.paramKNN + "\n";
            contents = contents + "Divergence Ratio. : " + this.divergenceRatio + "\n";
            contents = contents + "Alfa: " + this.alfa + "\n";
            contents = contents + "Population: " + this.tamPoblacion + "\n";
            contents = contents + "Number of Evals: " + this.numEvaluaciones + "\n";
            contents = contents + "Seed: " + this.seed + "\n";
            System.out.println(contents);
        }

        private int getParamInt(StringTokenizer s) {
            String val = s.nextToken();
            val = s.nextToken();
            return Integer.parseInt(val);
        }

        private long getParamLong(StringTokenizer s) {
            String val = s.nextToken();
            val = s.nextToken();
            return Long.parseLong(val);
        }

        private double getParamDouble(StringTokenizer s) {
            String val = s.nextToken();
            val = s.nextToken();
            return Double.parseDouble(val);
        }

        private String getParamString(StringTokenizer s) {
            String contenido = "";
            String val = s.nextToken();
            while (s.hasMoreTokens()) {
                contenido = contenido + s.nextToken() + " ";
            }
            return contenido.trim();
        }

        private void getInputFiles(StringTokenizer s) {
            String val = s.nextToken();
            this.trainFileNameInput = s.nextToken().replace('\"', ' ').trim();
            this.testFileNameInput = s.nextToken().replace('\"', ' ').trim();
        }

        private void getOutputFiles(StringTokenizer s) {
            String val = s.nextToken();
            this.trainFileNameOutput = s.nextToken().replace('\"', ' ').trim();
            this.testFileNameOutput = s.nextToken().replace('\"', ' ').trim();
            this.extraFileNameOutput = s.nextToken().replace('\"', ' ').trim();
        }
    }
}

