/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.PSO;

import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Parameters;
import keel.Algorithms.Instance_Generation.utilities.RandomGenerator;

public class PSOGenerator
extends PrototypeGenerator {
    private int k;
    private int SwarmSize;
    private int ParticleSize;
    private int MaxIter;
    private double C1;
    private double C2;
    private double VMax;
    private double Wstart;
    private double Wend;
    protected int numberOfPrototypes;
    protected int numberOfClass;
    private String[] paramsOfInitialReducction = null;

    public PSOGenerator(PrototypeSet _trainingDataSet, int neigbors, int poblacion, int perc, int iteraciones, double c1, double c2, double vmax, double wstart, double wend) {
        super(_trainingDataSet);
        this.algorithmName = "PSO";
        this.k = neigbors;
        this.SwarmSize = poblacion;
        this.ParticleSize = perc;
        this.MaxIter = iteraciones;
        this.numberOfPrototypes = this.getSetSizeFromPercentage(perc);
        this.C1 = c1;
        this.C2 = c2;
        this.VMax = vmax;
        this.Wend = wend;
        this.Wstart = wstart;
    }

    public PSOGenerator(PrototypeSet t, Parameters parameters) {
        super(t, parameters);
        this.algorithmName = "PSO";
        this.k = parameters.getNextAsInt();
        this.SwarmSize = parameters.getNextAsInt();
        this.ParticleSize = parameters.getNextAsInt();
        this.MaxIter = parameters.getNextAsInt();
        this.C1 = parameters.getNextAsDouble();
        this.C2 = parameters.getNextAsDouble();
        this.VMax = parameters.getNextAsDouble();
        this.Wstart = parameters.getNextAsDouble();
        this.Wend = parameters.getNextAsDouble();
        this.numberOfClass = this.trainingDataSet.getPosibleValuesOfOutput().size();
        this.numberOfPrototypes = this.getSetSizeFromPercentage(this.ParticleSize);
        System.out.print("\nIsaac dice:  " + this.k + " Swar= " + this.SwarmSize + " Particle=  " + this.ParticleSize + " Maxiter= " + this.MaxIter + " Wend=  " + this.Wend + "\n");
    }

    @Override
    public PrototypeSet reduceSet() {
        Prototype aux;
        int j;
        int i;
        System.out.print("\nThe algorithm is starting...\n Computing...\n");
        System.out.println("Number of prototypes, result set = " + this.numberOfPrototypes + "\n");
        System.out.println("Reduction %, result set = " + (this.trainingDataSet.size() - this.numberOfPrototypes) * 100 / this.trainingDataSet.size() + "\n");
        PrototypeSet[] population = new PrototypeSet[this.SwarmSize];
        PrototypeSet[] mejorPosicion = new PrototypeSet[this.SwarmSize];
        PrototypeSet nominalPopulation = new PrototypeSet();
        double[] fitness = new double[this.SwarmSize];
        double[] fitness_bestPopulation = new double[this.SwarmSize];
        PrototypeSet bestParticle = new PrototypeSet();
        double inertia = (this.Wstart - this.Wend) * (double)this.MaxIter / ((double)this.MaxIter + this.Wend);
        boolean mejorParticula = false;
        population[0] = new PrototypeSet(this.selecRandomSet(this.numberOfPrototypes, true).clone());
        fitness[0] = PSOGenerator.accuracy(population[0], this.trainingDataSet);
        PrototypeSet[] clases = new PrototypeSet[this.numberOfClass];
        for (i = 0; i < this.numberOfClass; ++i) {
            clases[i] = new PrototypeSet(this.trainingDataSet.getFromClass(i));
            System.out.println("Clase" + i + " : " + clases[i].size());
        }
        for (i = 0; i < population[0].size(); ++i) {
            for (j = 0; j < this.numberOfClass; ++j) {
                if (population[0].getFromClass(j).size() != 0 || clases[j].size() == 0) continue;
                aux = new Prototype(clases[j].getRandom());
                population[0].add(aux);
            }
        }
        population[0].print();
        for (i = 1; i < this.SwarmSize; ++i) {
            population[i] = new PrototypeSet();
            for (j = 0; j < population[0].size(); ++j) {
                aux = new Prototype(this.trainingDataSet.getFromClass(((Prototype)population[0].get(j)).getOutput(0)).getRandom());
                population[i].add(aux);
            }
            fitness[i] = PSOGenerator.accuracy(population[i], this.trainingDataSet);
            fitness_bestPopulation[i] = fitness[i];
        }
        double bestFitness = fitness[0];
        int bestFitnessIndex = 0;
        for (int i2 = 1; i2 < this.SwarmSize; ++i2) {
            if (!(fitness[i2] > bestFitness)) continue;
            bestFitness = fitness[i2];
            bestFitnessIndex = i2;
        }
        for (int j2 = 0; j2 < this.SwarmSize; ++j2) {
            mejorPosicion[j2] = population[j2].clone();
            for (int i3 = 0; i3 < population[j2].size(); ++i3) {
                ((Prototype)population[j2].get(i3)).setIndex(i3);
            }
        }
        double[][][] velocidad = new double[this.SwarmSize][][];
        int num_atribs = ((Prototype)population[0].get(0)).numberOfInputs();
        for (int i4 = 0; i4 < this.SwarmSize; ++i4) {
            velocidad[i4] = new double[population[0].size()][];
            for (int j3 = 0; j3 < population[0].size(); ++j3) {
                velocidad[i4][j3] = new double[num_atribs];
                this.k = 0;
                while (this.k < num_atribs) {
                    velocidad[i4][j3][this.k] = RandomGenerator.Randdouble(-this.VMax, this.VMax) * 1.0;
                    ++this.k;
                }
            }
        }
        for (int iter = 0; iter < this.MaxIter; ++iter) {
            int i5;
            for (i5 = 0; i5 < this.SwarmSize; ++i5) {
                for (int k = 0; k < population[i5].size(); ++k) {
                    Prototype resta = ((Prototype)mejorPosicion[i5].get(k)).sub((Prototype)population[i5].get(k));
                    Prototype restaBestParticle = ((Prototype)mejorPosicion[bestFitnessIndex].get(k)).sub((Prototype)population[i5].get(k));
                    for (int j4 = 0; j4 < num_atribs; ++j4) {
                        velocidad[i5][k][j4] = inertia * velocidad[i5][k][j4];
                        double aleatorio = RandomGenerator.Randdouble(0.0, 1.0);
                        double[] dArray = velocidad[i5][k];
                        int n = j4;
                        dArray[n] = dArray[n] + this.C1 * aleatorio * resta.getInput(j4);
                        aleatorio = RandomGenerator.Randdouble(0.0, 1.0);
                        double[] dArray2 = velocidad[i5][k];
                        int n2 = j4;
                        dArray2[n2] = dArray2[n2] + this.C2 * aleatorio * restaBestParticle.getInput(j4);
                        if (velocidad[i5][k][j4] > this.VMax) {
                            velocidad[i5][k][j4] = this.VMax;
                        } else if (velocidad[i5][k][j4] < -this.VMax) {
                            velocidad[i5][k][j4] = -this.VMax;
                        }
                        double suma = ((Prototype)population[i5].get(k)).getInput(j4) + velocidad[i5][k][j4] * 1.0;
                        ((Prototype)population[i5].get(k)).setInput(j4, suma);
                        ((Prototype)population[i5].get(k)).applyThresholds();
                    }
                }
            }
            for (i5 = 0; i5 < this.SwarmSize; ++i5) {
                nominalPopulation = new PrototypeSet();
                nominalPopulation.formatear(population[i5]);
                fitness[i5] = PSOGenerator.accuracy(nominalPopulation, this.trainingDataSet);
            }
            for (i5 = 0; i5 < this.SwarmSize; ++i5) {
                if (fitness[i5] > bestFitness) {
                    bestFitness = fitness[i5];
                    bestFitnessIndex = i5;
                }
                if (!(fitness[i5] > fitness_bestPopulation[i5])) continue;
                fitness_bestPopulation[i5] = fitness[i5];
                mejorPosicion[i5] = population[i5].clone();
            }
            inertia = (this.Wstart - this.Wend) * (double)(this.MaxIter - iter) / ((double)this.MaxIter + this.Wend);
        }
        nominalPopulation = new PrototypeSet();
        nominalPopulation.formatear(mejorPosicion[bestFitnessIndex]);
        return nominalPopulation;
    }

    public static void main(String[] args) {
        Parameters.setUse("PSO", "<seed> <Number of neighbors>\n<Swarm size>\n<Particle Size>\n<MaxIter>\n<DistanceFunction>");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        PSOGenerator.setSeed(seed);
        int k = Parameters.assertExtendedArgAsInt(args, 3, "number of neighbors", 1.0, 2.147483647E9);
        int swarm = Parameters.assertExtendedArgAsInt(args, 4, "swarm size", 1.0, 2.147483647E9);
        int particle = Parameters.assertExtendedArgAsInt(args, 5, "particle size", 1.0, 2.147483647E9);
        int iter = Parameters.assertExtendedArgAsInt(args, 6, "max iter", 1.0, 2.147483647E9);
        double c1 = Parameters.assertExtendedArgAsInt(args, 7, "c1", 1.0, Double.MAX_VALUE);
        double c2 = Parameters.assertExtendedArgAsInt(args, 8, "c2", 1.0, Double.MAX_VALUE);
        double vmax = Parameters.assertExtendedArgAsInt(args, 9, "vmax", 1.0, Double.MAX_VALUE);
        double wstart = Parameters.assertExtendedArgAsInt(args, 10, "wstart", 1.0, Double.MAX_VALUE);
        double wend = Parameters.assertExtendedArgAsInt(args, 11, "wend", 1.0, Double.MAX_VALUE);
        PSOGenerator generator = new PSOGenerator(training, k, swarm, particle, iter, c1, c2, vmax, wstart, wend);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

