/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.IOException;
import java.io.InputStream;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.util.DroolsStreamUtils;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;

public class BinaryRuleBaseLoader {
    private KnowledgeBase kBase;
    private ClassLoader classLoader;

    public BinaryRuleBaseLoader() {
        this(KnowledgeBaseFactory.newKnowledgeBase(), null);
    }

    public BinaryRuleBaseLoader(KnowledgeBase kBase) {
        this(kBase, null);
    }

    public BinaryRuleBaseLoader(KnowledgeBase kBase, ClassLoader classLoader) {
        if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        this.kBase = kBase;
        this.classLoader = classLoader;
    }

    public void addPackage(InputStream in) {
        this.addPackage(in, this.classLoader);
    }

    public void addPackage(InputStream in, ClassLoader classLoader) {
        block14: {
            if (classLoader == null) {
                classLoader = this.classLoader;
            }
            try {
                Object opkg = DroolsStreamUtils.streamIn(in, classLoader);
                if (opkg instanceof InternalKnowledgePackage) {
                    InternalKnowledgePackage pkg = (InternalKnowledgePackage)opkg;
                    this.addPackage(pkg);
                    break block14;
                }
                if (opkg instanceof InternalKnowledgePackage[]) {
                    InternalKnowledgePackage[] pkgs;
                    for (InternalKnowledgePackage pkg : pkgs = (InternalKnowledgePackage[])opkg) {
                        this.addPackage(pkg);
                    }
                    break block14;
                }
                throw new IllegalArgumentException("Can only add instances of org.kie.rule.Package to a rulebase instance.");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void addPackage(InternalKnowledgePackage pkg) {
        if (!pkg.isValid()) {
            throw new IllegalArgumentException("Can't add a non valid package to a rulebase.");
        }
        try {
            ((InternalKnowledgeBase)this.kBase).addPackage(pkg);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to add package to the rulebase.", e);
        }
    }

    public KnowledgeBase getKnowledgeBase() {
        return this.kBase;
    }
}

