/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.randvar.NormalGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class NormalBoxMullerGen
extends NormalGen {
    private boolean available = false;
    private double[] variates = new double[2];
    private static double[] staticVariates = new double[2];

    public NormalBoxMullerGen(RandomStream s, double mu, double sigma) {
        super(s, null);
        this.setParams(mu, sigma);
    }

    public NormalBoxMullerGen(RandomStream s) {
        this(s, 0.0, 1.0);
    }

    public NormalBoxMullerGen(RandomStream s, NormalDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getMu(), dist.getSigma());
        }
    }

    public double nextDouble() {
        if (this.available) {
            this.available = false;
            return this.mu + this.sigma * this.variates[1];
        }
        NormalBoxMullerGen.boxMuller(this.stream, this.mu, this.sigma, this.variates);
        this.available = true;
        return this.mu + this.sigma * this.variates[0];
    }

    public static double nextDouble(RandomStream s, double mu, double sigma) {
        NormalBoxMullerGen.boxMuller(s, mu, sigma, staticVariates);
        return mu + sigma * staticVariates[0];
    }

    private static void boxMuller(RandomStream stream, double mu, double sigma, double[] variates) {
        double pi = Math.PI;
        double u = stream.nextDouble();
        double v = stream.nextDouble();
        double s = Math.sqrt(-2.0 * Math.log(u));
        variates[1] = s * Math.sin(Math.PI * 2 * v);
        variates[0] = s * Math.cos(Math.PI * 2 * v);
    }
}

