/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.special.mixedfrequencies;

import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetSerializable;
import ec.tstoolkit.timeseries.PeriodSelectorType;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.utilities.Jdk6;
import java.util.Map;
import java.util.Objects;

public class EstimateSpec
implements Cloneable,
InformationSetSerializable {
    public static final String SPAN = "span";
    public static final String METHOD = "method";
    public static final String TOL = "tol";
    private TsPeriodSelector span_ = new TsPeriodSelector();
    private Method method_ = Method.KalmanFilter;
    private double tol_ = 1.0E-9;
    public static final double DEF_TOL = 1.0E-9;
    public static final Method DEF_METHOD = Method.KalmanFilter;

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, METHOD), String.class);
        dic.put(InformationSet.item(prefix, TOL), Double.class);
        dic.put(InformationSet.item(prefix, SPAN), TsPeriodSelector.class);
        dic.put(InformationSet.item(prefix, SPAN), TsPeriodSelector.class);
    }

    public void reset() {
        this.span_ = new TsPeriodSelector();
        this.method_ = DEF_METHOD;
        this.tol_ = 1.0E-9;
    }

    public TsPeriodSelector getSpan() {
        return this.span_;
    }

    public void setSpan(TsPeriodSelector span) {
        if (span == null) {
            this.span_.all();
        } else {
            this.span_ = span;
        }
    }

    public Method getMethod() {
        return this.method_;
    }

    public void setMethod(Method value) {
        this.method_ = value;
    }

    public double getTol() {
        return this.tol_;
    }

    public void setTol(double value) {
        if (value <= 0.0 || value > 0.01) {
            throw new IllegalArgumentException("Invalid Tol parameter");
        }
        this.tol_ = value;
    }

    public boolean isDefault() {
        return this.method_ == DEF_METHOD && this.tol_ == 1.0E-9 && this.span_.getType() == PeriodSelectorType.All;
    }

    public EstimateSpec clone() {
        try {
            EstimateSpec spec = (EstimateSpec)super.clone();
            spec.span_ = this.span_.clone();
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public int hashCode() {
        int hash = 5;
        hash = 13 * hash + this.method_.hashCode();
        hash = 13 * hash + Jdk6.Double.hashCode(this.tol_);
        return hash;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof EstimateSpec && this.equals((EstimateSpec)obj);
    }

    private boolean equals(EstimateSpec other) {
        return this.method_ == other.method_ && this.tol_ == other.tol_ && Objects.equals(other.span_, this.span_);
    }

    @Override
    public InformationSet write(boolean verbose) {
        if (!verbose && this.isDefault()) {
            return null;
        }
        InformationSet info = new InformationSet();
        if (verbose || this.span_.getType() != PeriodSelectorType.All) {
            info.add(SPAN, this.span_);
        }
        if (verbose || this.method_ != DEF_METHOD) {
            info.add(METHOD, this.method_.name());
        }
        if (verbose || this.tol_ != 1.0E-9) {
            info.add(TOL, Double.valueOf(this.tol_));
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        try {
            String m;
            Double tol;
            this.reset();
            TsPeriodSelector span = info.get(SPAN, TsPeriodSelector.class);
            if (span != null) {
                this.span_ = span;
            }
            if ((tol = info.get(TOL, Double.class)) != null) {
                this.tol_ = tol;
            }
            if ((m = info.get(METHOD, String.class)) != null) {
                this.method_ = Method.valueOf(m);
            }
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }

    public static enum Method {
        KalmanFilter,
        Matrix,
        Cholesky;


        public boolean isMatrix() {
            return this != KalmanFilter;
        }
    }
}

