/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.NNEP_Common.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.AbstractDataset;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.CategoricalAttribute;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.DatasetException;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.FileDataset;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.IAttribute;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.Metadata;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.RealNumericalAttribute;

public class ArffDataSet
extends FileDataset {
    private static final long serialVersionUID = 1L;
    static String ARFF_RELATION = "@relation";
    static String ARFF_ATTRIBUTE = "@attribute";
    static String ARFF_DATA = "@data";
    protected String missedValue = "?";
    protected String commentedValue = "%";
    protected String separationValue = ",";
    protected String bufferInstance = new String();

    public ArffDataSet(String fileName, String ... specificationFile) {
        super(fileName);
    }

    public ArffDataSet() {
    }

    @Override
    public void open() {
        this.obtainMetadata(this.fileName);
        this.cursorPosition = 0;
        this.cursorInstance = new AbstractDataset.Instance();
    }

    @Override
    public void reset() {
        try {
            this.fileReader.close();
            this.fileReader = new BufferedReader(new FileReader(new File(this.fileName)));
            String line = ((BufferedReader)this.fileReader).readLine();
            while (!line.equalsIgnoreCase(ARFF_DATA)) {
                line = ((BufferedReader)this.fileReader).readLine();
            }
            this.bufferInstance = ((BufferedReader)this.fileReader).readLine();
            while (this.bufferInstance.startsWith(this.commentedValue) || this.bufferInstance.equalsIgnoreCase("")) {
                this.bufferInstance = ((BufferedReader)this.fileReader).readLine();
            }
            this.cursorPosition = 0;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean next() throws DatasetException {
        if (this.bufferInstance != null) {
            try {
                ++this.cursorPosition;
                StringTokenizer token = new StringTokenizer(this.bufferInstance, this.separationValue);
                int numAttributes = 0;
                while (token.hasMoreTokens()) {
                    IAttribute attribute = this.metadata.getAttribute(numAttributes);
                    double value = attribute.parse(token.nextToken());
                    this.cursorInstance.setValue(numAttributes, value);
                    ++numAttributes;
                }
                this.prepareNextInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    @Override
    public AbstractDataset.Instance read() throws DatasetException {
        return this.cursorInstance;
    }

    @Override
    public void close() throws DatasetException {
        try {
            this.fileReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void obtainMetadata(String file) {
        File f1 = new File(file);
        this.metadata = new Metadata();
        try {
            this.fileReader = new BufferedReader(new FileReader(f1));
            String line = ((BufferedReader)this.fileReader).readLine();
            int indexAttribute = 0;
            StringTokenizer elementLine = new StringTokenizer(line);
            String element = elementLine.nextToken();
            while (!element.equalsIgnoreCase(ARFF_DATA)) {
                if (element.equalsIgnoreCase(ARFF_ATTRIBUTE)) {
                    ++indexAttribute;
                    String name = elementLine.nextToken();
                    String type = elementLine.nextToken();
                    this.addAttributeToSpecification(type, name);
                }
                if (element.equalsIgnoreCase(ARFF_RELATION)) {
                    this.setName(elementLine.nextToken());
                }
                line = ((BufferedReader)this.fileReader).readLine();
                while (line.startsWith(this.commentedValue) || line.equalsIgnoreCase("")) {
                    line = ((BufferedReader)this.fileReader).readLine();
                }
                elementLine = new StringTokenizer(line);
                element = elementLine.nextToken();
            }
            this.bufferInstance = ((BufferedReader)this.fileReader).readLine();
            while (this.bufferInstance.startsWith(this.commentedValue) || this.bufferInstance.equalsIgnoreCase("")) {
                this.bufferInstance = ((BufferedReader)this.fileReader).readLine();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void prepareNextInstance() {
        try {
            String lineInstance = ((BufferedReader)this.fileReader).readLine();
            while (lineInstance.startsWith(this.commentedValue) || lineInstance.equalsIgnoreCase("")) {
                lineInstance = ((BufferedReader)this.fileReader).readLine();
            }
            this.bufferInstance = lineInstance;
        }
        catch (Exception e) {
            this.bufferInstance = null;
        }
    }

    private void addAttributeToSpecification(String type, String name) {
        if (type.equalsIgnoreCase("REAL") || type.equalsIgnoreCase("NUMERIC") || type.equalsIgnoreCase("INTEGER")) {
            RealNumericalAttribute attribute = new RealNumericalAttribute();
            attribute.setName(name);
            this.metadata.addAttribute(attribute);
        } else if (!type.equalsIgnoreCase("DATE")) {
            int minIndex = type.indexOf("{");
            int maxIndex = type.indexOf("}");
            type = type.substring(minIndex + 1, maxIndex);
            if (minIndex < maxIndex) {
                CategoricalAttribute attribute = new CategoricalAttribute();
                attribute.setName(name);
                StringTokenizer categories = new StringTokenizer(type, ",");
                while (categories.hasMoreTokens()) {
                    attribute.addValue(categories.nextToken());
                }
                this.metadata.addAttribute(attribute);
            }
        }
    }
}

