/*
 * Decompiled with CFR 0.152.
 */
import choco.Choco;
import choco.cp.model.CPModel;
import choco.cp.solver.CPSolver;
import choco.cp.solver.search.integer.varselector.StaticVarOrder;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.SConstraint;
import java.io.IOException;
import java.util.StringTokenizer;

public class smi {
    public String sayHello(String[] args) throws IOException, ContradictionException {
        int i;
        boolean search = true;
        long totalTime = System.currentTimeMillis();
        long readTime = System.currentTimeMillis();
        String[] fin = args[0].split("n");
        int n = Integer.parseInt(fin[0]);
        int[][] pref = new int[n][n];
        int[][] rank = new int[n][n];
        int[] length = new int[n];
        for (i = 0; i < n; ++i) {
            StringTokenizer st = new StringTokenizer(fin[i + 1], " ");
            int k = 0;
            length[i] = 0;
            while (st.hasMoreTokens()) {
                int j = Integer.parseInt(st.nextToken()) - 1;
                rank[i][j] = k;
                pref[i][k] = j;
                length[i] = length[i] + 1;
                ++k;
            }
            rank[i][i] = k;
            pref[i][k] = i;
        }
        readTime = System.currentTimeMillis() - readTime;
        long modelTime = System.currentTimeMillis();
        CPModel model = new CPModel();
        Variable[] agent = new IntegerVariable[n];
        for (i = 0; i < n; ++i) {
            agent[i] = Choco.makeIntVar("agent_" + i, 0, length[i], "cp:enum");
        }
        model.addVariables(agent);
        CPSolver solver = new CPSolver();
        solver.read(model);
        solver.post((SConstraint)new SRN(solver, solver.getVar((IntegerVariable[])agent), pref, rank, length));
        modelTime = System.currentTimeMillis() - modelTime;
        long modelSize = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L;
        int matchingSize = 0;
        int solutions = 0;
        long solveTime = System.currentTimeMillis();
        solver.setVarIntSelector(new StaticVarOrder(solver, solver.getVar((IntegerVariable[])agent)));
        StringBuilder sb = new StringBuilder();
        if (solver.solve().booleanValue()) {
            int j;
            int i2;
            matchingSize = 0;
            for (i2 = 0; i2 < n; ++i2) {
                if (solver.getVar((IntegerVariable)agent[i2]).getVal() >= length[i2]) continue;
                ++matchingSize;
            }
            matchingSize /= 2;
            for (i2 = 0; i2 < n; ++i2) {
                j = pref[i2][solver.getVar((IntegerVariable)agent[i2]).getVal()];
                if (i2 >= j) continue;
                sb.append("1," + (i2 + 1) + "," + (j + 1) + "\n");
            }
            solutions = 1;
            while (solver.nextSolution().booleanValue()) {
                ++solutions;
                for (i2 = 0; i2 < n; ++i2) {
                    j = pref[i2][solver.getVar((IntegerVariable)agent[i2]).getVal()];
                    if (i2 >= j) continue;
                    sb.append(solutions + "," + (i2 + 1) + "," + (j + 1) + "\n");
                }
            }
        }
        solveTime = System.currentTimeMillis() - solveTime;
        totalTime = System.currentTimeMillis() - totalTime;
        sb.append("\n");
        sb.append("solutions:" + solutions + "\n");
        if (search) {
            sb.append("nodes:" + solver.getNodeCount() + "\n");
        }
        sb.append("modelTime:" + modelTime + "\n");
        if (search) {
            sb.append("solveTime:" + solveTime + "\n");
        }
        sb.append("totalTime:" + totalTime + "\n");
        sb.append("modelSize:" + modelSize + "\n");
        sb.append("readTime:" + readTime + "\n");
        sb.append("matchingSize:" + matchingSize);
        String result = sb.toString();
        return result;
    }

    public static void main(String[] args) throws IOException, ContradictionException {
    }
}

