/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble;

import cern.colt.function.tdouble.Double27Function;
import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.DoubleProcedure;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix2DProcedure;
import cern.colt.matrix.tdouble.algo.DoubleFormatter;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.algo.DoubleSorting;
import cern.jet.math.tdouble.DoubleFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class DoubleMatrix3D
extends AbstractMatrix3D {
    private static final long serialVersionUID = 1L;

    protected DoubleMatrix3D() {
    }

    public double aggregate(final DoubleDoubleFunction doubleDoubleFunction, final DoubleFunction doubleFunction) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        double d = 0.0;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = doubleFunction.apply(DoubleMatrix3D.this.getQuick(n3, 0, 0));
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DoubleMatrix3D.this.rows; ++j) {
                                for (int k = n; k < DoubleMatrix3D.this.columns; ++k) {
                                    d = doubleDoubleFunction.apply(d, doubleFunction.apply(DoubleMatrix3D.this.getQuick(i, j, k)));
                                }
                                n = 0;
                            }
                        }
                        return d;
                    }
                });
            }
            d = ConcurrencyUtils.waitForCompletion(futureArray, doubleDoubleFunction);
        } else {
            d = doubleFunction.apply(this.getQuick(0, 0, 0));
            int n5 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n5; k < this.columns; ++k) {
                        d = doubleDoubleFunction.apply(d, doubleFunction.apply(this.getQuick(i, j, k)));
                    }
                    n5 = 0;
                }
            }
        }
        return d;
    }

    public double aggregate(final DoubleDoubleFunction doubleDoubleFunction, final DoubleFunction doubleFunction, final DoubleProcedure doubleProcedure) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        double d = 0.0;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = DoubleMatrix3D.this.getQuick(n3, 0, 0);
                        double d2 = 0.0;
                        if (doubleProcedure.apply(d)) {
                            d2 = doubleDoubleFunction.apply(d2, doubleFunction.apply(d));
                        }
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DoubleMatrix3D.this.rows; ++j) {
                                for (int k = n; k < DoubleMatrix3D.this.columns; ++k) {
                                    d = DoubleMatrix3D.this.getQuick(i, j, k);
                                    if (doubleProcedure.apply(d)) {
                                        d2 = doubleDoubleFunction.apply(d2, doubleFunction.apply(d));
                                    }
                                    n = 0;
                                }
                            }
                        }
                        return d2;
                    }
                });
            }
            d = ConcurrencyUtils.waitForCompletion(futureArray, doubleDoubleFunction);
        } else {
            double d2 = this.getQuick(0, 0, 0);
            if (doubleProcedure.apply(d2)) {
                d = doubleDoubleFunction.apply(d, doubleFunction.apply(d2));
            }
            int n5 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n5; k < this.columns; ++k) {
                        d2 = this.getQuick(i, j, k);
                        if (doubleProcedure.apply(d2)) {
                            d = doubleDoubleFunction.apply(d, doubleFunction.apply(d2));
                        }
                        n5 = 0;
                    }
                }
            }
        }
        return d;
    }

    public double aggregate(final DoubleDoubleFunction doubleDoubleFunction, final DoubleFunction doubleFunction, IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        if (intArrayList.size() == 0 || intArrayList2.size() == 0 || intArrayList3.size() == 0) {
            return Double.NaN;
        }
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        final int[] nArray3 = intArrayList3.elements();
        double d = 0.0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = doubleFunction.apply(DoubleMatrix3D.this.getQuick(nArray[n4], nArray2[n4], nArray3[n4]));
                        for (int i = n4 + 1; i < n5; ++i) {
                            double d2 = DoubleMatrix3D.this.getQuick(nArray[i], nArray2[i], nArray3[i]);
                            d = doubleDoubleFunction.apply(d, doubleFunction.apply(d2));
                        }
                        return d;
                    }
                });
            }
            d = ConcurrencyUtils.waitForCompletion(futureArray, doubleDoubleFunction);
        } else {
            d = doubleFunction.apply(this.getQuick(nArray[0], nArray2[0], nArray3[0]));
            for (int i = 1; i < n; ++i) {
                double d2 = this.getQuick(nArray[i], nArray2[i], nArray3[i]);
                d = doubleDoubleFunction.apply(d, doubleFunction.apply(d2));
            }
        }
        return d;
    }

    public double aggregate(final DoubleMatrix3D doubleMatrix3D, final DoubleDoubleFunction doubleDoubleFunction, final DoubleDoubleFunction doubleDoubleFunction2) {
        this.checkShape(doubleMatrix3D);
        if (this.size() == 0L) {
            return Double.NaN;
        }
        double d = 0.0;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = doubleDoubleFunction2.apply(DoubleMatrix3D.this.getQuick(n3, 0, 0), doubleMatrix3D.getQuick(n3, 0, 0));
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DoubleMatrix3D.this.rows; ++j) {
                                for (int k = n; k < DoubleMatrix3D.this.columns; ++k) {
                                    d = doubleDoubleFunction.apply(d, doubleDoubleFunction2.apply(DoubleMatrix3D.this.getQuick(i, j, k), doubleMatrix3D.getQuick(i, j, k)));
                                }
                                n = 0;
                            }
                        }
                        return d;
                    }
                });
            }
            d = ConcurrencyUtils.waitForCompletion(futureArray, doubleDoubleFunction);
        } else {
            d = doubleDoubleFunction2.apply(this.getQuick(0, 0, 0), doubleMatrix3D.getQuick(0, 0, 0));
            int n5 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n5; k < this.columns; ++k) {
                        d = doubleDoubleFunction.apply(d, doubleDoubleFunction2.apply(this.getQuick(i, j, k), doubleMatrix3D.getQuick(i, j, k)));
                    }
                    n5 = 0;
                }
            }
        }
        return d;
    }

    public DoubleMatrix3D assign(final DoubleFunction doubleFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DoubleMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < DoubleMatrix3D.this.columns; ++k) {
                                    DoubleMatrix3D.this.setQuick(i, j, k, doubleFunction.apply(DoubleMatrix3D.this.getQuick(i, j, k)));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, doubleFunction.apply(this.getQuick(i, j, k)));
                    }
                }
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(final DoubleProcedure doubleProcedure, final DoubleFunction doubleFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DoubleMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < DoubleMatrix3D.this.columns; ++k) {
                                    double d = DoubleMatrix3D.this.getQuick(i, j, k);
                                    if (!doubleProcedure.apply(d)) continue;
                                    DoubleMatrix3D.this.setQuick(i, j, k, doubleFunction.apply(d));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        double d = this.getQuick(i, j, k);
                        if (!doubleProcedure.apply(d)) continue;
                        this.setQuick(i, j, k, doubleFunction.apply(d));
                    }
                }
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(final DoubleProcedure doubleProcedure, final double d) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DoubleMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < DoubleMatrix3D.this.columns; ++k) {
                                    double d2 = DoubleMatrix3D.this.getQuick(i, j, k);
                                    if (!doubleProcedure.apply(d2)) continue;
                                    DoubleMatrix3D.this.setQuick(i, j, k, d);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        double d2 = this.getQuick(i, j, k);
                        if (!doubleProcedure.apply(d2)) continue;
                        this.setQuick(i, j, k, d);
                    }
                }
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(final double d) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DoubleMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < DoubleMatrix3D.this.columns; ++k) {
                                    DoubleMatrix3D.this.setQuick(i, j, k, d);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, d);
                    }
                }
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(final double[] dArray) {
        if (dArray.length != this.slices * this.rows * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + dArray.length + "slices()*rows()*columns()=" + this.slices() * this.rows() * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n3 * DoubleMatrix3D.this.rows * DoubleMatrix3D.this.columns;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DoubleMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < DoubleMatrix3D.this.columns; ++k) {
                                    DoubleMatrix3D.this.setQuick(i, j, k, dArray[n++]);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = 0;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, dArray[n5++]);
                    }
                }
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(final double[][][] dArray) {
        if (dArray.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + dArray.length + "slices()=" + this.slices());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            double[][] dArray3 = dArray[i];
                            if (dArray3.length != DoubleMatrix3D.this.rows) {
                                throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + dArray3.length + "rows()=" + DoubleMatrix3D.this.rows());
                            }
                            for (int j = 0; j < DoubleMatrix3D.this.rows; ++j) {
                                double[] dArray2 = dArray3[j];
                                if (dArray2.length != DoubleMatrix3D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray2.length + "columns()=" + DoubleMatrix3D.this.columns());
                                }
                                for (int k = 0; k < DoubleMatrix3D.this.columns; ++k) {
                                    DoubleMatrix3D.this.setQuick(i, j, k, dArray2[k]);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                double[][] dArray2 = dArray[i];
                if (dArray2.length != this.rows) {
                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + dArray2.length + "rows()=" + this.rows());
                }
                for (int j = 0; j < this.rows; ++j) {
                    double[] dArray3 = dArray2[j];
                    if (dArray3.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray3.length + "columns()=" + this.columns());
                    }
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, dArray3[k]);
                    }
                }
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(DoubleMatrix3D doubleMatrix3D) {
        if (doubleMatrix3D == this) {
            return this;
        }
        this.checkShape(doubleMatrix3D);
        final DoubleMatrix3D doubleMatrix3D2 = this.haveSharedCells(doubleMatrix3D) ? doubleMatrix3D.copy() : doubleMatrix3D;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DoubleMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < DoubleMatrix3D.this.columns; ++k) {
                                    DoubleMatrix3D.this.setQuick(i, j, k, doubleMatrix3D2.getQuick(i, j, k));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, doubleMatrix3D2.getQuick(i, j, k));
                    }
                }
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(final DoubleMatrix3D doubleMatrix3D, final DoubleDoubleFunction doubleDoubleFunction) {
        this.checkShape(doubleMatrix3D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DoubleMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < DoubleMatrix3D.this.columns; ++k) {
                                    DoubleMatrix3D.this.setQuick(i, j, k, doubleDoubleFunction.apply(DoubleMatrix3D.this.getQuick(i, j, k), doubleMatrix3D.getQuick(i, j, k)));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, doubleDoubleFunction.apply(this.getQuick(i, j, k), doubleMatrix3D.getQuick(i, j, k)));
                    }
                }
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(final DoubleMatrix3D doubleMatrix3D, final DoubleDoubleFunction doubleDoubleFunction, IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3) {
        this.checkShape(doubleMatrix3D);
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        final int[] nArray3 = intArrayList3.elements();
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            DoubleMatrix3D.this.setQuick(nArray[i], nArray2[i], nArray3[i], doubleDoubleFunction.apply(DoubleMatrix3D.this.getQuick(nArray[i], nArray2[i], nArray3[i]), doubleMatrix3D.getQuick(nArray[i], nArray2[i], nArray3[i])));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n; ++i) {
                this.setQuick(nArray[i], nArray2[i], nArray3[i], doubleDoubleFunction.apply(this.getQuick(nArray[i], nArray2[i], nArray3[i]), doubleMatrix3D.getQuick(nArray[i], nArray2[i], nArray3[i])));
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n3;
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.slices / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.slices : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        for (int i = n5; i < n6; ++i) {
                            for (int j = 0; j < DoubleMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < DoubleMatrix3D.this.columns; ++k) {
                                    if (DoubleMatrix3D.this.getQuick(i, j, k) == 0.0) continue;
                                    ++n;
                                }
                            }
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        if (this.getQuick(i, j, k) == 0.0) continue;
                        ++n;
                    }
                }
            }
        }
        return n;
    }

    public DoubleMatrix3D copy() {
        return this.like().assign(this);
    }

    public abstract Object elements();

    public boolean equals(double d) {
        return DoubleProperty.DEFAULT.equals(this, d);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof DoubleMatrix3D)) {
            return false;
        }
        return DoubleProperty.DEFAULT.equals(this, (DoubleMatrix3D)object);
    }

    public double get(int n, int n2, int n3) {
        if (n < 0 || n >= this.slices || n2 < 0 || n2 >= this.rows || n3 < 0 || n3 >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + n + ", row:" + n2 + ", column:" + n3);
        }
        return this.getQuick(n, n2, n3);
    }

    public double[] getMaxLocation() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        double d = 0.0;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n5;
            n4 = Math.min(n4, this.slices);
            Future[] futureArray = new Future[n4];
            double[][] dArray = new double[n4][2];
            int n6 = this.slices / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? this.slices : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int n = n7;
                        int n2 = 0;
                        int n3 = 0;
                        double d = DoubleMatrix3D.this.getQuick(n, 0, 0);
                        int n4 = 1;
                        for (int i = n7; i < n8; ++i) {
                            for (int j = 0; j < DoubleMatrix3D.this.rows; ++j) {
                                for (int k = n4; k < DoubleMatrix3D.this.columns; ++k) {
                                    double d2 = DoubleMatrix3D.this.getQuick(i, j, k);
                                    if (!(d < d2)) continue;
                                    d = d2;
                                    n = i;
                                    n2 = j;
                                    n3 = k;
                                }
                                n4 = 0;
                            }
                        }
                        return new double[]{d, n, n2, n3};
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    dArray[n5] = (double[])futureArray[n5].get();
                }
                d = dArray[0][0];
                n = (int)dArray[0][1];
                n2 = (int)dArray[0][2];
                n3 = (int)dArray[0][3];
                for (n5 = 1; n5 < n4; ++n5) {
                    if (!(d < dArray[n5][0])) continue;
                    d = dArray[n5][0];
                    n = (int)dArray[n5][1];
                    n2 = (int)dArray[n5][2];
                    n3 = (int)dArray[n5][3];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            d = this.getQuick(0, 0, 0);
            int n9 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n9; k < this.columns; ++k) {
                        double d2 = this.getQuick(i, j, k);
                        if (!(d < d2)) continue;
                        d = d2;
                        n = i;
                        n2 = j;
                        n3 = k;
                    }
                    n9 = 0;
                }
            }
        }
        return new double[]{d, n, n2, n3};
    }

    public double[] getMinLocation() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        double d = 0.0;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n5;
            n4 = Math.min(n4, this.slices);
            Future[] futureArray = new Future[n4];
            double[][] dArray = new double[n4][2];
            int n6 = this.slices / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? this.slices : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int n = n7;
                        int n2 = 0;
                        int n3 = 0;
                        double d = DoubleMatrix3D.this.getQuick(n, 0, 0);
                        int n4 = 1;
                        for (int i = n7; i < n8; ++i) {
                            for (int j = 0; j < DoubleMatrix3D.this.rows; ++j) {
                                for (int k = n4; k < DoubleMatrix3D.this.columns; ++k) {
                                    double d2 = DoubleMatrix3D.this.getQuick(i, j, k);
                                    if (!(d > d2)) continue;
                                    d = d2;
                                    n = i;
                                    n2 = j;
                                    n3 = k;
                                }
                                n4 = 0;
                            }
                        }
                        return new double[]{d, n, n2, n3};
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    dArray[n5] = (double[])futureArray[n5].get();
                }
                d = dArray[0][0];
                n = (int)dArray[0][1];
                n2 = (int)dArray[0][2];
                n3 = (int)dArray[0][3];
                for (n5 = 1; n5 < n4; ++n5) {
                    if (!(d > dArray[n5][0])) continue;
                    d = dArray[n5][0];
                    n = (int)dArray[n5][1];
                    n2 = (int)dArray[n5][2];
                    n3 = (int)dArray[n5][3];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            d = this.getQuick(0, 0, 0);
            int n9 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n9; k < this.columns; ++k) {
                        double d2 = this.getQuick(i, j, k);
                        if (!(d > d2)) continue;
                        d = d2;
                        n = i;
                        n2 = j;
                        n3 = k;
                    }
                    n9 = 0;
                }
            }
        }
        return new double[]{d, n, n2, n3};
    }

    public void getNegativeValues(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, DoubleArrayList doubleArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        doubleArrayList.clear();
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                for (int k = 0; k < this.columns; ++k) {
                    double d = this.getQuick(i, j, k);
                    if (!(d < 0.0)) continue;
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    intArrayList3.add(k);
                    doubleArrayList.add(d);
                }
            }
        }
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, DoubleArrayList doubleArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        doubleArrayList.clear();
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                for (int k = 0; k < this.columns; ++k) {
                    double d = this.getQuick(i, j, k);
                    if (d == 0.0) continue;
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    intArrayList3.add(k);
                    doubleArrayList.add(d);
                }
            }
        }
    }

    public void getPositiveValues(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, DoubleArrayList doubleArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        doubleArrayList.clear();
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                for (int k = 0; k < this.columns; ++k) {
                    double d = this.getQuick(i, j, k);
                    if (!(d > 0.0)) continue;
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    intArrayList3.add(k);
                    doubleArrayList.add(d);
                }
            }
        }
    }

    public abstract double getQuick(int var1, int var2, int var3);

    public DoubleMatrix3D like() {
        return this.like(this.slices, this.rows, this.columns);
    }

    public abstract DoubleMatrix3D like(int var1, int var2, int var3);

    public abstract DoubleMatrix2D like2D(int var1, int var2);

    public void normalize() {
        double d = this.getMinLocation()[0];
        if (d < 0.0) {
            this.assign(DoubleFunctions.minus(d));
        }
        if (this.getMaxLocation()[0] == 0.0) {
            this.assign(1.0 / (double)this.size());
        } else {
            double d2 = this.zSum();
            d2 = 1.0 / d2;
            this.assign(DoubleFunctions.mult(d2));
        }
    }

    public void set(int n, int n2, int n3, double d) {
        if (n < 0 || n >= this.slices || n2 < 0 || n2 >= this.rows || n3 < 0 || n3 >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + n + ", row:" + n2 + ", column:" + n3);
        }
        this.setQuick(n, n2, n3, d);
    }

    public abstract void setQuick(int var1, int var2, int var3, double var4);

    public double[][][] toArray() {
        final double[][][] dArray = new double[this.slices][this.rows][this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            double[][] dArray3 = dArray[i];
                            for (int j = 0; j < DoubleMatrix3D.this.rows; ++j) {
                                double[] dArray2 = dArray3[j];
                                for (int k = 0; k < DoubleMatrix3D.this.columns; ++k) {
                                    dArray2[k] = DoubleMatrix3D.this.getQuick(i, j, k);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                double[][] dArray2 = dArray[i];
                for (int j = 0; j < this.rows; ++j) {
                    double[] dArray3 = dArray2[j];
                    for (int k = 0; k < this.columns; ++k) {
                        dArray3[k] = this.getQuick(i, j, k);
                    }
                }
            }
        }
        return dArray;
    }

    public String toString() {
        return new DoubleFormatter().toString(this);
    }

    public abstract DoubleMatrix1D vectorize();

    public DoubleMatrix2D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.slices;
        int n3 = this.rows;
        int n4 = this.sliceZero;
        int n5 = this.rowZero + this._columnOffset(this._columnRank(n));
        int n6 = this.sliceStride;
        int n7 = this.rowStride;
        return this.like2D(n2, n3, n4, n5, n6, n7);
    }

    public DoubleMatrix3D viewColumnFlip() {
        return (DoubleMatrix3D)this.view().vColumnFlip();
    }

    public DoubleMatrix3D viewDice(int n, int n2, int n3) {
        return (DoubleMatrix3D)this.view().vDice(n, n2, n3);
    }

    public DoubleMatrix3D viewPart(int n, int n2, int n3, int n4, int n5, int n6) {
        return (DoubleMatrix3D)this.view().vPart(n, n2, n3, n4, n5, n6);
    }

    public DoubleMatrix2D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.slices;
        int n3 = this.columns;
        int n4 = this.sliceZero;
        int n5 = this.columnZero + this._rowOffset(this._rowRank(n));
        int n6 = this.sliceStride;
        int n7 = this.columnStride;
        return this.like2D(n2, n3, n4, n5, n6, n7);
    }

    public DoubleMatrix3D viewRowFlip() {
        return (DoubleMatrix3D)this.view().vRowFlip();
    }

    public DoubleMatrix3D viewSelection(DoubleMatrix2DProcedure doubleMatrix2DProcedure) {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < this.slices; ++i) {
            if (!doubleMatrix2DProcedure.apply(this.viewSlice(i))) continue;
            intArrayList.add(i);
        }
        intArrayList.trimToSize();
        return this.viewSelection(intArrayList.elements(), null, null);
    }

    public DoubleMatrix3D viewSelection(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        int n2;
        if (nArray == null) {
            nArray = new int[this.slices];
            for (n2 = 0; n2 < this.slices; ++n2) {
                nArray[n2] = n2;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.rows];
            for (n2 = 0; n2 < this.rows; ++n2) {
                nArray2[n2] = n2;
            }
        }
        if (nArray3 == null) {
            nArray3 = new int[this.columns];
            for (n2 = 0; n2 < this.columns; ++n2) {
                nArray3[n2] = n2;
            }
        }
        this.checkSliceIndexes(nArray);
        this.checkRowIndexes(nArray2);
        this.checkColumnIndexes(nArray3);
        int[] nArray4 = new int[nArray.length];
        int[] nArray5 = new int[nArray2.length];
        int[] nArray6 = new int[nArray3.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray4[n] = this._sliceOffset(this._sliceRank(nArray[n]));
        }
        for (n = 0; n < nArray2.length; ++n) {
            nArray5[n] = this._rowOffset(this._rowRank(nArray2[n]));
        }
        for (n = 0; n < nArray3.length; ++n) {
            nArray6[n] = this._columnOffset(this._columnRank(nArray3[n]));
        }
        return this.viewSelectionLike(nArray4, nArray5, nArray6);
    }

    public DoubleMatrix2D viewSlice(int n) {
        this.checkSlice(n);
        int n2 = this.rows;
        int n3 = this.columns;
        int n4 = this.rowZero;
        int n5 = this.columnZero + this._sliceOffset(this._sliceRank(n));
        int n6 = this.rowStride;
        int n7 = this.columnStride;
        return this.like2D(n2, n3, n4, n5, n6, n7);
    }

    public DoubleMatrix3D viewSliceFlip() {
        return (DoubleMatrix3D)this.view().vSliceFlip();
    }

    public DoubleMatrix3D viewSorted(int n, int n2) {
        return DoubleSorting.mergeSort.sort(this, n, n2);
    }

    public DoubleMatrix3D viewStrides(int n, int n2, int n3) {
        return (DoubleMatrix3D)this.view().vStrides(n, n2, n3);
    }

    public void zAssign27Neighbors(DoubleMatrix3D doubleMatrix3D, Double27Function double27Function) {
        if (double27Function == null) {
            throw new NullPointerException("function must not be null.");
        }
        this.checkShape(doubleMatrix3D);
        if (this.rows < 3 || this.columns < 3 || this.slices < 3) {
            return;
        }
        int n = this.rows - 1;
        int n2 = this.columns - 1;
        for (int i = 1; i < this.slices - 1; ++i) {
            for (int j = 1; j < n; ++j) {
                double d = this.getQuick(i - 1, j - 1, 0);
                double d2 = this.getQuick(i - 1, j - 1, 1);
                double d3 = this.getQuick(i - 1, j, 0);
                double d4 = this.getQuick(i - 1, j, 1);
                double d5 = this.getQuick(i - 1, j + 1, 0);
                double d6 = this.getQuick(i - 1, j + 1, 1);
                double d7 = this.getQuick(i - 1, j - 1, 0);
                double d8 = this.getQuick(i, j - 1, 1);
                double d9 = this.getQuick(i, j, 0);
                double d10 = this.getQuick(i, j, 1);
                double d11 = this.getQuick(i, j + 1, 0);
                double d12 = this.getQuick(i, j + 1, 1);
                double d13 = this.getQuick(i + 1, j - 1, 0);
                double d14 = this.getQuick(i + 1, j - 1, 1);
                double d15 = this.getQuick(i + 1, j, 0);
                double d16 = this.getQuick(i + 1, j, 1);
                double d17 = this.getQuick(i + 1, j + 1, 0);
                double d18 = this.getQuick(i + 1, j + 1, 1);
                for (int k = 1; k < n2; ++k) {
                    double d19 = this.getQuick(i - 1, j - 1, k + 1);
                    double d20 = this.getQuick(i - 1, j, k + 1);
                    double d21 = this.getQuick(i - 1, j + 1, k + 1);
                    double d22 = this.getQuick(i, j - 1, k + 1);
                    double d23 = this.getQuick(i, j, k + 1);
                    double d24 = this.getQuick(i, j + 1, k + 1);
                    double d25 = this.getQuick(i + 1, j - 1, k + 1);
                    double d26 = this.getQuick(i + 1, j, k + 1);
                    double d27 = this.getQuick(i + 1, j + 1, k + 1);
                    doubleMatrix3D.setQuick(i, j, k, double27Function.apply(d, d2, d19, d3, d4, d20, d5, d6, d21, d7, d8, d22, d9, d10, d23, d11, d12, d24, d13, d14, d25, d15, d16, d26, d17, d18, d27));
                    d = d2;
                    d2 = d19;
                    d3 = d4;
                    d4 = d20;
                    d5 = d6;
                    d6 = d21;
                    d7 = d8;
                    d8 = d22;
                    d9 = d10;
                    d10 = d23;
                    d11 = d12;
                    d12 = d24;
                    d13 = d14;
                    d14 = d25;
                    d15 = d16;
                    d16 = d26;
                    d17 = d18;
                    d18 = d27;
                }
            }
        }
    }

    public double zSum() {
        if (this.size() == 0L) {
            return 0.0;
        }
        return this.aggregate(DoubleFunctions.plus, DoubleFunctions.identity);
    }

    protected DoubleMatrix3D getContent() {
        return this;
    }

    protected boolean haveSharedCells(DoubleMatrix3D doubleMatrix3D) {
        if (doubleMatrix3D == null) {
            return false;
        }
        if (this == doubleMatrix3D) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(doubleMatrix3D.getContent());
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix3D doubleMatrix3D) {
        return false;
    }

    protected abstract DoubleMatrix2D like2D(int var1, int var2, int var3, int var4, int var5, int var6);

    protected DoubleMatrix3D view() {
        return (DoubleMatrix3D)this.clone();
    }

    protected abstract DoubleMatrix3D viewSelectionLike(int[] var1, int[] var2, int[] var3);
}

