/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.util.dataset;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import net.sourceforge.jclec.util.dataset.AbstractDataset;
import net.sourceforge.jclec.util.dataset.CategoricalAttribute;
import net.sourceforge.jclec.util.dataset.DatasetException;
import net.sourceforge.jclec.util.dataset.FileDataset;
import net.sourceforge.jclec.util.dataset.IAttribute;
import net.sourceforge.jclec.util.dataset.IDataset;
import net.sourceforge.jclec.util.dataset.IntegerAttribute;
import net.sourceforge.jclec.util.dataset.Metadata;
import net.sourceforge.jclec.util.dataset.NumericalAttribute;
import net.sourceforge.jclec.util.intset.Closure;
import net.sourceforge.jclec.util.range.Interval;

public class KeelDataSet
extends FileDataset {
    private static final long serialVersionUID = 1L;
    static String KEEL_RELATION = "@relation";
    static String KEEL_ATTRIBUTE = "@attribute";
    static String KEEL_DATA = "@data";
    static String KEEL_OUTPUT = "@output";
    protected String missedValue = "?";
    protected String commentedValue = "%";
    protected String separationValue = ",";
    protected String bufferInstance = new String();
    protected IDataset.IInstance[] instances;

    @Override
    public void loadInstances() {
        try {
            int numInstances = this.numberOfInstances();
            IDataset.IInstance[] instances = new IDataset.IInstance[numInstances];
            this.reset();
            int i = 0;
            while (i < numInstances) {
                this.next();
                instances[i] = this.read().copy();
                ++i;
            }
            this.setInstances(instances);
        }
        catch (DatasetException e) {
            e.printStackTrace();
        }
    }

    public void setInstances(IDataset.IInstance[] instances) {
        this.instances = instances;
    }

    @Override
    public IDataset.IInstance[] getInstances() {
        return this.instances;
    }

    @Override
    public void open() {
        this.obtainMetadata(this.fileName);
        this.cursorPosition = 0;
        this.cursorInstance = new AbstractDataset.Instance();
    }

    @Override
    public void reset() {
        try {
            this.fileReader.close();
            this.fileReader = new BufferedReader(new FileReader(new File(this.fileName)));
            String line = ((BufferedReader)this.fileReader).readLine();
            while (!line.equalsIgnoreCase(KEEL_DATA)) {
                line = ((BufferedReader)this.fileReader).readLine();
            }
            this.bufferInstance = ((BufferedReader)this.fileReader).readLine();
            while (this.bufferInstance.startsWith(this.commentedValue) || this.bufferInstance.equalsIgnoreCase("")) {
                this.bufferInstance = ((BufferedReader)this.fileReader).readLine();
            }
            this.cursorPosition = 0;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean next() throws DatasetException {
        if (this.bufferInstance != null) {
            try {
                ++this.cursorPosition;
                StringTokenizer token = new StringTokenizer(this.bufferInstance, this.separationValue);
                int numAttributes = 0;
                while (token.hasMoreTokens()) {
                    IAttribute attribute = this.metadata.getAttribute(numAttributes);
                    double value = attribute.parse(token.nextToken().trim());
                    this.cursorInstance.setValue(numAttributes, value);
                    ++numAttributes;
                }
                this.prepareNextInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    @Override
    public AbstractDataset.Instance read() throws DatasetException {
        return this.cursorInstance;
    }

    @Override
    public void close() throws DatasetException {
        try {
            this.fileReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void obtainMetadata(String file) {
        File f1 = new File(file);
        this.metadata = new Metadata();
        try {
            this.fileReader = new BufferedReader(new FileReader(f1));
            String line = ((BufferedReader)this.fileReader).readLine();
            int indexAttribute = 0;
            StringTokenizer elementLine = new StringTokenizer(line);
            String element = elementLine.nextToken();
            while (!element.equalsIgnoreCase(KEEL_DATA)) {
                if (element.equalsIgnoreCase(KEEL_ATTRIBUTE)) {
                    ++indexAttribute;
                    String name = elementLine.nextToken();
                    String type = elementLine.nextToken();
                    if (type.equalsIgnoreCase("REAL") || type.equalsIgnoreCase("INTEGER")) {
                        this.addAttributeToSpecification(type, line, name);
                    } else {
                        this.addAttributeToSpecification("STRING", line, name);
                    }
                }
                if (element.equalsIgnoreCase(KEEL_RELATION)) {
                    this.setName(elementLine.nextToken());
                }
                line = ((BufferedReader)this.fileReader).readLine();
                while (line.startsWith(this.commentedValue) || line.equalsIgnoreCase("")) {
                    line = ((BufferedReader)this.fileReader).readLine();
                }
                elementLine = new StringTokenizer(line);
                element = elementLine.nextToken();
            }
            this.bufferInstance = ((BufferedReader)this.fileReader).readLine();
            while (this.bufferInstance.startsWith(this.commentedValue) || this.bufferInstance.equalsIgnoreCase("")) {
                this.bufferInstance = ((BufferedReader)this.fileReader).readLine();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void prepareNextInstance() {
        try {
            String lineInstance = ((BufferedReader)this.fileReader).readLine();
            while (lineInstance.startsWith(this.commentedValue) || lineInstance.equalsIgnoreCase("")) {
                lineInstance = ((BufferedReader)this.fileReader).readLine();
            }
            this.bufferInstance = lineInstance;
        }
        catch (Exception e) {
            this.bufferInstance = null;
        }
    }

    private void addAttributeToSpecification(String type, String interval, String name) {
        if (type.equalsIgnoreCase("REAL")) {
            NumericalAttribute attribute = new NumericalAttribute();
            attribute.setName(name);
            int minIndex = interval.indexOf("[");
            int maxIndex = interval.indexOf("]");
            interval = interval.substring(minIndex + 1, maxIndex);
            if (minIndex < maxIndex) {
                StringTokenizer tkInterval = new StringTokenizer(interval, ",");
                Interval intervals = new Interval();
                intervals.setClosure(net.sourceforge.jclec.util.range.Closure.ClosedClosed);
                intervals.setLeft(Double.valueOf((String)tkInterval.nextElement()));
                intervals.setRight(Double.valueOf(tkInterval.nextToken()));
                attribute.addInterval(intervals);
                this.metadata.addAttribute(attribute);
            }
        } else if (type.equalsIgnoreCase("INTEGER")) {
            IntegerAttribute attribute = new IntegerAttribute();
            attribute.setName(name);
            int minIndex = interval.indexOf("[");
            int maxIndex = interval.indexOf("]");
            interval = interval.substring(minIndex + 1, maxIndex);
            if (minIndex < maxIndex) {
                StringTokenizer tkInterval = new StringTokenizer(interval, ",");
                net.sourceforge.jclec.util.intset.Interval intervals = new net.sourceforge.jclec.util.intset.Interval();
                intervals.setClosure(Closure.ClosedClosed);
                intervals.setLeft(Integer.valueOf((String)tkInterval.nextElement()));
                intervals.setRight(Integer.valueOf(tkInterval.nextToken().trim()));
                attribute.addInterval(intervals);
                this.metadata.addAttribute(attribute);
            }
        } else {
            int minIndex = interval.indexOf("{");
            int maxIndex = interval.indexOf("}");
            interval = interval.substring(minIndex + 1, maxIndex);
            if (minIndex < maxIndex) {
                CategoricalAttribute attribute = new CategoricalAttribute();
                attribute.setName(name);
                StringTokenizer categories = new StringTokenizer(interval, ",");
                while (categories.hasMoreTokens()) {
                    attribute.categories.add(categories.nextToken().trim());
                }
                attribute.setCategories(attribute.categories);
                this.metadata.addAttribute(attribute);
            }
        }
    }
}

