/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Genetic_Rule_Learning.M5Rules;

public final class M5StaticUtils {
    public static double log2 = Math.log(2.0);
    public static double SMALL = 1.0E-6;

    public static String removeSubstring(String inString, String substring) {
        StringBuffer result = new StringBuffer();
        int oldLoc = 0;
        int loc = 0;
        while ((loc = inString.indexOf(substring, oldLoc)) != -1) {
            result.append(inString.substring(oldLoc, loc));
            oldLoc = loc + substring.length();
        }
        result.append(inString.substring(oldLoc));
        return result.toString();
    }

    public static String replaceSubstring(String inString, String subString, String replaceString) {
        StringBuffer result = new StringBuffer();
        int oldLoc = 0;
        int loc = 0;
        while ((loc = inString.indexOf(subString, oldLoc)) != -1) {
            result.append(inString.substring(oldLoc, loc));
            result.append(replaceString);
            oldLoc = loc + subString.length();
        }
        result.append(inString.substring(oldLoc));
        return result.toString();
    }

    public static String padLeft(String inString, int length) {
        return M5StaticUtils.fixStringLength(inString, length, false);
    }

    public static String padRight(String inString, int length) {
        return M5StaticUtils.fixStringLength(inString, length, true);
    }

    private static String fixStringLength(String inString, int length, boolean right) {
        if (inString.length() < length) {
            while (inString.length() < length) {
                inString = right ? inString.concat(" ") : " ".concat(inString);
            }
        } else if (inString.length() > length) {
            inString = inString.substring(0, length);
        }
        return inString;
    }

    public static String doubleToString(double value, int afterDecimalPoint) {
        double temp = value * Math.pow(10.0, afterDecimalPoint);
        if (Math.abs(temp) < 9.223372036854776E18) {
            int dotPosition;
            long precisionValue = temp > 0.0 ? (long)(temp + 0.5) : -((long)(Math.abs(temp) + 0.5));
            StringBuffer stringBuffer = precisionValue == 0L ? new StringBuffer(String.valueOf(0)) : new StringBuffer(String.valueOf(precisionValue));
            if (afterDecimalPoint == 0) {
                return stringBuffer.toString();
            }
            for (dotPosition = stringBuffer.length() - afterDecimalPoint; precisionValue < 0L && dotPosition < 1 || dotPosition < 0; ++dotPosition) {
                if (precisionValue < 0L) {
                    stringBuffer.insert(1, 0);
                    continue;
                }
                stringBuffer.insert(0, 0);
            }
            stringBuffer.insert(dotPosition, '.');
            if (precisionValue < 0L && stringBuffer.charAt(1) == '.') {
                stringBuffer.insert(1, 0);
            } else if (stringBuffer.charAt(0) == '.') {
                stringBuffer.insert(0, 0);
            }
            int currentPos = stringBuffer.length() - 1;
            while (currentPos > dotPosition && stringBuffer.charAt(currentPos) == '0') {
                stringBuffer.setCharAt(currentPos--, ' ');
            }
            if (stringBuffer.charAt(currentPos) == '.') {
                stringBuffer.setCharAt(currentPos, ' ');
            }
            return stringBuffer.toString().trim();
        }
        return new String("" + value);
    }

    public static String doubleToString(double value, int width, int afterDecimalPoint) {
        int i;
        int dotPosition;
        String tempString = M5StaticUtils.doubleToString(value, afterDecimalPoint);
        if (afterDecimalPoint >= width || tempString.indexOf(69) != -1) {
            return tempString;
        }
        char[] result = new char[width];
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = 32;
        }
        if (afterDecimalPoint > 0) {
            dotPosition = tempString.indexOf(46);
            if (dotPosition == -1) {
                dotPosition = tempString.length();
            } else {
                result[width - afterDecimalPoint - 1] = 46;
            }
        } else {
            dotPosition = tempString.length();
        }
        int offset = width - afterDecimalPoint - dotPosition;
        if (afterDecimalPoint > 0) {
            --offset;
        }
        if (offset < 0) {
            return tempString;
        }
        for (i = 0; i < dotPosition; ++i) {
            result[offset + i] = tempString.charAt(i);
        }
        for (i = dotPosition + 1; i < tempString.length(); ++i) {
            result[offset + i] = tempString.charAt(i);
        }
        return new String(result);
    }

    public static boolean eq(double a, double b) {
        return a - b < SMALL && b - a < SMALL;
    }

    public static void checkForRemainingOptions(String[] options) throws Exception {
        int illegalOptionsFound = 0;
        StringBuffer text = new StringBuffer();
        if (options == null) {
            return;
        }
        for (int i = 0; i < options.length; ++i) {
            if (options[i].length() <= 0) continue;
            ++illegalOptionsFound;
            text.append(options[i] + ' ');
        }
        if (illegalOptionsFound > 0) {
            throw new Exception("Illegal options: " + text);
        }
    }

    public static boolean getFlag(char flag, String[] options) throws Exception {
        if (options == null) {
            return false;
        }
        for (int i = 0; i < options.length; ++i) {
            if (options[i].length() <= 1 || options[i].charAt(0) != '-') continue;
            try {
                Double dummy = Double.valueOf(options[i]);
                continue;
            }
            catch (NumberFormatException e) {
                if (options[i].length() > 2) {
                    throw new Exception("Illegal option: " + options[i]);
                }
                if (options[i].charAt(1) == flag) {
                    options[i] = "";
                    return true;
                }
                if (options[i].charAt(1) != '-') continue;
                return false;
            }
        }
        return false;
    }

    public static String getOption(char flag, String[] options) throws Exception {
        if (options == null) {
            return "";
        }
        for (int i = 0; i < options.length; ++i) {
            if (options[i].length() <= 0 || options[i].charAt(0) != '-') continue;
            try {
                Double dummy = Double.valueOf(options[i]);
                continue;
            }
            catch (NumberFormatException e) {
                if (options[i].length() > 2) {
                    throw new Exception("Illegal option: " + options[i]);
                }
                if (options[i].charAt(1) == flag) {
                    if (i + 1 == options.length) {
                        throw new Exception("No value given for -" + flag + " option.");
                    }
                    options[i] = "";
                    String newString = new String(options[i + 1]);
                    options[i + 1] = "";
                    return newString;
                }
                if (options[i].charAt(1) != '-') continue;
                return "";
            }
        }
        return "";
    }

    public static String quote(String string) {
        boolean quote = false;
        if (string.indexOf(10) != -1 || string.indexOf(13) != -1 || string.indexOf(39) != -1 || string.indexOf(34) != -1 || string.indexOf(92) != -1 || string.indexOf(9) != -1 || string.indexOf(37) != -1) {
            string = M5StaticUtils.backQuoteChars(string);
            quote = true;
        }
        if (quote || string.indexOf(123) != -1 || string.indexOf(125) != -1 || string.indexOf(44) != -1 || string.equals("?") || string.indexOf(32) != -1 || string.equals("")) {
            string = "'".concat(string).concat("'");
        }
        return string;
    }

    public static String backQuoteChars(String string) {
        char[] charsFind = new char[]{'\\', '\'', '\t', '\"', '%'};
        String[] charsReplace = new String[]{"\\\\", "\\'", "\\t", "\\\"", "\\%"};
        for (int i = 0; i < charsFind.length; ++i) {
            int index;
            if (string.indexOf(charsFind[i]) == -1) continue;
            StringBuffer newStringBuffer = new StringBuffer();
            while ((index = string.indexOf(charsFind[i])) != -1) {
                if (index > 0) {
                    newStringBuffer.append(string.substring(0, index));
                }
                newStringBuffer.append(charsReplace[i]);
                if (index + 1 < string.length()) {
                    string = string.substring(index + 1);
                    continue;
                }
                string = "";
            }
            newStringBuffer.append(string);
            string = newStringBuffer.toString();
        }
        return M5StaticUtils.convertNewLines(string);
    }

    public static String convertNewLines(String string) {
        int index;
        StringBuffer newStringBuffer = new StringBuffer();
        while ((index = string.indexOf(10)) != -1) {
            if (index > 0) {
                newStringBuffer.append(string.substring(0, index));
            }
            newStringBuffer.append('\\');
            newStringBuffer.append('n');
            if (index + 1 < string.length()) {
                string = string.substring(index + 1);
                continue;
            }
            string = "";
        }
        newStringBuffer.append(string);
        string = newStringBuffer.toString();
        newStringBuffer = new StringBuffer();
        while ((index = string.indexOf(13)) != -1) {
            if (index > 0) {
                newStringBuffer.append(string.substring(0, index));
            }
            newStringBuffer.append('\\');
            newStringBuffer.append('r');
            if (index + 1 < string.length()) {
                string = string.substring(index + 1);
                continue;
            }
            string = "";
        }
        newStringBuffer.append(string);
        return newStringBuffer.toString();
    }

    public static String[] partitionOptions(String[] options) {
        for (int i = 0; i < options.length; ++i) {
            if (!options[i].equals("--")) continue;
            options[i++] = "";
            String[] result = new String[options.length - i];
            for (int j = i; j < options.length; ++j) {
                result[j - i] = options[j];
                options[j] = "";
            }
            return result;
        }
        return new String[0];
    }

    public static String joinOptions(String[] optionArray) {
        String optionString = "";
        for (int i = 0; i < optionArray.length; ++i) {
            if (optionArray[i].equals("")) continue;
            optionString = optionArray[i].indexOf(32) != -1 ? optionString + '\"' + optionArray[i] + '\"' : optionString + optionArray[i];
            optionString = optionString + " ";
        }
        return optionString.trim();
    }

    public static double info(int[] counts) {
        int total = 0;
        double x = 0.0;
        for (int j = 0; j < counts.length; ++j) {
            x -= M5StaticUtils.xlogx(counts[j]);
            total += counts[j];
        }
        return x + M5StaticUtils.xlogx(total);
    }

    public static boolean smOrEq(double a, double b) {
        return a - b < SMALL;
    }

    public static boolean grOrEq(double a, double b) {
        return b - a < SMALL;
    }

    public static boolean sm(double a, double b) {
        return b - a > SMALL;
    }

    public static boolean gr(double a, double b) {
        return a - b > SMALL;
    }

    public static double log2(double a) {
        return Math.log(a) / log2;
    }

    public static int maxIndex(double[] doubles) {
        double maximum = 0.0;
        int maxIndex = 0;
        for (int i = 0; i < doubles.length; ++i) {
            if (i != 0 && !(doubles[i] > maximum)) continue;
            maxIndex = i;
            maximum = doubles[i];
        }
        return maxIndex;
    }

    public static int maxIndex(int[] ints) {
        int maximum = 0;
        int maxIndex = 0;
        for (int i = 0; i < ints.length; ++i) {
            if (i != 0 && ints[i] <= maximum) continue;
            maxIndex = i;
            maximum = ints[i];
        }
        return maxIndex;
    }

    public static double mean(double[] vector) {
        double sum = 0.0;
        if (vector.length == 0) {
            return 0.0;
        }
        for (int i = 0; i < vector.length; ++i) {
            sum += vector[i];
        }
        return sum / (double)vector.length;
    }

    public static int minIndex(int[] ints) {
        int minimum = 0;
        int minIndex = 0;
        for (int i = 0; i < ints.length; ++i) {
            if (i != 0 && ints[i] >= minimum) continue;
            minIndex = i;
            minimum = ints[i];
        }
        return minIndex;
    }

    public static int minIndex(double[] doubles) {
        double minimum = 0.0;
        int minIndex = 0;
        for (int i = 0; i < doubles.length; ++i) {
            if (i != 0 && !(doubles[i] < minimum)) continue;
            minIndex = i;
            minimum = doubles[i];
        }
        return minIndex;
    }

    public static void normalize(double[] doubles) {
        double sum = 0.0;
        for (int i = 0; i < doubles.length; ++i) {
            sum += doubles[i];
        }
        M5StaticUtils.normalize(doubles, sum);
    }

    public static void normalize(double[] doubles, double sum) {
        if (Double.isNaN(sum)) {
            throw new IllegalArgumentException("Can't normalize array. Sum is NaN.");
        }
        if (sum == 0.0) {
            throw new IllegalArgumentException("Can't normalize array. Sum is zero.");
        }
        int i = 0;
        while (i < doubles.length) {
            int n = i++;
            doubles[n] = doubles[n] / sum;
        }
    }

    public static int round(double value) {
        int roundedValue = value > 0.0 ? (int)(value + 0.5) : -((int)(Math.abs(value) + 0.5));
        return roundedValue;
    }

    public static double roundDouble(double value, int afterDecimalPoint) {
        double mask = Math.pow(10.0, afterDecimalPoint);
        return (double)Math.round(value * mask) / mask;
    }

    public static int[] sort(int[] array) {
        int i;
        int[] index = new int[array.length];
        int[] newIndex = new int[array.length];
        for (i = 0; i < index.length; ++i) {
            index[i] = i;
        }
        M5StaticUtils.quickSort(array, index, 0, array.length - 1);
        i = 0;
        while (i < index.length) {
            int j;
            int numEqual = 1;
            for (j = i + 1; j < index.length && array[index[i]] == array[index[j]]; ++j) {
                ++numEqual;
            }
            if (numEqual > 1) {
                int[] helpIndex = new int[numEqual];
                for (j = 0; j < numEqual; ++j) {
                    helpIndex[j] = i + j;
                }
                M5StaticUtils.quickSort(index, helpIndex, 0, numEqual - 1);
                for (j = 0; j < numEqual; ++j) {
                    newIndex[i + j] = index[helpIndex[j]];
                }
                i += numEqual;
                continue;
            }
            newIndex[i] = index[i];
            ++i;
        }
        return newIndex;
    }

    public static int[] sort(double[] array) {
        int[] index = new int[array.length];
        array = (double[])array.clone();
        for (int i = 0; i < index.length; ++i) {
            index[i] = i;
            if (!Double.isNaN(array[i])) continue;
            array[i] = Double.MAX_VALUE;
        }
        M5StaticUtils.quickSort(array, index, 0, array.length - 1);
        return index;
    }

    public static int[] stableSort(double[] array) {
        int i;
        int[] index = new int[array.length];
        int[] newIndex = new int[array.length];
        array = (double[])array.clone();
        for (i = 0; i < index.length; ++i) {
            index[i] = i;
            if (!Double.isNaN(array[i])) continue;
            array[i] = Double.MAX_VALUE;
        }
        M5StaticUtils.quickSort(array, index, 0, array.length - 1);
        i = 0;
        while (i < index.length) {
            int j;
            int numEqual = 1;
            for (j = i + 1; j < index.length && M5StaticUtils.eq(array[index[i]], array[index[j]]); ++j) {
                ++numEqual;
            }
            if (numEqual > 1) {
                int[] helpIndex = new int[numEqual];
                for (j = 0; j < numEqual; ++j) {
                    helpIndex[j] = i + j;
                }
                M5StaticUtils.quickSort(index, helpIndex, 0, numEqual - 1);
                for (j = 0; j < numEqual; ++j) {
                    newIndex[i + j] = index[helpIndex[j]];
                }
                i += numEqual;
                continue;
            }
            newIndex[i] = index[i];
            ++i;
        }
        return newIndex;
    }

    public static double variance(double[] vector) {
        double sum = 0.0;
        double sumSquared = 0.0;
        if (vector.length <= 1) {
            return 0.0;
        }
        for (int i = 0; i < vector.length; ++i) {
            sum += vector[i];
            sumSquared += vector[i] * vector[i];
        }
        return (sumSquared - sum * sum / (double)vector.length) / (double)(vector.length - 1);
    }

    public static double sum(double[] doubles) {
        double sum = 0.0;
        for (int i = 0; i < doubles.length; ++i) {
            sum += doubles[i];
        }
        return sum;
    }

    public static int sum(int[] ints) {
        int sum = 0;
        for (int i = 0; i < ints.length; ++i) {
            sum += ints[i];
        }
        return sum;
    }

    public static double xlogx(int c) {
        if (c == 0) {
            return 0.0;
        }
        return (double)c * M5StaticUtils.log2(c);
    }

    private static void quickSort(int[] array, int[] index, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            int mid = array[index[(lo0 + hi0) / 2]];
            while (lo <= hi) {
                while (array[index[lo]] < mid && lo < hi0) {
                    ++lo;
                }
                while (array[index[hi]] > mid && hi > lo0) {
                    --hi;
                }
                if (lo > hi) continue;
                int help = index[lo];
                index[lo] = index[hi];
                index[hi] = help;
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                M5StaticUtils.quickSort(array, index, lo0, hi);
            }
            if (lo < hi0) {
                M5StaticUtils.quickSort(array, index, lo, hi0);
            }
        }
    }

    private static void quickSort(double[] array, int[] index, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            double mid = array[index[(lo0 + hi0) / 2]];
            while (lo <= hi) {
                while (array[index[lo]] < mid && lo < hi0) {
                    ++lo;
                }
                while (array[index[hi]] > mid && hi > lo0) {
                    --hi;
                }
                if (lo > hi) continue;
                int help = index[lo];
                index[lo] = index[hi];
                index[hi] = help;
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                M5StaticUtils.quickSort(array, index, lo0, hi);
            }
            if (lo < hi0) {
                M5StaticUtils.quickSort(array, index, lo, hi0);
            }
        }
    }
}

