## ----echo=FALSE,results='hide',warning=FALSE,message=FALSE------------------------------------------------------------------------------------------
library(knitr)
knitr::opts_chunk$set(comment="", message=FALSE, warning=FALSE,fig.align="center",fig.height=10,fig.width=10,tidy=TRUE,tidy.opts=list(blank=FALSE, width.cutoff=1200))
options(width=150)
library(kableExtra)

## ----echo=TRUE--------------------------------------------------------------------------------------------------------------------------------------
library(compareGroups)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
data(regicor)

## ----echo=FALSE,results="asis"----------------------------------------------------------------------------------------------------------------------
dicc <- data.frame(
"Name"=I(names(regicor)),
"Label"=I(unlist(lapply(regicor, attr, which="label", exact=TRUE))),
"Codes"=I(unlist(lapply(regicor, function(x) paste(levels(x),collapse="; "))))
)
dicc$Codes <- sub(">=","$\\\\geq$",dicc$Codes)
kable(dicc, align=rep("l",4), row.names=FALSE, format = "html")

## ---------------------------------------------------------------------------------------------------------------------------------------------------
library(survival)
regicor$tmain <- with(regicor, Surv(tocv, cv == 'Yes'))
attr(regicor$tmain,"label") <- "Time to CV event or censoring"

## ----results='hide'---------------------------------------------------------------------------------------------------------------------------------
compareGroups(year ~ . , data=regicor)

## ----results='hide'---------------------------------------------------------------------------------------------------------------------------------
compareGroups(year ~ . - id, data=regicor)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
res<-compareGroups(year ~ age + sex + bmi, data=regicor)
res

## ---------------------------------------------------------------------------------------------------------------------------------------------------
compareGroups(year ~ age + smoker + bmi, data=regicor, subset = sex=='Female')

## ----echo=TRUE--------------------------------------------------------------------------------------------------------------------------------------
compareGroups(year ~ age + bmi + smoker, data=regicor, selec = list(age= sex=="Female", bmi = age>50 ))

## ----echo=TRUE--------------------------------------------------------------------------------------------------------------------------------------
compareGroups(year ~ age + smoker + bmi, data=regicor, selec = list(bmi=age>50), subset = sex=="Female")

## ----echo=TRUE--------------------------------------------------------------------------------------------------------------------------------------
compareGroups(year ~ age + sex + bmi + bmi, data=regicor, selec = list(bmi.1=txhtn=='Yes'))

## ----echo=TRUE--------------------------------------------------------------------------------------------------------------------------------------
compareGroups(year ~ age + smoker + triglyc, data=regicor, method = c(triglyc=2))

## ----echo=TRUE--------------------------------------------------------------------------------------------------------------------------------------
compareGroups(year ~ age + smoker + triglyc, data=regicor, method = c(triglyc=NA), alpha= 0.01)

## ----echo=TRUE--------------------------------------------------------------------------------------------------------------------------------------
regicor$age7gr<-as.integer(cut(regicor$age, breaks=c(-Inf,40,45,50,55,65,70,Inf), right=TRUE))
compareGroups(year ~ age7gr, data=regicor, method = c(age7gr=NA))
compareGroups(year ~ age7gr, data=regicor, method = c(age7gr=NA), min.dis=8)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------
#  regicor$var6cat <- factor(sample(1:5, nrow(regicor), replace=TRUE))
#  compareGroups(age7gr ~ sex + bmi + smoker, data=regicor)

## ----echo=FALSE-------------------------------------------------------------------------------------------------------------------------------------
cat("Error in compareGroups.fit(X = X, y = y, include.label = include.label, : 
number of groups must be less or equal to 5")

## ----echo=TRUE--------------------------------------------------------------------------------------------------------------------------------------
compareGroups(age7gr ~ sex + bmi + smoker, data=regicor, max.ylev=7)

## ----echo=TRUE, eval=FALSE--------------------------------------------------------------------------------------------------------------------------
#  compareGroups(year ~ sex + age7gr, method=c(age7gr=3), data=regicor, max.xlev=5)

## ----echo=FALSE-------------------------------------------------------------------------------------------------------------------------------------
cat("Warning in compareGroups.fit(X = X, y = y, include.label = include.label,  :
  Variables 'age7gr' have been removed since some errors occurred")

## ----echo=TRUE--------------------------------------------------------------------------------------------------------------------------------------
compareGroups(year ~ age + smoker + bmi, data=regicor, include.label= FALSE)

## ----echo=TRUE--------------------------------------------------------------------------------------------------------------------------------------
resu1<-compareGroups(year ~ age + triglyc, data=regicor, method = c(triglyc=2))
createTable(resu1)

## ----echo=TRUE--------------------------------------------------------------------------------------------------------------------------------------
resu2<-compareGroups(year ~ age + triglyc, data=regicor, method = c(triglyc=2), Q1=0.025, Q3=0.975)
createTable(resu2)

## ----echo=TRUE, results='hide'----------------------------------------------------------------------------------------------------------------------
compareGroups(year ~ age + triglyc, data=regicor, method = c(triglyc=2), Q1=0, Q3=1)

## ----echo=TRUE--------------------------------------------------------------------------------------------------------------------------------------
regicor$smk<-regicor$smoker
levels(regicor$smk)<- c("Never smoker", "Current or former < 1y", "Former >= 1y", "Unknown")
attr(regicor$smk,"label")<-"Smoking 4 cat."
cbind(table(regicor$smk))

## ----echo=TRUE--------------------------------------------------------------------------------------------------------------------------------------
compareGroups(year ~ age + smk + bmi, data=regicor)

## ----echo=FALSE-------------------------------------------------------------------------------------------------------------------------------------
cat("Warning in compare.i(X[, i], y = y, selec.i = selec[i], method.i = method[i],  :
  Some levels of 'smk' are removed since no observation in that/those levels")

## ----echo=TRUE--------------------------------------------------------------------------------------------------------------------------------------
compareGroups(year ~ age + smk + bmi, data=regicor, simplify=FALSE)

## ----echo=TRUE--------------------------------------------------------------------------------------------------------------------------------------
res<-compareGroups(year ~ age + sex + smoker + bmi + triglyc, method = c(triglyc=2), data=regicor)
summary(res[c(1, 2, 5)])

## ----echo=TRUE--------------------------------------------------------------------------------------------------------------------------------------
plot(res[c(1,2)], file="./figures/univar/", type="png")

## ----echo=TRUE--------------------------------------------------------------------------------------------------------------------------------------
plot(res[c(1,2)], bivar=TRUE, file="./figures/bivar/", type="png")

## ---------------------------------------------------------------------------------------------------------------------------------------------------
res<-compareGroups(year ~ age + sex + smoker + bmi, data=regicor)
res

## ----echo=TRUE, results='hide'----------------------------------------------------------------------------------------------------------------------
res<-update(res, . ~. - sex + triglyc + cv + tocv, subset = sex=='Female', method = c(triglyc=2, tocv=2), selec = list(triglyc=txchol=='No'))
res

## ---------------------------------------------------------------------------------------------------------------------------------------------------
data(SNPs)
tab <- createTable(compareGroups(casco ~ snp10001 + snp10002 + snp10005 + snp10008 + snp10009, SNPs))
pvals <- getResults(tab, "p.overall")
p.adjust(pvals, method = "BH")

## ---------------------------------------------------------------------------------------------------------------------------------------------------
cg <- compareGroups(casco ~ snp10001 + snp10002 + snp10005 + snp10008 + snp10009, SNPs)
createTable(padjustCompareGroups(cg, method="BH"))

## ----echo=TRUE--------------------------------------------------------------------------------------------------------------------------------------
res1<-compareGroups(cv ~ age + sex + bmi + smoker, data=regicor, ref=1)
createTable(res1, show.ratio=TRUE)

## ----echo=TRUE--------------------------------------------------------------------------------------------------------------------------------------
res2<-compareGroups(cv ~ age + sex + bmi + smoker, data=regicor, ref=c(smoker=1, sex=2))
createTable(res2, show.ratio=TRUE)

## ----echo=TRUE--------------------------------------------------------------------------------------------------------------------------------------
res<-compareGroups(cv ~ age + sex + bmi + histhtn + txhtn, data=regicor, ref.no='NO')
createTable(res, show.ratio=TRUE)

## ----echo=TRUE--------------------------------------------------------------------------------------------------------------------------------------
res<-compareGroups(cv ~ age + bmi, data=regicor)
createTable(res, show.ratio=TRUE)

## ----echo=TRUE--------------------------------------------------------------------------------------------------------------------------------------
res<-compareGroups(cv ~ age + bmi, data=regicor, fact.ratio= c(age=10, bmi=2))
createTable(res, show.ratio=TRUE)

## ----echo=TRUE--------------------------------------------------------------------------------------------------------------------------------------
res<-compareGroups(cv ~ age + sex + bmi + txhtn, data=regicor)
createTable(res, show.ratio=TRUE)

## ----echo=TRUE--------------------------------------------------------------------------------------------------------------------------------------
res<-compareGroups(cv ~ age + sex + bmi + txhtn, data=regicor, ref.y=2)
createTable(res, show.ratio=TRUE)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
plot(compareGroups(tmain ~ sex, data=regicor), bivar=TRUE, file="./figures/bivarsurv/", type="png")
plot(compareGroups(tmain ~ age, data=regicor), bivar=TRUE, file="./figures/bivarsurv/", type="png")

## ----echo=TRUE, results='hide'----------------------------------------------------------------------------------------------------------------------
res<-compareGroups(sex ~  age + tmain, timemax=c(tmain=3*365.25), data=regicor)
res

## ----echo=TRUE--------------------------------------------------------------------------------------------------------------------------------------
plot(res[2], file="./figures/univar/", type="png")
plot(res[2], bivar=TRUE, file="./figures/bivar/", type="png")

## ----echo=TRUE--------------------------------------------------------------------------------------------------------------------------------------
res<-compareGroups(year ~ age + sex + smoker + bmi + sbp, data=regicor, selec = list(sbp=txhtn=="No"))
restab<-createTable(res)

## ----echo=TRUE--------------------------------------------------------------------------------------------------------------------------------------
print(restab,which.table='descr')

## ----echo=TRUE, eval=FALSE--------------------------------------------------------------------------------------------------------------------------
#  print(restab,which.table='avail')

## ----echo=FALSE-------------------------------------------------------------------------------------------------------------------------------------
print(restab,which.table='avail')

## ---------------------------------------------------------------------------------------------------------------------------------------------------
update(restab, hide = c(sex="Male"))

## ---------------------------------------------------------------------------------------------------------------------------------------------------
res<-compareGroups(year ~ age + sex + histchol + histhtn, data=regicor)
createTable(res, hide.no='no', hide = c(sex="Male"))

## ---------------------------------------------------------------------------------------------------------------------------------------------------
createTable(res, digits= c(age=2, sex = 3))

## ---------------------------------------------------------------------------------------------------------------------------------------------------
createTable(res, type=1)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
createTable(res, type=3)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
createTable(res, show.n=TRUE)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
createTable(res, show.descr=FALSE)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
createTable(res, show.all=TRUE)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
createTable(res, show.p.overall=FALSE)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
createTable(res, show.p.trend=TRUE)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------
#  createTable(res, show.p.mul=TRUE)

## ----echo=FALSE-------------------------------------------------------------------------------------------------------------------------------------
createTable(res, show.p.mul=TRUE)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
createTable(update(res, subset= year!=1995), show.ratio=TRUE)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
createTable(compareGroups(tmain ~  year + age + sex, data=regicor), show.ratio=TRUE)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
createTable(compareGroups(tmain ~  year + age + sex, data=regicor), show.ratio=TRUE, digits.ratio= 3)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
tab<-createTable(compareGroups(tmain ~  year + age + sex, data=regicor), show.all = TRUE)
print(tab, header.labels = c("p.overall" = "p-value", "all" = "All"))

## ---------------------------------------------------------------------------------------------------------------------------------------------------
restab1 <- createTable(compareGroups(year ~ age + sex, data=regicor))
restab2 <- createTable(compareGroups(year ~ bmi + smoker, data=regicor))
rbind("Non-modifiable risk factors"=restab1, "Modifiable risk factors"=restab2)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
x <- rbind("Non-modifiable"=restab1,"Modifiable"=restab2)
rbind("Non-modifiable"=restab1,"Modifiable"=restab2)[c(1,4)]

## ---------------------------------------------------------------------------------------------------------------------------------------------------
rbind("Modifiable"=restab1,"Non-modifiable"=restab2)[c(4,3,2,1)]

## ---------------------------------------------------------------------------------------------------------------------------------------------------
res<-compareGroups(year ~ age +  smoker + bmi + histhtn , data=regicor)
alltab <- createTable(res,  show.p.overall = FALSE)
femaletab <- createTable(update(res,subset=sex=='Female'), show.p.overall = FALSE)
maletab <- createTable(update(res,subset=sex=='Male'), show.p.overall = FALSE)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------
#  cbind("ALL"=alltab,"FEMALE"=femaletab,"MALE"=maletab)

## ----echo=FALSE-------------------------------------------------------------------------------------------------------------------------------------
cbind("ALL"=alltab,"FEMALE"=femaletab,"MALE"=maletab)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------
#  cbind(alltab,femaletab,maletab)

## ----echo=FALSE-------------------------------------------------------------------------------------------------------------------------------------
cbind(alltab,femaletab,maletab)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
res <- compareGroups(year ~ age + bmi + smoker + histchol + histhtn, regicor)
restab <- createTable(res, hide.no="no")

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------
#  strataTable(restab, "sex")

## ----echo=FALSE-------------------------------------------------------------------------------------------------------------------------------------
strataTable(restab, "sex")

## ---------------------------------------------------------------------------------------------------------------------------------------------------
print(createTable(compareGroups(year ~ age + sex + smoker + bmi, data=regicor)), which.table='both')

## ---------------------------------------------------------------------------------------------------------------------------------------------------
print(createTable(compareGroups(year ~ age + sex + smoker + bmi, data=regicor)),  nmax=FALSE)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
summary(createTable(compareGroups(year ~ age + sex + smoker + bmi, data=regicor)))

## ---------------------------------------------------------------------------------------------------------------------------------------------------
res<-compareGroups(year ~ age + sex + smoker + bmi, data=regicor)
restab<-createTable(res, type=1)
restab
update(restab, show.n=TRUE)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
update(restab, x = update(res, subset=c(sex=='Female')), show.n=TRUE)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
createTable(compareGroups(year ~ age + sex + smoker + bmi + histhtn, data=regicor))

## ---------------------------------------------------------------------------------------------------------------------------------------------------
createTable(compareGroups(year ~ age + sex + smoker + bmi + histhtn, data=regicor))[1:2, ]

## ---------------------------------------------------------------------------------------------------------------------------------------------------
descrTable(regicor)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
descrTable(~ age + sex, regicor)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
descrTable(regicor, hide.no="no")

## ---------------------------------------------------------------------------------------------------------------------------------------------------
descrTable(year ~ ., regicor, hide.no="no", show.all=TRUE)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
descrTable(regicor, subset=age>65)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
restab<-createTable(compareGroups(year ~ age + sex + smoker + bmi + histchol, data=regicor))
export2latex(restab)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
res <- compareGroups(year ~ ., regicor)
restab <- createTable(res, hide.no="no")

## ---------------------------------------------------------------------------------------------------------------------------------------------------
export2md(restab)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
export2md(restab, strip=TRUE, first.strip=TRUE)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
export2md(restab, size=6)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
export2md(restab, width="400px")

## ---------------------------------------------------------------------------------------------------------------------------------------------------
restab <- strataTable(descrTable(year ~ . -id, regicor), "sex")

## ---------------------------------------------------------------------------------------------------------------------------------------------------
export2md(restab, size=8)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------
#  # to know more about report function
#  ?report
#  
#  # info about REGICOR data set
#  ?regicor

## ---------------------------------------------------------------------------------------------------------------------------------------------------
# from a compareGroups object
data(regicor)
res <- compareGroups(year ~ .-id, regicor)
missingTable(res)

## ----eval=FALSE,results='hide'----------------------------------------------------------------------------------------------------------------------
#  # or from createTable objects
#  restab <- createTable(res, hide.no = 'no')
#  missingTable(restab)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
# first create time-to-cardiovascular event
regicor$tcv<-with(regicor,Surv(tocv,cv=='Yes'))
# create the table
res <- compareGroups(tcv ~ . -id-tocv-cv-todeath-death, regicor, include.miss = TRUE)
restab <- createTable(res, hide.no = 'no')
restab

## ---------------------------------------------------------------------------------------------------------------------------------------------------
data(SNPs)
head(SNPs)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
res<-compareSNPs(casco ~ snp10001 + snp10002 + snp10003, data=SNPs)
res

## ---------------------------------------------------------------------------------------------------------------------------------------------------
res<-compareSNPs(~ snp10001 + snp10002 + snp10003, data=SNPs)
res

## ----echo=FALSE, results='asis'---------------------------------------------------------------------------------------------------------------------
export2md(descrTable(year ~  age + sex + smoker + sbp + dbp + histhtn + txhtn + chol + hdl + triglyc + ldl + histchol + txchol + bmi, data=regicor, method=c(triglyc=2), hide.no="No",hide = c(sex="Male")))

## ----echo=FALSE, results='asis'---------------------------------------------------------------------------------------------------------------------
export2md(descrTable(cv ~  age + sex + smoker + bmi + chol + triglyc + ldl + sbp + dbp + txhtn, data=regicor, method=c(triglyc=2), hide.no="No",hide = c(sex="Male"), show.ratio=TRUE, show.descr=FALSE))

## ----echo=FALSE, results='asis'---------------------------------------------------------------------------------------------------------------------
export2md(createTable(compareGroups(tcv ~  year + age + sex, data=regicor), show.ratio=TRUE))

