/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter.objectives.distance.measures;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.corehunter.data.CoreHunterData;
import org.corehunter.objectives.distance.DistanceMeasure;
import org.corehunter.objectives.distance.measures.MissingValuesPolicy;

public abstract class AbstractDistanceMeasure
implements DistanceMeasure {
    private final Map<CoreHunterData, double[][]> cache = new HashMap<CoreHunterData, double[][]>();
    private MissingValuesPolicy missingValuesPolicy;

    public AbstractDistanceMeasure() {
        this(MissingValuesPolicy.FLOOR);
    }

    public AbstractDistanceMeasure(MissingValuesPolicy policy) {
        this.setMissingValuesPolicy(policy);
    }

    @Override
    public double getDistance(int idX, int idY, CoreHunterData data) {
        double d;
        double[][] distances = this.cache.get(data);
        if (distances != null && !Double.isNaN(distances[idX][idY])) {
            return distances[idX][idY];
        }
        if (distances == null) {
            int n = data.getSize();
            for (double[] row : distances = new double[n][n]) {
                Arrays.fill(row, Double.NaN);
            }
            this.cache.put(data, distances);
        }
        distances[idX][idY] = d = idX != idY ? this.computeDistance(idX, idY, data) : 0.0;
        distances[idY][idX] = d;
        return d;
    }

    protected abstract double computeDistance(int var1, int var2, CoreHunterData var3);

    @Override
    public final void setMissingValuesPolicy(MissingValuesPolicy policy) {
        if (this.missingValuesPolicy != policy) {
            this.missingValuesPolicy = policy;
            this.cache.clear();
        }
    }

    protected double missingValueContribution(double ceilValue) {
        switch (this.missingValuesPolicy) {
            case FLOOR: {
                return 0.0;
            }
            case CEIL: {
                return ceilValue;
            }
        }
        throw new RuntimeException("This should not happen: unexpected missing values policy " + (Object)((Object)this.missingValuesPolicy));
    }
}

