/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.style.theme;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import org.knowm.xchart.style.PieStyler;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.colors.ChartColor;
import org.knowm.xchart.style.colors.SeriesColors;
import org.knowm.xchart.style.lines.SeriesLines;
import org.knowm.xchart.style.markers.SeriesMarkers;

public interface Theme
extends SeriesMarkers,
SeriesLines,
SeriesColors {
    public static final Font BASE_FONT = new Font("SansSerif", 0, 10);
    public static final BasicStroke BASE_STROKE = new BasicStroke(1.0f);

    public Font getBaseFont();

    public Color getChartBackgroundColor();

    public Color getChartFontColor();

    public int getChartPadding();

    public Font getChartTitleFont();

    public boolean isChartTitleVisible();

    public boolean isChartTitleBoxVisible();

    public Color getChartTitleBoxBackgroundColor();

    public Color getChartTitleBoxBorderColor();

    public int getChartTitlePadding();

    public Font getLegendFont();

    public boolean isLegendVisible();

    public Color getLegendBackgroundColor();

    public Color getLegendBorderColor();

    public int getLegendPadding();

    public int getLegendSeriesLineLength();

    public Styler.LegendPosition getLegendPosition();

    public boolean isPlotGridLinesVisible();

    public boolean isPlotGridVerticalLinesVisible();

    public boolean isPlotGridHorizontalLinesVisible();

    public Color getPlotBackgroundColor();

    public Color getPlotBorderColor();

    public boolean isPlotBorderVisible();

    public Color getPlotGridLinesColor();

    public BasicStroke getPlotGridLinesStroke();

    public boolean isPlotTicksMarksVisible();

    default public double getPlotContentSize() {
        return 0.92;
    }

    public int getPlotMargin();

    default public Font getAnnotationTextPanelFont() {
        return new Font("Monospaced", 0, 10);
    }

    default public Color getAnnotationTextPanelFontColor() {
        return ChartColor.BLACK.getColor();
    }

    default public Color getAnnotationTextPanelBackgroundColor() {
        return ChartColor.WHITE.getColor();
    }

    default public Color getAnnotationTextPanelBorderColor() {
        return ChartColor.DARK_GREY.getColor();
    }

    default public int getAnnotationTextPanelPadding() {
        return 10;
    }

    default public Font getAnnotationTextFont() {
        return new Font("Monospaced", 0, 10);
    }

    default public Color getAnnotationTextFontColor() {
        return ChartColor.BLACK.getColor();
    }

    default public BasicStroke getAnnotationLineStroke() {
        return BASE_STROKE;
    }

    default public Color getAnnotationLineColor() {
        return ChartColor.DARK_GREY.getColor();
    }

    default public Color getChartButtonBackgroundColor() {
        return ChartColor.BLUE.getColor().brighter();
    }

    default public Color getChartButtonBorderColor() {
        return ChartColor.BLUE.getColor().darker();
    }

    default public Color getChartButtonHoverColor() {
        return ChartColor.BLUE.getColor();
    }

    default public Color getChartButtonFontColor() {
        return this.getChartFontColor();
    }

    default public Font getChartButtonFont() {
        return this.getLegendFont();
    }

    default public int getChartButtonMargin() {
        return 6;
    }

    default public boolean isToolTipsEnabled() {
        return false;
    }

    default public Styler.ToolTipType getToolTipType() {
        return Styler.ToolTipType.xAndYLabels;
    }

    default public Font getToolTipFont() {
        return BASE_FONT;
    }

    default public Color getToolTipBackgroundColor() {
        return ChartColor.WHITE.getColor();
    }

    default public Color getToolTipBorderColor() {
        return ChartColor.DARK_GREY.getColor();
    }

    default public Color getToolTipHighlightColor() {
        return ChartColor.LIGHT_GREY.getColor();
    }

    public boolean isXAxisTitleVisible();

    public boolean isYAxisTitleVisible();

    public Font getAxisTitleFont();

    public boolean isXAxisTicksVisible();

    public boolean isYAxisTicksVisible();

    public Font getAxisTickLabelsFont();

    public int getAxisTickMarkLength();

    public int getAxisTickPadding();

    public Color getAxisTickMarksColor();

    public BasicStroke getAxisTickMarksStroke();

    public Color getAxisTickLabelsColor();

    public boolean isAxisTicksLineVisible();

    public boolean isAxisTicksMarksVisible();

    public int getAxisTitlePadding();

    public int getXAxisTickMarkSpacingHint();

    public int getYAxisTickMarkSpacingHint();

    public boolean isCursorEnabled();

    public Color getCursorColor();

    public float getCursorSize();

    public Font getCursorFont();

    public Color getCursorFontColor();

    public Color getCursorBackgroundColor();

    default public boolean isZoomEnabled() {
        return false;
    }

    public double getAvailableSpaceFill();

    public boolean isOverlapped();

    public boolean isCircular();

    public double getStartAngleInDegrees();

    public Font getPieFont();

    public double getLabelsDistance();

    public PieStyler.LabelType getLabelType();

    public boolean setForceAllLabelsVisible();

    public double getDonutThickness();

    public boolean isSumVisible();

    public Font getSumFont();

    public int getMarkerSize();

    public Color getErrorBarsColor();

    public boolean isErrorBarsColorSeriesColor();

    default public Color getLabelsFontColorAutomaticDark() {
        return Color.BLACK;
    }

    default public Color getLabelsFontColorAutomaticLight() {
        return Color.WHITE;
    }

    default public boolean isLabelsFontColorAutomaticEnabled() {
        return true;
    }
}

