/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.io;

import dr.evolution.alignment.Alignment;
import dr.evolution.alignment.SimpleAlignment;
import dr.evolution.datatype.DataType;
import dr.evolution.io.Importer;
import dr.evolution.io.SequenceImporter;
import dr.evolution.sequence.Sequence;
import dr.evolution.sequence.SequenceList;
import dr.evolution.util.Taxon;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class FastaImporter
extends Importer
implements SequenceImporter {
    public static final char FASTA_FIRST_CHAR = '>';
    private DataType dataType;
    private int maxNameLength = 10;

    public FastaImporter(Reader reader, DataType dataType) {
        this(reader, null, dataType);
    }

    public FastaImporter(Reader reader, Writer writer, DataType dataType) {
        super(reader, writer);
        this.setCommentDelimiters('\u0000', '\u0000', '\u0000');
        this.dataType = dataType;
    }

    @Override
    public Alignment importAlignment() throws IOException, Importer.ImportException {
        SimpleAlignment simpleAlignment = null;
        try {
            while (this.read() != '>') {
            }
            do {
                String string = this.readLine().trim();
                StringBuilder stringBuilder = new StringBuilder();
                this.readSequence(stringBuilder, this.dataType, ">", Integer.MAX_VALUE, "-", "?", "", "");
                if (simpleAlignment == null) {
                    simpleAlignment = new SimpleAlignment();
                }
                simpleAlignment.addSequence(new Sequence(new Taxon(string.toString()), stringBuilder.toString()));
            } while (this.getLastDelimiter() == 62);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return simpleAlignment;
    }

    @Override
    public SequenceList importSequences() throws IOException, Importer.ImportException {
        return this.importAlignment();
    }
}

