/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel.nucleotide;

import dr.evolution.datatype.Nucleotides;
import dr.evomodel.substmodel.BaseSubstitutionModel;
import dr.evomodel.substmodel.EigenDecomposition;
import dr.evomodel.substmodel.FrequencyModel;
import dr.inference.model.Parameter;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;

public class TN93
extends BaseSubstitutionModel
implements Citable {
    private Parameter kappaParameter1 = null;
    private Parameter kappaParameter2 = null;
    public static Citation CITATION = new Citation(new Author[]{new Author("K", "Tamura"), new Author("M", "Nei")}, "Estimation of the number of nucleotide substitutions in the control region of mitochondrial DNA in humans and chimpanzees", 1993, "Mol Biol Evol", 10, 512, 526);

    public TN93(Parameter parameter, Parameter parameter2, FrequencyModel frequencyModel) {
        super("TN93", Nucleotides.INSTANCE, frequencyModel);
        this.kappaParameter1 = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.kappaParameter2 = parameter2;
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
    }

    public final double getKappa1() {
        return this.kappaParameter1.getParameterValue(0);
    }

    public final double getKappa2() {
        return this.kappaParameter2.getParameterValue(0);
    }

    @Override
    protected void frequenciesChanged() {
    }

    @Override
    protected void ratesChanged() {
    }

    @Override
    protected void setupRelativeRates(double[] dArray) {
        double d = this.getKappa1();
        double d2 = this.getKappa2();
        dArray[0] = 1.0;
        dArray[1] = d;
        dArray[2] = 1.0;
        dArray[3] = 1.0;
        dArray[4] = d2;
        dArray[5] = 1.0;
    }

    @Override
    public synchronized EigenDecomposition getEigenDecomposition() {
        double[] dArray;
        double[] dArray2;
        double[] dArray3;
        if (this.eigenDecomposition == null) {
            dArray3 = new double[this.stateCount * this.stateCount];
            dArray2 = new double[this.stateCount * this.stateCount];
            dArray = new double[this.stateCount];
            this.eigenDecomposition = new EigenDecomposition(dArray3, dArray2, dArray);
            dArray2[2 * this.stateCount + 1] = 1.0;
            dArray2[2 * this.stateCount + 3] = -1.0;
            dArray2[3 * this.stateCount + 0] = 1.0;
            dArray2[3 * this.stateCount + 2] = -1.0;
            dArray3[0 * this.stateCount + 0] = 1.0;
            dArray3[1 * this.stateCount + 0] = 1.0;
            dArray3[2 * this.stateCount + 0] = 1.0;
            dArray3[3 * this.stateCount + 0] = 1.0;
        }
        if (this.updateMatrix) {
            dArray3 = this.eigenDecomposition.getEigenVectors();
            dArray2 = this.eigenDecomposition.getInverseEigenVectors();
            dArray = this.freqModel.getFrequencies();
            double d = dArray[0] + dArray[2];
            double d2 = dArray[1] + dArray[3];
            dArray2[0 * this.stateCount + 0] = dArray[0];
            dArray2[0 * this.stateCount + 1] = dArray[1];
            dArray2[0 * this.stateCount + 2] = dArray[2];
            dArray2[0 * this.stateCount + 3] = dArray[3];
            dArray2[1 * this.stateCount + 0] = dArray[0] * d2;
            dArray2[1 * this.stateCount + 1] = -dArray[1] * d;
            dArray2[1 * this.stateCount + 2] = dArray[2] * d2;
            dArray2[1 * this.stateCount + 3] = -dArray[3] * d;
            dArray3[0 * this.stateCount + 1] = 1.0 / d;
            dArray3[1 * this.stateCount + 1] = -1.0 / d2;
            dArray3[2 * this.stateCount + 1] = 1.0 / d;
            dArray3[3 * this.stateCount + 1] = -1.0 / d2;
            dArray3[1 * this.stateCount + 2] = dArray[3] / d2;
            dArray3[3 * this.stateCount + 2] = -dArray[1] / d2;
            dArray3[0 * this.stateCount + 3] = dArray[2] / d;
            dArray3[2 * this.stateCount + 3] = -dArray[0] / d;
            double[] dArray4 = this.eigenDecomposition.getEigenValues();
            double d3 = this.getKappa1();
            double d4 = this.getKappa2();
            double d5 = -1.0 / (2.0 * (d * d2 + d3 * dArray[0] * dArray[2] + d4 * dArray[1] * dArray[3]));
            double d6 = 1.0 + d * (d3 - 1.0);
            double d7 = 1.0 + d2 * (d4 - 1.0);
            dArray4[1] = d5;
            dArray4[2] = d5 * d7;
            dArray4[3] = d5 * d6;
            this.updateMatrix = false;
        }
        return this.eigenDecomposition;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.SUBSTITUTION_MODELS;
    }

    @Override
    public String getDescription() {
        return "Tamura-Nei nucleotide substitution model";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }
}

