/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.discrete;

import dr.evolution.tree.NodeRef;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.GraphicalParameterBound;
import dr.inference.model.Parameter;

public class NodeHeightBounds
implements GraphicalParameterBound {
    final Parameter nodeHeight;
    final TreeModel treeModel;
    private final int externalNodeCount;

    public NodeHeightBounds(Parameter parameter, TreeModel treeModel) {
        this.nodeHeight = parameter;
        this.treeModel = treeModel;
        this.externalNodeCount = treeModel.getExternalNodeCount();
    }

    @Override
    public Parameter getParameter() {
        return this.nodeHeight;
    }

    @Override
    public int[] getConnectedParameterIndices(int n) {
        NodeRef nodeRef = this.treeModel.getNode(n + this.externalNodeCount);
        int n2 = 0;
        for (int i = 0; i < this.treeModel.getChildCount(nodeRef); ++i) {
            if (this.treeModel.isExternal(this.treeModel.getChild(nodeRef, i))) continue;
            ++n2;
        }
        if (!this.treeModel.isRoot(nodeRef)) {
            ++n2;
        }
        int[] nArray = new int[n2];
        int n3 = 0;
        for (int i = 0; i < this.treeModel.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef2 = this.treeModel.getChild(nodeRef, i);
            if (this.treeModel.isExternal(nodeRef2)) continue;
            nArray[n3] = nodeRef2.getNumber() - this.externalNodeCount;
            ++n3;
        }
        if (!this.treeModel.isRoot(nodeRef)) {
            nArray[n2 - 1] = this.treeModel.getParent(nodeRef).getNumber() - this.externalNodeCount;
        }
        return nArray;
    }

    @Override
    public double getFixedLowerBound(int n) {
        NodeRef nodeRef = this.treeModel.getNode(n + this.externalNodeCount);
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.treeModel.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef2 = this.treeModel.getChild(nodeRef, i);
            if (!this.treeModel.isExternal(nodeRef2) || !(this.treeModel.getNodeHeight(nodeRef2) > d)) continue;
            d = this.treeModel.getNodeHeight(nodeRef2);
        }
        return d;
    }

    @Override
    public double getFixedUpperBound(int n) {
        return Double.POSITIVE_INFINITY;
    }
}

