library(CARMS)

# usage carms.make<-function(title, diagram_grid=c(12,12),...)
Pa3Degr<-carms.make(title="Parallel    Degraded states", diagram_grid=c(15,12))
#usage carms.state<-function(x, prob,  name, size=4, h2w=21/24, position, plot.color=NULL,  description="")
Pa3Degr<-carms.state(Pa3Degr, prob=1, name="All good", size=4.5, h2w=18/19, position=c(2,14) )
Pa3Degr<-carms.state(Pa3Degr, prob=0, name="  1 degraded", size=4.5, h2w=18/19, position=c(5,14) )
Pa3Degr<-carms.state(Pa3Degr, prob=0, name="  2 degraded", size=4.5, h2w=18/19, position=c(8,14) )
Pa3Degr<-carms.state(Pa3Degr, prob=0, name="  3 degraded", size=4.5, h2w=18/19, position=c(11,14) )
Pa3Degr<-carms.state(Pa3Degr, prob=0, name="1 degraded, 1 failed", size=4.5, h2w=18/19, position=c(5,10) )
Pa3Degr<-carms.state(Pa3Degr, prob=0, name="2 degraded, 1 failed", size=4.5, h2w=18/19, position=c(8,10) )
Pa3Degr<-carms.state(Pa3Degr, prob=0, name="3 degraded, 1 failed", size=4.5, h2w=18/19, position=c(11,10) )
Pa3Degr<-carms.state(Pa3Degr, prob=0, name="2 degraded, 2 failed", size=4.5, h2w=18/19, position=c(8,6) )
Pa3Degr<-carms.state(Pa3Degr, prob=0, name="3 degraded, 2 failed", size=4.5, h2w=18/19, position=c(11,6) )
Pa3Degr<-carms.state(Pa3Degr, prob=0, name="3 degraded, 3 failed", size=4.5, h2w=18/19, position=c(11,2) )


# carms.base(x, value, time_units=NULL, base_label=NULL, description="")
Pa3Degr<-carms.base(Pa3Degr, 1e-1, time_units="hours", description="Degradation rate")
Pa3Degr<-carms.base(Pa3Degr, 1e-2, description="Failure rate")

# carms.arrow(x, from, to, rate, arc=0.35, arrow.position=0.5, label="")
Pa3Degr<-carms.arrow(Pa3Degr, from=1, to=2, rate="3*B1", arc=.2, label="3 * B1")
Pa3Degr<-carms.arrow(Pa3Degr, from=2, to=3, rate="2*B1", arc=.2, label="2 * B1")
Pa3Degr<-carms.arrow(Pa3Degr, from=3, to=4, rate="B1", arc=.2, label="B1")
Pa3Degr<-carms.arrow(Pa3Degr, from=2, to=5, rate="B2", arc=.2, label="B2")
Pa3Degr<-carms.arrow(Pa3Degr, from=3, to=6, rate="2 * B2", arc=.2, label="2 * B2")
Pa3Degr<-carms.arrow(Pa3Degr, from=4, to=7, rate="3 * B2", arc=.2, label="3 * B2")
Pa3Degr<-carms.arrow(Pa3Degr, from=5, to=6, rate="2 * B1", arc=.2, label="2 * B1")
Pa3Degr<-carms.arrow(Pa3Degr, from=6, to=7, rate="B1", arc=.2, label="B1")
Pa3Degr<-carms.arrow(Pa3Degr, from=6, to=8, rate="B2", arc=.2, label="B2")
Pa3Degr<-carms.arrow(Pa3Degr, from=7, to=9, rate="2 * B2", arc=.2, label="2 * B2")
Pa3Degr<-carms.arrow(Pa3Degr, from=8, to=9, rate="B1", arc=.2, label="B1")
Pa3Degr<-carms.arrow(Pa3Degr, from=9, to=10, rate="B2", arc=.2, label="B2")
	dev.new(width=15, height=15, unit="in")
	diagram(Pa3Degr)

# usage: simulate.carms(x, solution, mission_time, intervals=50, cycles=2000)
Pa3Degr<-simulate.carms(Pa3Degr, "rk", mission_time=60, intervals=200)

plot(Pa3Degr, smooth_curve=T)
