require(CARMS)

# usage: carms.make(title, diagram_grid=c(11,12),...)
SaPitch<-carms.make(title="Gyro simulation         extended mode", diagram_grid=c(55,30) )

#usage: carms.state<-function(x, prob,  name, size=4, h2w=21/24, position, plot.color=NULL,  description="")
SaPitch<-carms.state(SaPitch, prob=1, name="All good", size=2.2, h2w=12.5, position=c(3,30) )
SaPitch<-carms.state(SaPitch, prob=0, name="1 failure, no warning", size=2.2, h2w=13/14, position=c(7,12) )
SaPitch<-carms.state(SaPitch, prob=0, name="1 failure, no warning", size=2.2, h2w=13/14, position=c(7,16) )
SaPitch<-carms.state(SaPitch, prob=0, name="1 failure, no warning", size=2.2, h2w=13/14, position=c(7,20) )
SaPitch<-carms.state(SaPitch, prob=0, name="1 failure, no warning", size=2.2, h2w=13/14, position=c(7,24) )
SaPitch<-carms.state(SaPitch, prob=0, name="1 failure, no warning", size=2.2, h2w=13/15, position=c(7,35) )
SaPitch<-carms.state(SaPitch, prob=0, name="1 failure, no warning", size=2.2, h2w=13/15, position=c(7,39) )
SaPitch<-carms.state(SaPitch, prob=0, name="1 failure, no warning", size=2.2, h2w=13/18, position=c(7,43) )
SaPitch<-carms.state(SaPitch, prob=0, name="1 failure, no warning", size=2.2, h2w=13/15, position=c(7,47) )
SaPitch<-carms.state(SaPitch, prob=0, name="1 channel failed,downstream warning", size=2.2, h2w=13/15, position=c(15,9) )
SaPitch<-carms.state(SaPitch, prob=0, name="1 channel failed,downstream warning", size=2.2, h2w=13/15, position=c(15,14) )
SaPitch<-carms.state(SaPitch, prob=0, name="1 channel failed,downstream warning", size=2.2, h2w=13/15, position=c(15,19) )
SaPitch<-carms.state(SaPitch, prob=0, name="1 channel failed,corrected by ms warning", size=2.2, h2w=13/15, position=c(15,23) )
SaPitch<-carms.state(SaPitch, prob=0, name="1 channel failed,corrected by ms warning", size=2.2, h2w=13/15, position=c(15,27) )
SaPitch<-carms.state(SaPitch, prob=0, name="1 channel failed,corrected by ms warning", size=2.2, h2w=13/15, position=c(15,33) )
SaPitch<-carms.state(SaPitch, prob=0, name="single channel failed, corrected no warning", size=2.2, h2w=13/15, position=c(15,38) )
SaPitch<-carms.state(SaPitch, prob=0, name="single channel failed, corrected no warning", size=2.2, h2w=13/15, position=c(15,43) )
SaPitch<-carms.state(SaPitch, prob=0, name="single channel failed, corrected no warning", size=2.2, h2w=13/15, position=c(15,48) )
SaPitch<-carms.state(SaPitch, prob=0, name="false warning", size=2.2, h2w=13/15, position=c(20,7) )
SaPitch<-carms.state(SaPitch, prob=0, name="axis lost after warning", size=2.2, h2w=2.5, position=c(23,22))
SaPitch<-carms.state(SaPitch, prob=0, name="axis lost, no warning", size=2, h2w=4, position=c(23,46 ))
SaPitch<-carms.state(SaPitch, prob=0, name="P10:P15+P19+0.5*(P20+P21)", size=2, h2w=7, description="Crit failure formula",position=c(27,20),
Pfunction="P[,22]<-rowSums(P[,10:15])+P[,19]+.5*(P[,20]+P[,21])" )
SaPitch<-carms.state(SaPitch, prob=0, name="0.5*(P20+P21)", size=1.7, h2w=2.5, description="Crit failure formula",position=c(27,42),
Pfunction="P[,23]<-.5*(P[,20]+P[,21])" )


# carms.base(x, value, time_units=NULL, base_label=NULL, description="")
SaPitch<-carms.base(SaPitch, 7.5e-6, time_units="hours", description="comparator failure open")
SaPitch<-carms.base(SaPitch, 3.8e-6, description="comparator failure open")
SaPitch<-carms.base(SaPitch, 3.9e-6, description="logic failure open")
SaPitch<-carms.base(SaPitch, 1.5e-6, description="logic failure short")
SaPitch<-carms.base(SaPitch, 7.6e-8, description="input diode open")
SaPitch<-carms.base(SaPitch, 3.0e-7, description="input diode short")
SaPitch<-carms.base(SaPitch, 7.6e-8, description="input diode open")
SaPitch<-carms.base(SaPitch, 3.0e-7, description="input diode short")
SaPitch<-carms.base(SaPitch, 1.7e-7, description="resistor +exc open")
SaPitch<-carms.base(SaPitch, 0, description="resistor +exc short")
SaPitch<-carms.base(SaPitch, 1.7e-7, description="resistor +exc open")
SaPitch<-carms.base(SaPitch, 6e-6, description="resistor -exc short")
SaPitch<-carms.base(SaPitch,4.9e-5, description="A control channel failure")
SaPitch<-carms.base(SaPitch, 0, description="B control channel failure")
SaPitch<-carms.base(SaPitch,2.5e-5, description="Common contro channel failure")
SaPitch<-carms.base(SaPitch,2.5e-5, description="A control channel hardover")
SaPitch<-carms.base(SaPitch, 0, description="B control channel hardover")
SaPitch<-carms.base(SaPitch,2.2e-5, description="Common control channel hardover")

# carms.arrow(x, from, to, rate, arc=0.35, arrow.position=0.5, label="")
SaPitch<-carms.arrow(SaPitch, from=1, to=2, rate="9*B8", arc=.33, arrow.position=.8, label="9*B8")
SaPitch<-carms.arrow(SaPitch, from=1, to=3, rate="18*B5", arc=.3, arrow.position=.75, label="18*B5")
SaPitch<-carms.arrow(SaPitch, from=1, to=4, rate="9*B8", arc=.25, arrow.position=.7, label="9*B8")
SaPitch<-carms.arrow(SaPitch, from=1, to=5, rate="18*B5", arc=.01, label="18*B5")
SaPitch<-carms.arrow(SaPitch, from=1, to=6, rate="2*B1", arc=-.01, label="2*B1")
SaPitch<-carms.arrow(SaPitch, from=1, to=7, rate="B3", arc=-.25, arrow.position=.7, label="B3")
SaPitch<-carms.arrow(SaPitch, from=1, to=8, rate="18*B6", arc=-.3, arrow.position=.75, label="18*B6")
SaPitch<-carms.arrow(SaPitch, from=1, to=9, rate="18*B6", arc=-.35, arrow.position=.8, label="18*B6")
SaPitch<-carms.arrow(SaPitch, from=1, to=10, rate="18*(B7+B9)+6*B11", arc=.38, arrow.position=.7, label="18*(B7+B9)+6*B11")
SaPitch<-carms.arrow(SaPitch, from=2, to=11, rate="2*(B16+B18)", arc=.01, arrow.position=.5, label="2*(B16+B18)")
SaPitch<-carms.arrow(SaPitch, from=3, to=11, rate="B16+B18", arc=.01, arrow.position=.4, label="B16+B18")
SaPitch<-carms.arrow(SaPitch, from=4, to=12, rate="2*(B17+B18)", arc=.01, arrow.position=.4, label="2*(B17+B18)")
SaPitch<-carms.arrow(SaPitch, from=5, to=12, rate="B17+B18", arc=.01, arrow.position=.4, label="B17+B18")
SaPitch<-carms.arrow(SaPitch, from=1, to=13, rate="3*B13", arc=-.01, arrow.position=.5, label="3*B13")
SaPitch<-carms.arrow(SaPitch, from=1, to=14, rate="3*B14", arc=-.01, arrow.position=.5, label="3*B14")
SaPitch<-carms.arrow(SaPitch, from=1, to=15, rate="3*B15", arc=-.01, arrow.position=.7, label="3*B15")
SaPitch<-carms.arrow(SaPitch, from=6, to=13, rate="2*B13", arc=.01, arrow.position=.3, label="2*B13")
SaPitch<-carms.arrow(SaPitch, from=6, to=14, rate="2*B14", arc=.01, arrow.position=.5, label="2*B14")
SaPitch<-carms.arrow(SaPitch, from=6, to=16, rate="B13", arc=.01, arrow.position=.5, label="B13")
SaPitch<-carms.arrow(SaPitch, from=6, to=17, rate="B14", arc=.01, arrow.position=.5, label="B14")
SaPitch<-carms.arrow(SaPitch, from=6, to=18, rate="3*B15", arc=.01, arrow.position=.5, label="3*B15")
SaPitch<-carms.arrow(SaPitch, from=7, to=16, rate="3*B13", arc=.01, arrow.position=.5, label="3*B13")
SaPitch<-carms.arrow(SaPitch, from=7, to=17, rate="3*B14", arc=.01, arrow.position=.5, label="3*B14")
SaPitch<-carms.arrow(SaPitch, from=7, to=18, rate="3*B15", arc=.01, arrow.position=.5, label="3*B15")
SaPitch<-carms.arrow(SaPitch, from=8, to=21, rate="B13+B15", arc=-.07, arrow.position=.6, label="B13+B15")
SaPitch<-carms.arrow(SaPitch, from=9, to=21, rate="B14+B15", arc=-.2, arrow.position=.3, label="B14+B15")
SaPitch<-carms.arrow(SaPitch, from=18, to=21, rate="2*(B13+B14+B15)", arc=-.2, arrow.position=.3, label="2*(B13+B14+B15)")
SaPitch<-carms.arrow(SaPitch, from=17, to=21, rate="2*(B14+B15)", arc=.1, arrow.position=.6, label="2*(B14+B15)")
SaPitch<-carms.arrow(SaPitch, from=16, to=21, rate="2*(B13+B14)", arc=.1, arrow.position=.5, label="2*(B13+B14)")
SaPitch<-carms.arrow(SaPitch, from=15, to=22, rate=0, arc=-.35, arrow.position=.5, label="abort")
SaPitch<-carms.arrow(SaPitch, from=21, to=22, rate=0, arc=-.1, arrow.position=.5, label="abort")
SaPitch<-carms.arrow(SaPitch, from=21, to=23, rate=0, arc=-.01, arrow.position=.5, label="crit failure")
SaPitch<-carms.arrow(SaPitch, from=14, to=22, rate=0, arc=-.35, arrow.position=.5, label="abort")
SaPitch<-carms.arrow(SaPitch, from=13, to=22, rate=0, arc=-.3, arrow.position=.5, label="abort")
SaPitch<-carms.arrow(SaPitch, from=14, to=20, rate="2*(B13+B15)", arc=-.1, arrow.position=.5, label="2*(B13+B15)")
SaPitch<-carms.arrow(SaPitch, from=13, to=20, rate="2*(B13+B15)", arc=-.1, arrow.position=.5, label="2*(B13+B15)")
SaPitch<-carms.arrow(SaPitch, from=12, to=20, rate="2*(B14+B15)", arc=-.05, arrow.position=.6, label="2*(B14+B15)")
SaPitch<-carms.arrow(SaPitch, from=12, to=22, rate=0, arc=.2, arrow.position=.6, label="abort")
SaPitch<-carms.arrow(SaPitch, from=11, to=20, rate="12*(B7+B9)+4*B11", arc=.05, arrow.position=.5, label="12*(B7+B9)+4*B11")
SaPitch<-carms.arrow(SaPitch, from=11, to=22, rate=0, arc=.05, arrow.position=.5, label="abort")
SaPitch<-carms.arrow(SaPitch, from=10, to=20, rate="12*(B7+B9)+4*B11", arc=.05, arrow.position=.5, label="12*(B7+B9)+4*B11")
SaPitch<-carms.arrow(SaPitch, from=10, to=22, rate=0, arc=.13, arrow.position=.5, label="abort")
SaPitch<-carms.arrow(SaPitch, from=15, to=20, rate="2*(B13+B14+B15)", arc=-.1, arrow.position=.5, label="2*(B13+B14+B15)")
SaPitch<-carms.arrow(SaPitch, from=1, to=19, rate="2*B2+B4+B12", arc=.38, arrow.position=.9, label="2*B2+B4+B12")
SaPitch<-carms.arrow(SaPitch, from=19, to=22, rate=0, arc=.09, arrow.position=.5, label="abort")
SaPitch<-carms.arrow(SaPitch, from=20, to=22, rate=0, arc=-.25, arrow.position=.5, label="abort")
SaPitch<-carms.arrow(SaPitch, from=20, to=23, rate=0, arc=-.05, arrow.position=.5, label="crit failure")
SaPitch<-carms.arrow(SaPitch, from=1, to=21, rate="18*B10", arc=-.42, arrow.position=.6, label="18*B10")
SaPitch<-carms.arrow(SaPitch, from=6, to=15, rate="2*B15", arc=0, arrow.position=.5, label="2*B15")
	dev.new(width=35, height=25, unit="in")
	diagram(SaPitch, rate.text.y.shift=1.5)
# usage: simulate.carms(x, solution, mission_time, intervals=50, cycles=2000)
SaPitch<-simulate(SaPitch, "rk", 1e4, 50)

plot(SaPitch)
