## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(dplyr)
library(tidyr)
library(purrr)
library(CMHSU)

## ----echo=FALSE, message=FALSE, warning=FALSE---------------------------------
library(knitr)

simulation_table <- data.frame(
  Group = c(1, 2, 3, 4, 5, 6, 7),
  Size = c(10, 20, 30, 40, 25, 25, 50),
  `VisitDate Span` = c(
    "01.01.2024-31.01.2024", "01.02.2024-31.03.2024",
    "01.04.2024-31.06.2024", "01.07.2024-31.12.2024",
    "01.11.2024-31.12.2024", "01.11.2024-31.12.2024",
    "01.11.2024-31.12.2024"
  ),
  `Visit Length` = c(
    "One month", "Two months", "Three months",
    "Six months", "Two months", "Two months", "Two months"
  ),
  `SU (freq)` = c("F100(1)", "T4041(2)", "F120(3)", "F140(6)", "F100(3)", "NA", "NA"),
  `MH (freq)` = c("F060(2)", "F063(4)", "F064(6)", "F067(12)", "NA", "F060(4)", "NA"),
  `Other (freq)` = c(
    "NA", "J10(4)", "I10(3)", "I10(6),J10(12)", "J10(6)", "I10(2)", "I10(1),J10(2)"
  )
)


kable(
  simulation_table,
  col.names = c("Group", "Size", "VisitDate Span", "Visit Length", 
                "SU (freq)", "MH (freq)", "Other (freq)"),
  caption = "Real-World Data (RWD) Sample Simulation Table",
  format = "html"
)


cat("
**Notes**: F100 (Alcohol); F060 (Psychotic); T4041 (Fentanyl); F063 (Mood); F120 (Cannabis); 
F064 (Anxiety); F140 (Cocaine); F067 (Neurocognitive); I10 (Hypertension); 
J10 (Influenza); NA (Not Applicable)
")

## -----------------------------------------------------------------------------
data("SampleRWD")
myexample<-SampleRWD[,c(1:4)]
SampleMH_1=MH_status(myexample, n_MHH=1, n_MHP=1, t_MH=60,
                     ICD_MH=c("F060","F063","F064", "F067"))
head(SampleMH_1)

## -----------------------------------------------------------------------------
myexample<-SampleRWD[,c(1:4)]
SampleSU_1=SU_status(myexample, n_SUH=1, n_SUP=1,  t_SU=60,
                     ICD_SU=c("F100","T4041","F120","F140"))
head(SampleSU_1) 

## -----------------------------------------------------------------------------
myexample<-SampleRWD[,c(1:4)]
SampleMHSU_1=MHSU_status_basic(myexample,
                               n_MHH=1, n_MHP=1, n_SUH=1, n_SUP=1,
                               t_MH=60, t_SU=60, t_MHSU=365,
                               ICD_MH=c("F060","F063","F064", "F067"),
                               ICD_SU=c("F100","T4041","F120","F140"))

head(SampleMHSU_1)


## -----------------------------------------------------------------------------
SampleMHSU_2=MHSU_status_broad(myexample,
                              n_MHH=1, n_MHP=1, n_SUH=1, n_SUP=1,
                              t_MH=60, t_SU=60, t_MHSU=360,
                              ICD_MH=c("F060","F063","F064", "F067"),
                              ICD_SU=c("F100","T4041","F120","F140"))


head(SampleMHSU_2[c(1,201,401,601),]) 

