## ----setup, include=FALSE---------------------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)
options(width = 90) 

## ---------------------------------------------------------------------------------------
#install.packages('ClussCluster')
library(ClussCluster)

## ---------------------------------------------------------------------------------------
data(Hou_sim)
hou.dat <- Hou_sim$x
dim(hou.dat)
hou.dat[1:10, 1:5]

## ---------------------------------------------------------------------------------------
Hou_sim$groups
table(Hou_sim$y)

## ---------------------------------------------------------------------------------------
Hou_sim$gnames[1:10]
Hou_sim$snames

## ---------------------------------------------------------------------------------------
data(Hou_sim)
hou.dat <- Hou_sim$x

## ---------------------------------------------------------------------------------------
run.ft <- filter_gene(hou.dat, minmean=1.0, n0prop=0.2, minsd=1.5)
dat.ft <- run.ft$dat.ft

dim(dat.ft)

## ---------------------------------------------------------------------------------------
dat.ft[1:10, 1:5]

## ---------------------------------------------------------------------------------------
summary(apply(dat.ft!=0, 1, mean))
summary(apply(dat.ft, 1, mean))
summary(apply(dat.ft, 1, sd))

## ---------------------------------------------------------------------------------------
run.gap <- ClussCluster_Gap(dat.ft, B=5, nclust = 3, ws = c(2.4, 3.1, 3.8))

## ---------------------------------------------------------------------------------------
print_ClussCluster_Gap(run.gap)

## ---------------------------------------------------------------------------------------
s <- run.gap$onesd.bestw
s

## ---- message=FALSE---------------------------------------------------------------------
i<- match(run.gap$onesd.bestw, c(2.4, 3.1, 3.8))
run.cc <- run.gap$run[[i]]
run.cc <- ClussCluster(dat.ft, nclust = 3, ws = run.gap$onesd.bestw)

## ---------------------------------------------------------------------------------------
theta <- run.cc$theta
table(Hou_sim$y, theta)

## ---------------------------------------------------------------------------------------
print_ClussCluster(run.cc)

## ---------------------------------------------------------------------------------------
wt.mat <- run.cc$w
head(wt.mat, 10)

## ---------------------------------------------------------------------------------------
sig_index <- apply(wt.mat, 2, function(w) which(w!=0))
sig_names <- apply(wt.mat, 2, function(w) rownames(dat.ft)[which(w!=0)])
sig_names

## ---------------------------------------------------------------------------------------
top_5_genes <- apply(wt.mat, 2, function(w) rownames(dat.ft)[order(w, decreasing = T)[1:5]])
top_5_genes

## ---- fig.width=6,fig.height=4----------------------------------------------------------
plot_ClussCluster_Gap(run.gap)

## ---- fig.width=6,fig.height=4----------------------------------------------------------
plot_ClussCluster(run.gap$run)

## ---- fig.width=6,fig.height=4----------------------------------------------------------
plot_ClussCluster(run.cc, m = 5, snames=Hou_sim$snames, gnames=rownames(dat.ft))

