## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, message=FALSE-----------------------------------------------------
library(ConFluxPro)

## ----profiles_start, message = FALSE------------------------------------------
library(dplyr)
data("soilphys", package = "ConFluxPro")
soilphys %>%
  relocate(site, Date, gas) %>%
  head()

## ----profiles_class-----------------------------------------------------------
soilphys <- 
  cfp_profile(soilphys, id_cols = c("site", "Date"))
n_profiles(soilphys)

## ----profiles_id_cols---------------------------------------------------------
cfp_id_cols(soilphys)

## ----gasdata-example----------------------------------------------------------
data("gasdata", package = "ConFluxPro")
head(gasdata)

## ----cfp_gasdata, error=TRUE--------------------------------------------------
try({
# create working cfp_gasdata object
my_gasdata <- cfp_gasdata(gasdata, id_cols = c("site", "Date"))

head(my_gasdata)

# won't work, because depth is missing
gasdata_broken <- gasdata %>% select(!depth)
cfp_gasdata(gasdata_broken, id_cols = c("site", "Date"))
})

## ----soilphys-example---------------------------------------------------------
data("soilphys", package = "ConFluxPro")

my_soilphys <- cfp_soilphys(soilphys, id_cols = c("site", "Date"))

## ----soilphys-complete-sp-----------------------------------------------------
soilphys_measured_only <- 
  soilphys %>% 
  select(!all_of(c("AFPS", "DSD0", "D0", "DS", "c_air")))

head(soilphys_measured_only)

my_soilphys_completed <- 
  complete_soilphys(soilphys_measured_only, DSD0_formula = "a*AFPS^b")

head(my_soilphys_completed)

## ----soilphys-complete-gases--------------------------------------------------
soilphys_measured_only %>%
  select(!gas) %>%
  complete_soilphys(DSD0_formula = "a*AFPS^b", gases = c("CO2", "CH4")) %>%
  head()

## ----temperature-example------------------------------------------------------
temperature_profile <- 
  data.frame(depth = c(0, -30, -100),
             t = c(25, 20, 16))

## ----temperature-interp-------------------------------------------------------
boundaries <- seq(0, -100, by = -10)

discretize_depth(temperature_profile,
                 param = "t", 
                 method = "linear",
                 depth_target = boundaries)

## -----------------------------------------------------------------------------
temperature_profile_dates <-
  data.frame(date_id = rep(c("date_1", "date_2"), each = 3),
             depth = rep(c(0, -30, -100), times = 2),
             t = c(25, 20, 16, 15, 10, 8)) %>%
  cfp_profile(id_cols = c("date_id"))

discretize_depth(temperature_profile_dates,
                 param = "t", 
                 method = "linear",
                 depth_target = boundaries)

## ----layers_map-load----------------------------------------------------------
data("layers_map", package = "ConFluxPro")

layers_map

## ----may_upper----------------------------------------------------------------
my_gasdata %>%
  group_by(site) %>%
  summarise(max_depth = max(depth))

my_soilphys %>%
  group_by(site) %>%
  summarise(max_upper = max(upper))

## -----------------------------------------------------------------------------
my_layers_map <- 
  cfp_layers_map(
    layers_map,
    id_cols = "site",
    gas = "CO2",
    lowlim = 0,
    highlim = 1000
  )

my_layers_map

## -----------------------------------------------------------------------------
my_dat <- cfp_dat(my_gasdata, my_soilphys, my_layers_map)

my_dat

## -----------------------------------------------------------------------------
my_dat$profiles %>% head()

