/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.StudentDist;
import umontreal.iro.lecuyer.randvar.BinomialGen;
import umontreal.iro.lecuyer.randvar.ChiSquareGen;
import umontreal.iro.lecuyer.randvar.ErlangGen;
import umontreal.iro.lecuyer.randvar.ExponentialGen;
import umontreal.iro.lecuyer.randvar.ExtremeValueGen;
import umontreal.iro.lecuyer.randvar.GeometricGen;
import umontreal.iro.lecuyer.randvar.LogisticGen;
import umontreal.iro.lecuyer.randvar.LognormalGen;
import umontreal.iro.lecuyer.randvar.NegativeBinomialGen;
import umontreal.iro.lecuyer.randvar.NormalGen;
import umontreal.iro.lecuyer.randvar.ParetoGen;
import umontreal.iro.lecuyer.randvar.PoissonGen;
import umontreal.iro.lecuyer.randvar.StudentGen;
import umontreal.iro.lecuyer.randvar.UniformGen;
import umontreal.iro.lecuyer.randvar.WeibullGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class Rand1 {
    private Rand1() {
    }

    public static double uniform(RandomStream randomStream, double d, double d2) {
        return UniformGen.nextDouble(randomStream, d, d2);
    }

    public static double expon(RandomStream randomStream, double d) {
        return ExponentialGen.nextDouble(randomStream, 1.0 / d);
    }

    public static double erlang(RandomStream randomStream, int n, double d) {
        return ErlangGen.nextDouble(randomStream, n, 1.0 / d);
    }

    public static double weibull(RandomStream randomStream, double d, double d2, double d3) {
        return WeibullGen.nextDouble(randomStream, d, d2, d3);
    }

    public static double normal(RandomStream randomStream, double d, double d2) {
        return NormalGen.nextDouble(randomStream, d, d2);
    }

    public static double Logistic(RandomStream randomStream, double d, double d2) {
        return LogisticGen.nextDouble(randomStream, d, d2);
    }

    public static double student(RandomStream randomStream, int n) {
        return StudentGen.nextDouble(randomStream, n);
    }

    public static double invStudentDist(int n, double d) {
        return StudentDist.inverseF(n, d);
    }

    public static double lognormal(RandomStream randomStream, double d, double d2) {
        return LognormalGen.nextDouble(randomStream, d, d2);
    }

    public static double chiSquare(RandomStream randomStream, int n) {
        return ChiSquareGen.nextDouble(randomStream, n);
    }

    public static double gumbel(RandomStream randomStream, double d, double d2) {
        return ExtremeValueGen.nextDouble(randomStream, d, d2);
    }

    public static double pareto(RandomStream randomStream, double d, double d2) {
        return ParetoGen.nextDouble(randomStream, d, d2);
    }

    public static int binomial(RandomStream randomStream, int n, double d) {
        return BinomialGen.nextInt(randomStream, n, d);
    }

    public static int negativeBinomial(RandomStream randomStream, int n, double d) {
        return NegativeBinomialGen.nextInt(randomStream, n, d);
    }

    public static int geometric(RandomStream randomStream, double d) {
        return GeometricGen.nextInt(randomStream, d);
    }

    public static int poisson(RandomStream randomStream, double d) {
        return PoissonGen.nextInt(randomStream, d);
    }
}

