/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simprocs;

import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.eventlist.EventList;
import umontreal.iro.lecuyer.simprocs.SimProcess;
import umontreal.iro.lecuyer.simprocs.SimThreadError;
import umontreal.iro.lecuyer.simprocs.ThreadProcessSimulator;

final class SimThread
extends Event
implements Runnable {
    static SimThreadError error = new SimThreadError();
    private int n = 0;
    SimProcess myProcess;
    private Thread myThread;
    private SimThread nextAll = null;
    private static SimThread threadFreeHead = null;
    private SimThread nextFree = null;

    private SimThread(SimProcess simProcess, ThreadProcessSimulator threadProcessSimulator) {
        super(threadProcessSimulator);
        this.eventTime = -20.0;
        this.myProcess = simProcess;
        this.myThread = new Thread(this);
        this.myThread.setDaemon(true);
        this.myThread.start();
        this.nextAll = ((ThreadProcessSimulator)this.sim).threadAllHead();
        ((ThreadProcessSimulator)this.sim).setThreadAllHead(this);
    }

    public static final SimThread getThread(SimProcess simProcess, ThreadProcessSimulator threadProcessSimulator) {
        if (threadFreeHead == null) {
            return new SimThread(simProcess, threadProcessSimulator);
        }
        SimThread simThread = threadFreeHead;
        threadFreeHead = SimThread.threadFreeHead.nextFree;
        simThread.myProcess = simProcess;
        simThread.eventTime = -20.0;
        simThread.sim = threadProcessSimulator;
        simThread.priority = 1.0;
        return simThread;
    }

    public final void run() {
        while (true) {
            try {
                this.passivate();
                this.myProcess.actions();
                ((ThreadProcessSimulator)this.sim).dispatch();
            }
            catch (SimThreadError simThreadError) {
                // empty catch block
            }
            this.myProcess.setScheduledEvent(null);
            this.myProcess = null;
            this.nextFree = threadFreeHead;
            threadFreeHead = this;
        }
    }

    public void actions() {
        ((ThreadProcessSimulator)this.sim).setCurrentProcess(this.myProcess);
        this.activate();
        SimThread.simPassivate((ThreadProcessSimulator)this.sim);
    }

    protected final synchronized void activate() {
        ++this.n;
        this.notify();
    }

    protected final synchronized void passivate() {
        try {
            --this.n;
            if (this.n < 0) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            ++this.n;
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void simActivate(ThreadProcessSimulator threadProcessSimulator) {
        EventList eventList;
        EventList eventList2 = eventList = threadProcessSimulator.getEventList();
        synchronized (eventList2) {
            eventList.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void simPassivate(ThreadProcessSimulator threadProcessSimulator) {
        EventList eventList;
        EventList eventList2 = eventList = threadProcessSimulator.getEventList();
        synchronized (eventList2) {
            try {
                eventList.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void kill() {
        if (this.eventTime >= 0.0) {
            this.cancel();
        }
        this.myThread.interrupt();
    }

    protected static void killAll(ThreadProcessSimulator threadProcessSimulator) {
        SimThread simThread = threadProcessSimulator.threadAllHead();
        while (simThread != null) {
            if (simThread.myProcess != null) {
                simThread.kill();
            }
            simThread = simThread.nextAll;
        }
    }

    public String toString() {
        return "Start or resume process " + this.myProcess.toString();
    }
}

