/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util;

import java.io.Serializable;

public class BitVector
implements Serializable,
Cloneable {
    static final long serialVersionUID = -3448233092524725148L;
    private int[] v;
    private int length;
    private static final int all_1 = -1;
    private static final int one_1 = 1;

    public BitVector(int n) {
        this.length = n;
        this.v = new int[(n + 31) / 32];
        for (int i = 0; i < this.v.length; ++i) {
            this.v[i] = 0;
        }
    }

    public BitVector(int[] nArray, int n) {
        if ((n + 31) / 32 != nArray.length) {
            throw new IllegalArgumentException("The int[] length must be equal to the (length + 31) / 32");
        }
        this.length = n;
        this.v = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.v[i] = nArray[i];
        }
        int n2 = this.v.length - 1;
        this.v[n2] = this.v[n2] & -1 >>> 31 - (n - 1) % 32;
    }

    public BitVector(int[] nArray) {
        this(nArray, nArray.length * 32);
    }

    public BitVector(BitVector bitVector) {
        this.length = bitVector.length;
        this.v = new int[bitVector.v.length];
        for (int i = 0; i < bitVector.v.length; ++i) {
            this.v[i] = bitVector.v[i];
        }
    }

    public Object clone() {
        try {
            BitVector bitVector = (BitVector)super.clone();
            bitVector.v = (int[])this.v.clone();
            return bitVector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            IllegalStateException illegalStateException = new IllegalStateException();
            illegalStateException.initCause(cloneNotSupportedException);
            throw illegalStateException;
        }
    }

    public boolean equals(BitVector bitVector) {
        if (this.length != bitVector.length) {
            return false;
        }
        for (int i = 0; i < this.v.length; ++i) {
            if (this.v[i] == bitVector.v[i]) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.length;
    }

    public void enlarge(int n, boolean bl) {
        if (n < 0) {
            throw new NegativeArraySizeException("The BitVector must have a non-negative size");
        }
        if (bl && this.length % 32 != 0) {
            int n2 = this.v.length - 1;
            this.v[n2] = this.v[n2] ^ -1 << this.length % 32;
        }
        if ((n + 31) / 32 != this.v.length) {
            int n3;
            int[] nArray = new int[(n + 31) / 32];
            for (n3 = 0; n3 < nArray.length && n3 < this.v.length; ++n3) {
                nArray[n3] = this.v[n3];
            }
            while (n3 < nArray.length) {
                nArray[n3] = bl ? -1 : 0;
                ++n3;
            }
            this.v = nArray;
        }
        this.length = n;
        int n4 = this.v.length - 1;
        this.v[n4] = this.v[n4] & -1 >>> 31 - (this.length - 1) % 32;
    }

    public void enlarge(int n) {
        this.enlarge(n, false);
    }

    public boolean getBool(int n) {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return (this.v[n >>> 5] & 1 << (n & 0x1F)) != 0;
    }

    public void setBool(int n, boolean bl) {
        if (n > this.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (bl) {
            int n2 = n / 32;
            this.v[n2] = this.v[n2] | 1 << n % 32;
        } else {
            int n3 = n / 32;
            this.v[n3] = this.v[n3] & ~(1 << n % 32);
        }
    }

    public int getInt(int n) {
        if (n >= this.v.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.v[n];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = this.length - 1; i > 0; --i) {
            stringBuffer.append(this.getBool(i) ? "1" : "0").append(i % 8 == 0 ? " " : "");
        }
        stringBuffer.append(this.getBool(0) ? "1" : "0");
        return stringBuffer.toString();
    }

    public BitVector not() {
        BitVector bitVector = new BitVector(this.length);
        for (int i = 0; i < this.v.length; ++i) {
            bitVector.v[i] = ~this.v[i];
        }
        int n = this.v.length - 1;
        bitVector.v[n] = bitVector.v[n] & -1 >>> 31 - (this.length - 1) % 32;
        return bitVector;
    }

    public BitVector selfNot() {
        for (int i = 0; i < this.v.length; ++i) {
            this.v[i] = ~this.v[i];
        }
        int n = this.v.length - 1;
        this.v[n] = this.v[n] & -1 >>> 31 - (this.length - 1) % 32;
        return this;
    }

    public BitVector xor(BitVector bitVector) {
        int n;
        if (bitVector.length > this.length) {
            return bitVector.xor(this);
        }
        BitVector bitVector2 = new BitVector(this.length);
        int n2 = this.v.length;
        int n3 = bitVector.v.length;
        for (n = 0; n < n3; ++n) {
            bitVector2.v[n] = this.v[n] ^ bitVector.v[n];
        }
        for (n = n3; n < n2; ++n) {
            bitVector2.v[n] = this.v[n];
        }
        return bitVector2;
    }

    public BitVector selfXor(BitVector bitVector) {
        if (this.length < bitVector.length) {
            this.enlarge(bitVector.length);
        }
        int n = bitVector.v.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            this.v[n2] = this.v[n2] ^ bitVector.v[i];
        }
        return this;
    }

    public BitVector and(BitVector bitVector) {
        int n;
        if (bitVector.length > this.length) {
            return bitVector.and(this);
        }
        BitVector bitVector2 = new BitVector(this.length);
        int n2 = this.v.length;
        int n3 = bitVector.v.length;
        for (n = 0; n < n3; ++n) {
            bitVector2.v[n] = this.v[n] & bitVector.v[n];
        }
        if (bitVector.length % 32 != 0) {
            int n4 = n3 - 1;
            bitVector2.v[n4] = bitVector2.v[n4] | this.v[n3 - 1] & -1 << bitVector.length % 32;
        }
        for (n = n3; n < n2; ++n) {
            bitVector2.v[n] = 0;
        }
        return bitVector2;
    }

    public BitVector selfAnd(BitVector bitVector) {
        if (this.length < bitVector.length) {
            this.enlarge(bitVector.length, true);
        }
        int n = bitVector.v.length;
        for (int i = 0; i < n - 1; ++i) {
            int n2 = i;
            this.v[n2] = this.v[n2] & bitVector.v[i];
        }
        int n3 = n - 1;
        this.v[n3] = this.v[n3] & (bitVector.v[n - 1] | -1 << bitVector.length % 32);
        return this;
    }

    public BitVector or(BitVector bitVector) {
        int n;
        if (bitVector.length > this.length) {
            return bitVector.or(this);
        }
        BitVector bitVector2 = new BitVector(this.length);
        int n2 = this.v.length;
        int n3 = bitVector.v.length;
        for (n = 0; n < n3; ++n) {
            bitVector2.v[n] = this.v[n] | bitVector.v[n];
        }
        for (n = n3; n < n2; ++n) {
            bitVector2.v[n] = 0;
        }
        return bitVector2;
    }

    public BitVector selfOr(BitVector bitVector) {
        if (this.length < bitVector.length) {
            this.enlarge(bitVector.length);
        }
        int n = bitVector.v.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            this.v[n2] = this.v[n2] | bitVector.v[i];
        }
        return this;
    }

    public BitVector shift(int n) {
        BitVector bitVector = new BitVector(this.length);
        if (n == 0) {
            return bitVector;
        }
        if (n > 0) {
            int n2 = n / 32;
            int n3 = n % 32;
            int n4 = 32 - n3;
            int n5 = 0;
            while (n5 + n2 < this.v.length) {
                bitVector.v[n5] = this.v[n5 + n2] >>> n3;
                ++n5;
            }
            n5 = 0;
            while (n5 + n2 + 1 < this.v.length) {
                int n6 = n5;
                bitVector.v[n6] = bitVector.v[n6] ^ this.v[n5 + n2 + 1] << n4;
                ++n5;
            }
        } else {
            int n7;
            n = -n;
            int n8 = n / 32;
            int n9 = n % 32;
            int n10 = 32 - n9;
            for (n7 = n8; n7 < this.v.length; ++n7) {
                int n11 = n7;
                bitVector.v[n11] = bitVector.v[n11] ^ this.v[n7 - n8] << n9;
            }
            for (n7 = n8 + 1; n7 < this.v.length; ++n7) {
                int n12 = n7;
                bitVector.v[n12] = bitVector.v[n12] ^ this.v[n7 - n8 - 1] >>> n10;
            }
        }
        return bitVector;
    }

    public BitVector selfShift(int n) {
        if (n == 0) {
            return this;
        }
        if (n > this.length || n < -this.length) {
            for (int i = 0; i < this.v.length; ++i) {
                this.v[i] = 0;
            }
        } else if (n > 0) {
            int n2 = n / 32;
            int n3 = n % 32;
            int n4 = 32 - n3;
            int n5 = 0;
            while (n5 + n2 + 1 < this.v.length) {
                this.v[n5] = this.v[n5 + n2] >>> n3;
                int n6 = n5;
                this.v[n6] = this.v[n6] ^ this.v[n5 + n2 + 1] << n4;
                ++n5;
            }
            this.v[n5] = this.v[n5 + n2] >>> n3;
            ++n5;
            while (n5 < this.v.length) {
                this.v[n5] = 0;
                ++n5;
            }
        } else {
            int n7;
            n = -n;
            int n8 = n / 32;
            int n9 = n % 32;
            int n10 = 32 - n9;
            for (n7 = this.v.length - 1; n7 > n8; --n7) {
                this.v[n7] = this.v[n7 - n8] << n9;
                int n11 = n7;
                this.v[n11] = this.v[n11] ^ this.v[n7 - n8 - 1] >>> n10;
            }
            this.v[n7] = this.v[n7 - n8] << n9;
            --n7;
            while (n7 >= 0) {
                this.v[n7] = 0;
                --n7;
            }
        }
        return this;
    }

    public boolean scalarProduct(BitVector bitVector) {
        if (bitVector.v.length > this.v.length) {
            return bitVector.scalarProduct(this);
        }
        boolean bl = false;
        for (int i = 0; i < bitVector.v.length; ++i) {
            for (int j = this.v[i] & bitVector.v[i]; j != 0; j &= j - 1) {
                bl = !bl;
            }
        }
        return bl;
    }
}

