/*
 * Decompiled with CFR 0.152.
 */
package javalain.math;

import java.util.Arrays;
import javalain.math.PseudoRandomNumbers;
import util.MsgUtils;

public final class Calcul {
    public static double loiNormale(double m, double s) {
        double d;
        while ((d = PseudoRandomNumbers.random()) == 0.0) {
        }
        double rep = s * Math.sqrt(-2.0 * Math.log(d));
        while ((d = PseudoRandomNumbers.random()) == 0.0) {
        }
        return m + rep * Math.cos(Math.PI * 2 * d);
    }

    public static double[] loiHyperspherique(double[] g, double[] p) {
        double dist = Calcul.distanceEuclidienne(g, p);
        double[] x = new double[g.length];
        for (int i = 0; i < x.length; ++i) {
            x[i] = g[i] - dist + 2.0 * dist * PseudoRandomNumbers.random();
        }
        return x;
    }

    public static int randomInt(int nb) {
        return (int)(PseudoRandomNumbers.random() * (double)nb);
    }

    public static double randomDouble(double min, double max) {
        return PseudoRandomNumbers.random() * (max - min) + min;
    }

    public static double min(double d1, double d2) {
        return d1 <= d2 ? d1 : d2;
    }

    public static int min(int i1, int i2) {
        return i1 <= i2 ? i1 : i2;
    }

    public static double max(double d1, double d2) {
        return d1 >= d2 ? d1 : d2;
    }

    public static int max(int i1, int i2) {
        return i1 >= i2 ? i1 : i2;
    }

    public static double pow2(double d) {
        return d * d;
    }

    public static double pow3(double d) {
        return d * d * d;
    }

    public static double pow4(double d) {
        return Calcul.pow2(Calcul.pow2(d));
    }

    public static double pow6(double d) {
        return Calcul.pow2(Calcul.pow3(d));
    }

    public static double distanceEuclidienne(double[] x, double[] y) {
        double somme = 0.0;
        for (int i = 0; i < x.length; ++i) {
            somme += Calcul.pow2(x[i] - y[i]);
        }
        return Math.sqrt(somme);
    }

    public static double produitScalaireVecteur(double[] x, double[] y) {
        double somme = 0.0;
        for (int i = 0; i < x.length; ++i) {
            somme += x[i] * y[i];
        }
        return somme;
    }

    public static double[] produitVectorielVecteur(double[] x, double[] y) {
        double[] pv = new double[]{x[1] * y[2] - x[2] * y[1], x[2] * y[0] - x[0] * y[2], x[0] * y[1] - x[1] * y[0]};
        return pv;
    }

    public static double[] differenceVecteur(double[] x, double[] y) {
        double[] diff = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            diff[i] = x[i] - y[i];
        }
        return diff;
    }

    public static double[] sommeVecteur(double[] x, double[] y) {
        double[] somme = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            somme[i] = x[i] + y[i];
        }
        return somme;
    }

    public static double[] multReelVecteur(double d, double[] x) {
        double[] mult = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            mult[i] = d * x[i];
        }
        return mult;
    }

    public static double[] normaliseVecteur(double[] v) {
        double norme = 1.0 / Calcul.normeVecteur(v);
        double[] n = new double[v.length];
        for (int i = 0; i < v.length; ++i) {
            n[i] = v[i] * norme;
        }
        return n;
    }

    public static double normeCarreeVecteur(double[] v) {
        double somme = 0.0;
        for (int i = 0; i < v.length; ++i) {
            somme += v[i] * v[i];
        }
        return somme;
    }

    public static double normeVecteur(double[] v) {
        return Math.sqrt(Calcul.normeCarreeVecteur(v));
    }

    public static double cosinus(double[] x, double[] y) {
        int i;
        if (x.length != y.length) {
            MsgUtils.erreurAndExit(null, "Les vecteurs ne sont pas de la m\u00eame taille.", "Cosinus entre vecteurs");
        }
        double a = 0.0;
        double b = 0.0;
        for (i = 0; i < x.length; ++i) {
            a += x[i] * x[i];
        }
        for (i = 0; i < y.length; ++i) {
            b += y[i] * y[i];
        }
        double cosinus = Calcul.produitScalaireVecteur(x, y) / (Math.sqrt(a) * Math.sqrt(b));
        if (cosinus > 1.0) {
            cosinus = 1.0;
        } else if (cosinus < -1.0) {
            cosinus = -1.0;
        }
        return cosinus;
    }

    public static double arcCosinus(double[] x, double[] y) {
        return Math.acos(Calcul.cosinus(x, y));
    }

    public static double moyenne(double[] tab) {
        double somme = 0.0;
        for (int i = 0; i < tab.length; ++i) {
            somme += tab[i];
        }
        return somme / (double)tab.length;
    }

    public static double med(double[] tab) {
        double[] t = new double[tab.length];
        System.arraycopy(tab, 0, t, 0, tab.length);
        return Calcul.mediane(t);
    }

    private static double mediane(double[] tab) {
        Arrays.sort(tab);
        return (tab.length - 1) % 2 == 0 ? tab[(tab.length - 1) / 2] : (tab[(tab.length - 1) / 2] + tab[(tab.length - 1) / 2 + 1]) / 2.0;
    }

    public static double mad(double[] tab) {
        double[] t = new double[tab.length];
        System.arraycopy(tab, 0, t, 0, tab.length);
        double med = Calcul.mediane(t);
        for (int i = 0; i < t.length; ++i) {
            t[i] = Math.abs(t[i] - med);
        }
        return Calcul.mediane(t);
    }

    public static double variance(double[] tab) {
        double moy = Calcul.moyenne(tab);
        double somme = 0.0;
        for (int i = 0; i < tab.length; ++i) {
            double d = tab[i] - moy;
            somme += d * d;
        }
        return somme / (double)tab.length;
    }

    public static double ecartType(double[] tab) {
        return Math.sqrt(Calcul.variance(tab));
    }

    public static boolean paretoDominanceMax(double[] f, double[] g) {
        int i;
        for (i = 0; i < f.length && f[i] >= g[i]; ++i) {
        }
        if (i != f.length) {
            return false;
        }
        for (i = 0; i < f.length && !(f[i] > g[i]); ++i) {
        }
        return i != f.length;
    }

    public static boolean nonDomineesMax(double[] x, double[] y) {
        return !Calcul.paretoDominanceMax(x, y) && !Calcul.paretoDominanceMax(y, x);
    }
}

