/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.BestFirst;
import weka.attributeSelection.SubsetEvaluator;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.lazy.IBk;
import weka.core.AdditionalMeasureProducer;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Discretize;
import weka.filters.unsupervised.attribute.Remove;

public class DecisionTable
extends Classifier
implements OptionHandler,
WeightedInstancesHandler,
AdditionalMeasureProducer,
TechnicalInformationHandler {
    static final long serialVersionUID = 2888557078165701326L;
    protected Hashtable m_entries;
    protected double[] m_classPriorCounts;
    protected double[] m_classPriors;
    protected int[] m_decisionFeatures;
    protected Filter m_disTransform;
    protected Remove m_delTransform;
    protected IBk m_ibk;
    protected Instances m_theInstances;
    protected Instances m_dtInstances;
    protected int m_numAttributes;
    private int m_numInstances;
    protected boolean m_classIsNominal;
    protected boolean m_useIBk;
    protected boolean m_displayRules;
    private int m_CVFolds;
    private Random m_rr;
    protected double m_majority;
    protected ASSearch m_search = new BestFirst();
    protected SubsetEvaluator m_evaluator;
    protected Evaluation m_evaluation;
    public static final int EVAL_DEFAULT = 1;
    public static final int EVAL_ACCURACY = 2;
    public static final int EVAL_RMSE = 3;
    public static final int EVAL_MAE = 4;
    public static final int EVAL_AUC = 5;
    public static final Tag[] TAGS_EVALUATION = new Tag[]{new Tag(1, "Default: accuracy (discrete class); RMSE (numeric class)"), new Tag(2, "Accuracy (discrete class only"), new Tag(3, "RMSE (of the class probabilities for discrete class)"), new Tag(4, "MAE (of the class probabilities for discrete class)"), new Tag(5, "AUC (area under the ROC curve - discrete class only)")};
    protected int m_evaluationMeasure = 1;
    protected boolean m_saveMemory = true;

    public String globalInfo() {
        return "Class for building and using a simple decision table majority classifier.\n\nFor more information see: \n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Ron Kohavi");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "The Power of Decision Tables");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "8th European Conference on Machine Learning");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1995");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "174-189");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        return technicalInformation;
    }

    private void insertIntoTable(Instance instance, double[] dArray) throws Exception {
        hashKey hashKey2 = dArray != null ? new hashKey(dArray) : new hashKey(instance, instance.numAttributes(), false);
        double[] dArray2 = (double[])this.m_entries.get(hashKey2);
        if (dArray2 == null) {
            if (this.m_classIsNominal) {
                double[] dArray3 = new double[this.m_theInstances.classAttribute().numValues()];
                dArray3[(int)instance.classValue()] = instance.weight();
                this.m_entries.put(hashKey2, dArray3);
            } else {
                double[] dArray4 = new double[]{instance.classValue() * instance.weight(), instance.weight()};
                this.m_entries.put(hashKey2, dArray4);
            }
        } else if (this.m_classIsNominal) {
            int n = (int)instance.classValue();
            dArray2[n] = dArray2[n] + instance.weight();
            this.m_entries.put(hashKey2, dArray2);
        } else {
            dArray2[0] = dArray2[0] + instance.classValue() * instance.weight();
            dArray2[1] = dArray2[1] + instance.weight();
            this.m_entries.put(hashKey2, dArray2);
        }
    }

    double evaluateInstanceLeaveOneOut(Instance instance, double[] dArray) throws Exception {
        hashKey hashKey2 = new hashKey(dArray);
        if (this.m_classIsNominal) {
            double[] dArray2 = (double[])this.m_entries.get(hashKey2);
            if (dArray2 == null) {
                throw new Error("This should never happen!");
            }
            double[] dArray3 = new double[dArray2.length];
            System.arraycopy(dArray2, 0, dArray3, 0, dArray2.length);
            int n = (int)instance.classValue();
            dArray3[n] = dArray3[n] - instance.weight();
            boolean bl = false;
            for (int i = 0; i < dArray3.length; ++i) {
                if (Utils.eq(dArray3[i], 0.0)) continue;
                bl = true;
                break;
            }
            int n2 = (int)instance.classValue();
            this.m_classPriorCounts[n2] = this.m_classPriorCounts[n2] - instance.weight();
            double[] dArray4 = (double[])this.m_classPriorCounts.clone();
            Utils.normalize(dArray4);
            if (!bl) {
                dArray3 = dArray4;
            }
            int n3 = (int)instance.classValue();
            this.m_classPriorCounts[n3] = this.m_classPriorCounts[n3] + instance.weight();
            Utils.normalize(dArray3);
            if (this.m_evaluationMeasure == 5) {
                this.m_evaluation.evaluateModelOnceAndRecordPrediction(dArray3, instance);
            } else {
                this.m_evaluation.evaluateModelOnce(dArray3, instance);
            }
            return Utils.maxIndex(dArray3);
        }
        double[] dArray5 = (double[])this.m_entries.get(hashKey2);
        if (dArray5 != null) {
            double[] dArray6 = new double[dArray5.length];
            System.arraycopy(dArray5, 0, dArray6, 0, dArray5.length);
            dArray6[0] = dArray6[0] - instance.classValue() * instance.weight();
            dArray6[1] = dArray6[1] - instance.weight();
            if (Utils.eq(dArray6[1], 0.0)) {
                double[] dArray7 = new double[]{this.m_majority};
                this.m_evaluation.evaluateModelOnce(dArray7, instance);
                return this.m_majority;
            }
            double[] dArray8 = new double[]{dArray6[0] / dArray6[1]};
            this.m_evaluation.evaluateModelOnce(dArray8, instance);
            return dArray8[0];
        }
        throw new Error("This should never happen!");
    }

    double evaluateFoldCV(Instances instances, int[] nArray) throws Exception {
        Instance instance;
        int n;
        int n2 = 0;
        int n3 = instances.numInstances();
        int n4 = this.m_theInstances.classAttribute().numValues();
        double[][] dArray = new double[n3][n4];
        double[] dArray2 = new double[nArray.length];
        double d = 0.0;
        int n5 = this.m_theInstances.classIndex();
        double[] dArray3 = this.m_classIsNominal ? new double[n4] : new double[2];
        for (n = 0; n < n3; ++n) {
            instance = instances.instance(n);
            for (int i = 0; i < nArray.length; ++i) {
                dArray2[i] = nArray[i] == n5 ? Double.MAX_VALUE : (instance.isMissing(nArray[i]) ? Double.MAX_VALUE : instance.value(nArray[i]));
            }
            hashKey hashKey2 = new hashKey(dArray2);
            dArray[n] = (double[])this.m_entries.get(hashKey2);
            if (dArray[n] == null) {
                throw new Error("This should never happen!");
            }
            if (this.m_classIsNominal) {
                double[] dArray4 = dArray[n];
                int n6 = (int)instance.classValue();
                dArray4[n6] = dArray4[n6] - instance.weight();
            } else {
                double[] dArray5 = dArray[n];
                dArray5[0] = dArray5[0] - instance.classValue() * instance.weight();
                double[] dArray6 = dArray[n];
                dArray6[1] = dArray6[1] - instance.weight();
            }
            ++n2;
            int n7 = (int)instance.classValue();
            this.m_classPriorCounts[n7] = this.m_classPriorCounts[n7] - instance.weight();
        }
        double[] dArray7 = (double[])this.m_classPriorCounts.clone();
        Utils.normalize(dArray7);
        for (n = 0; n < n3; ++n) {
            instance = instances.instance(n);
            System.arraycopy(dArray[n], 0, dArray3, 0, dArray3.length);
            if (this.m_classIsNominal) {
                boolean bl = false;
                for (int i = 0; i < dArray3.length; ++i) {
                    if (Utils.eq(dArray3[i], 0.0)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    dArray3 = (double[])dArray7.clone();
                }
                Utils.normalize(dArray3);
                if (this.m_evaluationMeasure == 5) {
                    this.m_evaluation.evaluateModelOnceAndRecordPrediction(dArray3, instance);
                    continue;
                }
                this.m_evaluation.evaluateModelOnce(dArray3, instance);
                continue;
            }
            if (Utils.eq(dArray3[1], 0.0)) {
                double[] dArray8 = new double[]{this.m_majority};
                this.m_evaluation.evaluateModelOnce(dArray8, instance);
                continue;
            }
            double[] dArray9 = new double[]{dArray3[0] / dArray3[1]};
            this.m_evaluation.evaluateModelOnce(dArray9, instance);
        }
        for (n = 0; n < n3; ++n) {
            instance = instances.instance(n);
            int n8 = (int)instance.classValue();
            this.m_classPriorCounts[n8] = this.m_classPriorCounts[n8] + instance.weight();
            if (this.m_classIsNominal) {
                double[] dArray10 = dArray[n];
                int n9 = (int)instance.classValue();
                dArray10[n9] = dArray10[n9] + instance.weight();
                continue;
            }
            double[] dArray11 = dArray[n];
            dArray11[0] = dArray11[0] + instance.classValue() * instance.weight();
            double[] dArray12 = dArray[n];
            dArray12[1] = dArray12[1] + instance.weight();
        }
        return d;
    }

    protected double estimatePerformance(BitSet bitSet, int n) throws Exception {
        int n2;
        Object object;
        int n3;
        this.m_evaluation = new Evaluation(this.m_theInstances);
        int[] nArray = new int[n];
        double[] dArray = new double[n];
        int n4 = this.m_theInstances.classIndex();
        int n5 = 0;
        for (n3 = 0; n3 < this.m_numAttributes; ++n3) {
            if (!bitSet.get(n3)) continue;
            nArray[n5++] = n3;
        }
        this.m_entries = new Hashtable((int)((double)this.m_theInstances.numInstances() * 1.5));
        for (n3 = 0; n3 < this.m_numInstances; ++n3) {
            object = this.m_theInstances.instance(n3);
            for (n2 = 0; n2 < nArray.length; ++n2) {
                dArray[n2] = nArray[n2] == n4 ? Double.MAX_VALUE : (((Instance)object).isMissing(nArray[n2]) ? Double.MAX_VALUE : ((Instance)object).value(nArray[n2]));
            }
            this.insertIntoTable((Instance)object, dArray);
        }
        if (this.m_CVFolds == 1) {
            for (n3 = 0; n3 < this.m_numInstances; ++n3) {
                object = this.m_theInstances.instance(n3);
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    dArray[n2] = nArray[n2] == n4 ? Double.MAX_VALUE : (((Instance)object).isMissing(nArray[n2]) ? Double.MAX_VALUE : ((Instance)object).value(nArray[n2]));
                }
                this.evaluateInstanceLeaveOneOut((Instance)object, dArray);
            }
        } else {
            this.m_theInstances.randomize(this.m_rr);
            this.m_theInstances.stratify(this.m_CVFolds);
            for (n3 = 0; n3 < this.m_CVFolds; ++n3) {
                object = this.m_theInstances.testCV(this.m_CVFolds, n3);
                this.evaluateFoldCV((Instances)object, nArray);
            }
        }
        switch (this.m_evaluationMeasure) {
            case 1: {
                if (this.m_classIsNominal) {
                    return this.m_evaluation.pctCorrect();
                }
                return -this.m_evaluation.rootMeanSquaredError();
            }
            case 2: {
                return this.m_evaluation.pctCorrect();
            }
            case 3: {
                return -this.m_evaluation.rootMeanSquaredError();
            }
            case 4: {
                return -this.m_evaluation.meanAbsoluteError();
            }
            case 5: {
                object = this.m_evaluation.getClassPriors();
                Utils.normalize((double[])object);
                double d = 0.0;
                for (n3 = 0; n3 < this.m_theInstances.classAttribute().numValues(); ++n3) {
                    double d2 = this.m_evaluation.areaUnderROC(n3);
                    if (d2 != Instance.missingValue()) {
                        d += object[n3] * d2;
                        continue;
                    }
                    System.err.println("Undefined AUC!!");
                }
                return d;
            }
        }
        return 0.0;
    }

    private String printSub(BitSet bitSet) {
        String string = "";
        for (int i = 0; i < this.m_numAttributes; ++i) {
            if (!bitSet.get(i)) continue;
            string = string + " " + (i + 1);
        }
        return string;
    }

    protected void resetOptions() {
        this.m_entries = null;
        this.m_decisionFeatures = null;
        this.m_useIBk = false;
        this.m_CVFolds = 1;
        this.m_displayRules = false;
        this.m_evaluationMeasure = 1;
    }

    public DecisionTable() {
        this.resetOptions();
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(7);
        vector.addElement(new Option("\tFull class name of search method, followed\n\tby its options.\n\teg: \"weka.attributeSelection.BestFirst -D 1\"\n\t(default weka.attributeSelection.BestFirst)", "S", 1, "-S <search method specification>"));
        vector.addElement(new Option("\tUse cross validation to evaluate features.\n\tUse number of folds = 1 for leave one out CV.\n\t(Default = leave one out CV)", "X", 1, "-X <number of folds>"));
        vector.addElement(new Option("\tPerformance evaluation measure to use for selecting attributes.\n\t(Default = accuracy for discrete class and rmse for numeric class)", "E", 1, "-E <acc | rmse | mae | auc>"));
        vector.addElement(new Option("\tUse nearest neighbour instead of global table majority.", "I", 0, "-I"));
        vector.addElement(new Option("\tDisplay decision table rules.\n", "R", 0, "-R"));
        vector.addElement(new Option("", "", 0, "\nOptions specific to search method " + this.m_search.getClass().getName() + ":"));
        Enumeration enumeration = ((OptionHandler)((Object)this.m_search)).listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public String crossValTipText() {
        return "Sets the number of folds for cross validation (1 = leave one out).";
    }

    public void setCrossVal(int n) {
        this.m_CVFolds = n;
    }

    public int getCrossVal() {
        return this.m_CVFolds;
    }

    public String useIBkTipText() {
        return "Sets whether IBk should be used instead of the majority class.";
    }

    public void setUseIBk(boolean bl) {
        this.m_useIBk = bl;
    }

    public boolean getUseIBk() {
        return this.m_useIBk;
    }

    public String displayRulesTipText() {
        return "Sets whether rules are to be printed.";
    }

    public void setDisplayRules(boolean bl) {
        this.m_displayRules = bl;
    }

    public boolean getDisplayRules() {
        return this.m_displayRules;
    }

    public String searchTipText() {
        return "The search method used to find good attribute combinations for the decision table.";
    }

    public void setSearch(ASSearch aSSearch) {
        this.m_search = aSSearch;
    }

    public ASSearch getSearch() {
        return this.m_search;
    }

    public String evaluationMeasureTipText() {
        return "The measure used to evaluate the performance of attribute combinations used in the decision table.";
    }

    public SelectedTag getEvaluationMeasure() {
        return new SelectedTag(this.m_evaluationMeasure, TAGS_EVALUATION);
    }

    public void setEvaluationMeasure(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_EVALUATION) {
            this.m_evaluationMeasure = selectedTag.getSelectedTag().getID();
        }
    }

    public void setOptions(String[] stringArray) throws Exception {
        String[] stringArray2;
        String string;
        this.resetOptions();
        String string2 = Utils.getOption('X', stringArray);
        if (string2.length() != 0) {
            this.m_CVFolds = Integer.parseInt(string2);
        }
        this.m_useIBk = Utils.getFlag('I', stringArray);
        this.m_displayRules = Utils.getFlag('R', stringArray);
        string2 = Utils.getOption('E', stringArray);
        if (string2.length() != 0) {
            if (string2.equals("acc")) {
                this.setEvaluationMeasure(new SelectedTag(2, TAGS_EVALUATION));
            } else if (string2.equals("rmse")) {
                this.setEvaluationMeasure(new SelectedTag(3, TAGS_EVALUATION));
            } else if (string2.equals("mae")) {
                this.setEvaluationMeasure(new SelectedTag(4, TAGS_EVALUATION));
            } else if (string2.equals("auc")) {
                this.setEvaluationMeasure(new SelectedTag(5, TAGS_EVALUATION));
            } else {
                throw new IllegalArgumentException("Invalid evaluation measure");
            }
        }
        if ((string = Utils.getOption('S', stringArray)).length() == 0) {
            string = BestFirst.class.getName();
        }
        if ((stringArray2 = Utils.splitOptions(string)).length == 0) {
            throw new IllegalArgumentException("Invalid search specification string");
        }
        String string3 = stringArray2[0];
        stringArray2[0] = "";
        this.setSearch(ASSearch.forName(string3, stringArray2));
    }

    public String[] getOptions() {
        String[] stringArray = new String[9];
        int n = 0;
        stringArray[n++] = "-X";
        stringArray[n++] = "" + this.m_CVFolds;
        if (this.m_evaluationMeasure != 1) {
            stringArray[n++] = "-E";
            switch (this.m_evaluationMeasure) {
                case 2: {
                    stringArray[n++] = "acc";
                    break;
                }
                case 3: {
                    stringArray[n++] = "rmse";
                    break;
                }
                case 4: {
                    stringArray[n++] = "mae";
                    break;
                }
                case 5: {
                    stringArray[n++] = "auc";
                }
            }
        }
        if (this.m_useIBk) {
            stringArray[n++] = "-I";
        }
        if (this.m_displayRules) {
            stringArray[n++] = "-R";
        }
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.getSearchSpec();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    protected String getSearchSpec() {
        ASSearch aSSearch = this.getSearch();
        if (aSSearch instanceof OptionHandler) {
            return aSSearch.getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)aSSearch)).getOptions());
        }
        return aSSearch.getClass().getName();
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        if (this.m_evaluationMeasure != 2 && this.m_evaluationMeasure != 5) {
            capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
            capabilities.enable(Capabilities.Capability.DATE_CLASS);
        }
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    protected void setUpEvaluator() {
        this.m_evaluator = new SubsetEvaluator(){

            public void buildEvaluator(Instances instances) throws Exception {
            }

            public double evaluateSubset(BitSet bitSet) throws Exception {
                int n = 0;
                for (int i = 0; i < DecisionTable.this.m_numAttributes; ++i) {
                    if (!bitSet.get(i)) continue;
                    ++n;
                }
                return DecisionTable.this.estimatePerformance(bitSet, n);
            }
        };
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        this.m_theInstances = new Instances(instances);
        this.m_theInstances.deleteWithMissingClass();
        this.m_rr = new Random(1L);
        if (this.m_theInstances.classAttribute().isNominal()) {
            this.m_classPriorCounts = new double[instances.classAttribute().numValues()];
            Arrays.fill(this.m_classPriorCounts, 1.0);
            for (int i = 0; i < instances.numInstances(); ++i) {
                Instance instance = instances.instance(i);
                int n = (int)instance.classValue();
                this.m_classPriorCounts[n] = this.m_classPriorCounts[n] + instance.weight();
            }
            this.m_classPriors = (double[])this.m_classPriorCounts.clone();
            Utils.normalize(this.m_classPriors);
        }
        this.setUpEvaluator();
        if (this.m_theInstances.classAttribute().isNumeric()) {
            this.m_disTransform = new Discretize();
            this.m_classIsNominal = false;
            ((Discretize)this.m_disTransform).setBins(10);
            ((Discretize)this.m_disTransform).setInvertSelection(true);
            String string = "";
            string = string + (this.m_theInstances.classIndex() + 1);
            ((Discretize)this.m_disTransform).setAttributeIndices(string);
        } else {
            this.m_disTransform = new weka.filters.supervised.attribute.Discretize();
            ((weka.filters.supervised.attribute.Discretize)this.m_disTransform).setUseBetterEncoding(true);
            this.m_classIsNominal = true;
        }
        this.m_disTransform.setInputFormat(this.m_theInstances);
        this.m_theInstances = Filter.useFilter(this.m_theInstances, this.m_disTransform);
        this.m_numAttributes = this.m_theInstances.numAttributes();
        this.m_numInstances = this.m_theInstances.numInstances();
        this.m_majority = this.m_theInstances.meanOrMode(this.m_theInstances.classAttribute());
        int[] nArray = this.m_search.search(this.m_evaluator, this.m_theInstances);
        this.m_decisionFeatures = new int[nArray.length + 1];
        System.arraycopy(nArray, 0, this.m_decisionFeatures, 0, nArray.length);
        this.m_decisionFeatures[this.m_decisionFeatures.length - 1] = this.m_theInstances.classIndex();
        this.m_delTransform = new Remove();
        this.m_delTransform.setInvertSelection(true);
        this.m_delTransform.setAttributeIndicesArray(this.m_decisionFeatures);
        this.m_delTransform.setInputFormat(this.m_theInstances);
        this.m_dtInstances = Filter.useFilter(this.m_theInstances, this.m_delTransform);
        this.m_numAttributes = this.m_dtInstances.numAttributes();
        this.m_entries = new Hashtable((int)((double)this.m_dtInstances.numInstances() * 1.5));
        for (int i = 0; i < this.m_numInstances; ++i) {
            Instance instance = this.m_dtInstances.instance(i);
            this.insertIntoTable(instance, null);
        }
        if (this.m_useIBk) {
            this.m_ibk = new IBk();
            this.m_ibk.buildClassifier(this.m_theInstances);
        }
        if (this.m_saveMemory) {
            this.m_theInstances = new Instances(this.m_theInstances, 0);
            this.m_dtInstances = new Instances(this.m_dtInstances, 0);
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        this.m_disTransform.input(instance);
        this.m_disTransform.batchFinished();
        instance = this.m_disTransform.output();
        this.m_delTransform.input(instance);
        this.m_delTransform.batchFinished();
        instance = this.m_delTransform.output();
        hashKey hashKey2 = new hashKey(instance, instance.numAttributes(), false);
        double[] dArray = (double[])this.m_entries.get(hashKey2);
        if (dArray == null) {
            dArray = this.m_useIBk ? this.m_ibk.distributionForInstance(instance) : (!this.m_classIsNominal ? new double[]{this.m_majority} : (double[])this.m_classPriors.clone());
        } else if (!this.m_classIsNominal) {
            double[] dArray2 = new double[]{dArray[0] / dArray[1]};
            dArray = dArray2;
        } else {
            double[] dArray3 = new double[dArray.length];
            System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
            Utils.normalize(dArray3);
            dArray = dArray3;
        }
        return dArray;
    }

    public String printFeatures() {
        String string = "";
        for (int i = 0; i < this.m_decisionFeatures.length; ++i) {
            string = i == 0 ? "" + (this.m_decisionFeatures[i] + 1) : string + "," + (this.m_decisionFeatures[i] + 1);
        }
        return string;
    }

    public double measureNumRules() {
        return this.m_entries.size();
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>(1);
        vector.addElement("measureNumRules");
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (string.compareToIgnoreCase("measureNumRules") == 0) {
            return this.measureNumRules();
        }
        throw new IllegalArgumentException(string + " not supported (DecisionTable)");
    }

    public String toString() {
        if (this.m_entries == null) {
            return "Decision Table: No model built yet.";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Decision Table:\n\nNumber of training instances: " + this.m_numInstances + "\nNumber of Rules : " + this.m_entries.size() + "\n");
        if (this.m_useIBk) {
            stringBuffer.append("Non matches covered by IB1.\n");
        } else {
            stringBuffer.append("Non matches covered by Majority class.\n");
        }
        stringBuffer.append(this.m_search.toString());
        stringBuffer.append("Evaluation (for feature selection): CV ");
        if (this.m_CVFolds > 1) {
            stringBuffer.append("(" + this.m_CVFolds + " fold) ");
        } else {
            stringBuffer.append("(leave one out) ");
        }
        stringBuffer.append("\nFeature set: " + this.printFeatures());
        if (this.m_displayRules) {
            int n;
            int n2 = 0;
            for (int i = 0; i < this.m_dtInstances.numAttributes(); ++i) {
                if (this.m_dtInstances.attribute(i).name().length() > n2) {
                    n2 = this.m_dtInstances.attribute(i).name().length();
                }
                if (!this.m_classIsNominal && i == this.m_dtInstances.classIndex()) continue;
                Enumeration enumeration = this.m_dtInstances.attribute(i).enumerateValues();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (string.length() <= n2) continue;
                    n2 = string.length();
                }
            }
            stringBuffer.append("\n\nRules:\n");
            StringBuffer stringBuffer2 = new StringBuffer();
            for (n = 0; n < this.m_dtInstances.numAttributes(); ++n) {
                if (this.m_dtInstances.classIndex() == n) continue;
                int n3 = n2 - this.m_dtInstances.attribute(n).name().length();
                stringBuffer2.append(this.m_dtInstances.attribute(n).name());
                for (int i = 0; i < n3 + 1; ++i) {
                    stringBuffer2.append(" ");
                }
            }
            stringBuffer2.append(this.m_dtInstances.attribute(this.m_dtInstances.classIndex()).name() + "  ");
            for (n = 0; n < stringBuffer2.length() + 10; ++n) {
                stringBuffer.append("=");
            }
            stringBuffer.append("\n");
            stringBuffer.append(stringBuffer2);
            stringBuffer.append("\n");
            for (n = 0; n < stringBuffer2.length() + 10; ++n) {
                stringBuffer.append("=");
            }
            stringBuffer.append("\n");
            Enumeration enumeration = this.m_entries.keys();
            while (enumeration.hasMoreElements()) {
                hashKey hashKey2 = (hashKey)enumeration.nextElement();
                stringBuffer.append(hashKey2.toString(this.m_dtInstances, n2));
                double[] dArray = (double[])this.m_entries.get(hashKey2);
                if (this.m_classIsNominal) {
                    int n4 = Utils.maxIndex(dArray);
                    try {
                        stringBuffer.append(this.m_dtInstances.classAttribute().value(n4) + "\n");
                    }
                    catch (Exception exception) {
                        System.out.println(exception.getMessage());
                    }
                    continue;
                }
                stringBuffer.append(dArray[0] / dArray[1] + "\n");
            }
            for (int i = 0; i < stringBuffer2.length() + 10; ++i) {
                stringBuffer.append("=");
            }
            stringBuffer.append("\n");
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        DecisionTable.runClassifier(new DecisionTable(), stringArray);
    }

    public static class hashKey
    implements Serializable {
        static final long serialVersionUID = 5674163500154964602L;
        private double[] attributes;
        private boolean[] missing;
        private int key;

        public hashKey(Instance instance, int n, boolean bl) throws Exception {
            int n2 = instance.classIndex();
            this.key = -999;
            this.attributes = new double[n];
            this.missing = new boolean[n];
            for (int i = 0; i < n; ++i) {
                if (i == n2 && !bl) {
                    this.missing[i] = true;
                    continue;
                }
                this.missing[i] = instance.isMissing(i);
                if (this.missing[i]) continue;
                this.attributes[i] = instance.value(i);
            }
        }

        public String toString(Instances instances, int n) {
            int n2 = instances.classIndex();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.attributes.length; ++i) {
                if (i == n2) continue;
                if (this.missing[i]) {
                    stringBuffer.append("?");
                    for (int j = 0; j < n; ++j) {
                        stringBuffer.append(" ");
                    }
                    continue;
                }
                String string = instances.attribute(i).value((int)this.attributes[i]);
                StringBuffer stringBuffer2 = new StringBuffer(string);
                for (int j = 0; j < n - string.length() + 1; ++j) {
                    stringBuffer2.append(" ");
                }
                stringBuffer.append(stringBuffer2);
            }
            return stringBuffer.toString();
        }

        public hashKey(double[] dArray) {
            int n = dArray.length;
            this.key = -999;
            this.attributes = new double[n];
            this.missing = new boolean[n];
            for (int i = 0; i < n; ++i) {
                if (dArray[i] == Double.MAX_VALUE) {
                    this.missing[i] = true;
                    continue;
                }
                this.missing[i] = false;
                this.attributes[i] = dArray[i];
            }
        }

        public int hashCode() {
            int n = 0;
            if (this.key != -999) {
                return this.key;
            }
            for (int i = 0; i < this.attributes.length; ++i) {
                if (this.missing[i]) {
                    n += i * 13;
                    continue;
                }
                n = (int)((double)n + (double)(i * 5) * (this.attributes[i] + 1.0));
            }
            if (this.key == -999) {
                this.key = n;
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object == null || !object.getClass().equals(this.getClass())) {
                return false;
            }
            boolean bl = true;
            if (object instanceof hashKey) {
                hashKey hashKey2 = (hashKey)object;
                for (int i = 0; i < this.attributes.length; ++i) {
                    boolean bl2 = hashKey2.missing[i];
                    if (this.missing[i] || bl2) {
                        if ((!this.missing[i] || bl2) && (this.missing[i] || !bl2)) continue;
                        bl = false;
                    } else {
                        if (this.attributes[i] == hashKey2.attributes[i]) continue;
                        bl = false;
                    }
                    break;
                }
            } else {
                return false;
            }
            return bl;
        }

        public void print_hash_code() {
            System.out.println("Hash val: " + this.hashCode());
        }
    }
}

