/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.parser;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryException;
import com.hp.hpl.jena.rdql.QueryPrintUtils;
import com.hp.hpl.jena.rdql.parser.Expr;
import com.hp.hpl.jena.rdql.parser.ExprBoolean;
import com.hp.hpl.jena.rdql.parser.ExprNode;
import com.hp.hpl.jena.rdql.parser.NodeValue;
import com.hp.hpl.jena.rdql.parser.NodeValueSettable;
import com.hp.hpl.jena.rdql.parser.RDQLParser;
import com.hp.hpl.jena.rdql.parser.WorkingVar;
import java.io.PrintWriter;

public class Q_StringLangEqual
extends ExprNode
implements Expr,
ExprBoolean {
    Expr left;
    Expr right;
    protected static String printName = "lang=";
    protected static String opSymbol = "langeq";

    Q_StringLangEqual(int id) {
        super(id);
    }

    Q_StringLangEqual(RDQLParser p, int id) {
        super(p, id);
    }

    protected boolean rawEval(NodeValue x, NodeValue y) {
        if (x.isNode() && x.getNode().isLiteral() && y.isNode() && y.getNode().isLiteral()) {
            Node xNode = x.getNode();
            Node yNode = y.getNode();
            String nodeLang = xNode.getLiteralLanguage().toUpperCase();
            String queryLang = yNode.getLiteralLexicalForm().toUpperCase();
            if (queryLang.indexOf("-") >= 0) {
                return nodeLang.equals(queryLang);
            }
            int pos = nodeLang.indexOf("-");
            if (pos > 0) {
                nodeLang = nodeLang.substring(0, pos);
            }
            return nodeLang.equals(queryLang);
        }
        return false;
    }

    public NodeValue eval(Query q, IndexValues env) {
        NodeValue x = this.left.eval(q, env);
        NodeValue y = this.right.eval(q, env);
        boolean b = this.rawEval(x, y);
        NodeValueSettable result = x instanceof NodeValueSettable ? (NodeValueSettable)x : (y instanceof NodeValueSettable ? (NodeValueSettable)y : new WorkingVar());
        result.setBoolean(b);
        return result;
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        if (n != 2) {
            throw new QueryException("Q_StringLangEqual: Wrong number of children: " + n);
        }
        this.left = (Expr)((Object)this.jjtGetChild(0));
        this.right = (Expr)((Object)this.jjtGetChild(1));
    }

    public boolean isApply() {
        return true;
    }

    public String getFun() {
        return this.getClass().getName();
    }

    public int argCount() {
        return 2;
    }

    public Expression getArg(int i) {
        if (i == 0 && this.left instanceof Expression) {
            return (Expression)((Object)this.left);
        }
        if (i == 1 && this.right instanceof Expression) {
            return (Expression)((Object)this.right);
        }
        return null;
    }

    public String asInfixString() {
        return QueryPrintUtils.asInfixString2(this.left, this.right, printName, opSymbol);
    }

    public String asPrefixString() {
        return QueryPrintUtils.asPrefixString(this.left, this.right, printName, opSymbol);
    }

    public void print(PrintWriter pw, int level) {
        QueryPrintUtils.print(pw, this.left, this.right, printName, opSymbol, level);
    }

    public String toString() {
        return this.asInfixString();
    }
}

