/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.pmml.producer;

import weka.core.Attribute;
import weka.core.Instances;
import weka.core.Version;
import weka.core.pmml.jaxbbindings.Application;
import weka.core.pmml.jaxbbindings.DataDictionary;
import weka.core.pmml.jaxbbindings.DataField;
import weka.core.pmml.jaxbbindings.Header;
import weka.core.pmml.jaxbbindings.OPTYPE;
import weka.core.pmml.jaxbbindings.PMML;
import weka.core.pmml.jaxbbindings.Value;

public abstract class AbstractPMMLProducerHelper {
    public static final String PMML_VERSION = "4.1";

    public static PMML initPMML() {
        PMML pmml = new PMML();
        pmml.setVersion(PMML_VERSION);
        Header header = new Header();
        header.setCopyright("WEKA");
        header.setApplication(new Application("WEKA", Version.VERSION));
        pmml.setHeader(header);
        return pmml;
    }

    public static void addDataDictionary(Instances trainHeader, PMML pmml) {
        DataDictionary dictionary = new DataDictionary();
        for (int i = 0; i < trainHeader.numAttributes(); ++i) {
            String name = trainHeader.attribute(i).name();
            OPTYPE optype = AbstractPMMLProducerHelper.getOPTYPE(trainHeader.attribute(i).type());
            DataField field = new DataField(name, optype);
            if (trainHeader.attribute(i).isNominal()) {
                for (int j = 0; j < trainHeader.attribute(i).numValues(); ++j) {
                    Value val = new Value(trainHeader.attribute(i).value(j));
                    field.addValue(val);
                }
            }
            dictionary.addDataField(field);
        }
        pmml.setDataDictionary(dictionary);
    }

    public static OPTYPE getOPTYPE(int wekaType) {
        switch (wekaType) {
            case 0: 
            case 3: {
                return OPTYPE.CONTINUOUS;
            }
        }
        return OPTYPE.CATEGORICAL;
    }

    public static String[] getNameAndValueFromUnsupervisedNominalToBinaryDerivedAttribute(Instances train, Attribute derived) {
        String[] nameAndVal = new String[2];
        boolean success = false;
        String derivedName = derived.name();
        int currentEqualsIndex = derivedName.indexOf(61);
        String leftSide = derivedName.substring(0, currentEqualsIndex);
        String rightSide = derivedName.substring(currentEqualsIndex + 1, derivedName.length());
        while (!success) {
            if (train.attribute(leftSide) != null) {
                nameAndVal[0] = leftSide;
                nameAndVal[1] = rightSide;
                success = true;
                continue;
            }
            leftSide = leftSide + "=" + rightSide.substring(0, rightSide.indexOf(61));
            rightSide = rightSide.substring(rightSide.indexOf(61) + 1, rightSide.length());
        }
        return nameAndVal;
    }
}

