#!/usr/bin/env Rscript
#' @title Generate Example Dataset for SVG Package
#' @description
#' This script generates the built-in example dataset (example_svg_data).
#' Run this script to regenerate the data if needed.
#' 
#' Usage: Rscript generate_example_data.R

# Source the simulation function
source("../../R/data_simulation.R")

cat("Generating example spatial transcriptomics data...\n")

# Generate dataset with reproducible seed
set.seed(42)

example_svg_data <- simulate_spatial_data(
    n_spots = 500,       # Reasonable size for examples
    n_genes = 200,       # 200 genes total
    n_svg = 50,          # 50 are true SVGs (25%)
    grid_type = "hexagonal",  # Visium-like layout
    pattern_types = c("gradient", "hotspot", "periodic", "cluster"),
    mean_counts = 50,    # Realistic count level
    dispersion = 5       # Moderate overdispersion
)

cat("Dataset dimensions:\n")
cat("  - Spots:", nrow(example_svg_data$spatial_coords), "\n")
cat("  - Genes:", nrow(example_svg_data$counts), "\n")
cat("  - True SVGs:", sum(example_svg_data$gene_info$is_svg), "\n")
cat("\n")

cat("Pattern distribution:\n")
print(table(example_svg_data$gene_info$pattern_type))
cat("\n")

# Save as .rda file
save(example_svg_data, file = "../../data/example_svg_data.rda", compress = "xz")

cat("Saved to data/example_svg_data.rda\n")
cat("Done!\n")
