/*
 * Decompiled with CFR 0.152.
 */
package org.jamesframework.core.search.stopcriteria;

import org.jamesframework.core.search.Search;
import org.jamesframework.core.search.stopcriteria.StopCriterion;

public class MaxStepsWithoutImprovement
implements StopCriterion {
    private final long maxStepsWithoutImprovement;

    public MaxStepsWithoutImprovement(long maxStepsWithoutImprovement) {
        if (maxStepsWithoutImprovement <= 0L) {
            throw new IllegalArgumentException("Error while creating stop criterion: maximum number of steps without improvement should be > 0.");
        }
        this.maxStepsWithoutImprovement = maxStepsWithoutImprovement;
    }

    @Override
    public boolean searchShouldStop(Search<?> search) {
        return search.getStepsWithoutImprovement() >= this.maxStepsWithoutImprovement;
    }

    public String toString() {
        return "{max steps without improvement: " + this.maxStepsWithoutImprovement + "}";
    }
}

