/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simprocs;

import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.Simulator;
import umontreal.iro.lecuyer.simprocs.DSOLProcessSimulator;
import umontreal.iro.lecuyer.simprocs.SimProcess;
import umontreal.iro.lecuyer.simprocs.ThreadProcessSimulator;

public abstract class ProcessSimulator
extends Simulator {
    protected SimProcess currentProcess;

    public SimProcess currentProcess() {
        return this.currentProcess;
    }

    protected void setCurrentProcess(SimProcess currentProcess) {
        this.currentProcess = currentProcess;
    }

    public abstract Event createControlEvent(SimProcess var1);

    public abstract void delay(SimProcess var1, double var2);

    public abstract void suspend(SimProcess var1);

    public abstract void kill(SimProcess var1);

    public abstract void killAll();

    public static void initDefault() {
        if (defaultSimulator instanceof ProcessSimulator) {
            defaultSimulator.init();
            return;
        }
        if (defaultSimulator instanceof Simulator) {
            Simulator temp = defaultSimulator;
            defaultSimulator = ProcessSimulator.newInstance();
            defaultSimulator.init(temp.getEventList());
            return;
        }
        defaultSimulator = ProcessSimulator.newInstance();
        defaultSimulator.init();
    }

    public static ProcessSimulator newInstance() {
        if (System.getProperty("ssj.processSimulator") != null) {
            ProcessSimulator myProcessSimulator = null;
            try {
                myProcessSimulator = (ProcessSimulator)Class.forName(System.getProperty("ssj.processSimulator")).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                cnfe.printStackTrace();
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace();
            }
            catch (InstantiationException ie) {
                ie.printStackTrace();
            }
            return myProcessSimulator;
        }
        if (System.getProperty("ssj.withThread") != null) {
            return new ThreadProcessSimulator();
        }
        if (System.getProperty("ssj.withDSOL") != null) {
            return new DSOLProcessSimulator();
        }
        return new ThreadProcessSimulator();
    }

    static {
        if (System.getProperty("ssj.processes") != null) {
            ProcessSimulator.initDefault();
        }
    }
}

