## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(lightsf)
library(ggplot2)
library(dplyr)

## ----afcon-poly-plot, fig.width=6, fig.height=4.5, out.width="90%", message=FALSE, warning=FALSE----

# Basic exploration of the dataset
names(afcon_poly)
class(afcon_poly)
length(afcon_poly)
str(afcon_poly)

# Ensure the dataset is a data frame
afcon_df <- as.data.frame(afcon_poly)

# Create a scatter plot of coordinates colored by total conflicts
ggplot(afcon_df, aes(x = x, y = y)) +
  geom_point(aes(color = totcon, size = totcon), alpha = 0.8) +
  scale_color_gradient(low = "lightyellow", high = "darkred") +
  labs(
    title = "Spatial Patterns of Conflict in Africa (1966–1978)",
    x = "Longitude",
    y = "Latitude",
    color = "Total Conflicts",
    size = "Conflict Intensity"
  ) +
  theme_minimal() +
  theme(
    plot.title = element_text(hjust = 0.5),
    legend.position = "right"
  )

