/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify;

import cc.mallet.classify.ClassifierTrainer;
import cc.mallet.classify.MostFrequentClassifier;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.Alphabet;
import cc.mallet.types.AlphabetCarrying;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.Label;

public class MostFrequentClassAssignmentTrainer
extends ClassifierTrainer<MostFrequentClassifier>
implements AlphabetCarrying {
    MostFrequentClassifier classifier = null;
    Pipe instancePipe;
    Alphabet dataAlphabet;
    Alphabet targetAlphabet;

    @Override
    public MostFrequentClassifier getClassifier() {
        return this.classifier;
    }

    @Override
    public MostFrequentClassifier train(InstanceList trainingSet) {
        if (trainingSet != null) {
            if (this.instancePipe == null) {
                this.instancePipe = trainingSet.getPipe();
            } else if (this.instancePipe != trainingSet.getPipe()) {
                throw new IllegalArgumentException("Training set pipe does not match that of NaiveBayesTrainer.");
            }
            this.dataAlphabet = this.instancePipe.getDataAlphabet();
            this.targetAlphabet = this.instancePipe.getTargetAlphabet();
        }
        this.classifier = new MostFrequentClassifier(this.instancePipe);
        for (Instance instance : trainingSet) {
            if (this.dataAlphabet == null) {
                this.dataAlphabet = instance.getDataAlphabet();
                this.targetAlphabet = instance.getTargetAlphabet();
            } else if (!Alphabet.alphabetsMatch(instance, this)) {
                throw new IllegalArgumentException("Training set alphabets do not match those of NaiveBayesTrainer.");
            }
            Label label = (Label)instance.getTarget();
            this.classifier.addTargetLabel(label);
        }
        return this.classifier;
    }

    public boolean alphabetsMatch(AlphabetCarrying object) {
        return Alphabet.alphabetsMatch(this, object);
    }

    @Override
    public Alphabet getAlphabet() {
        return this.dataAlphabet;
    }

    @Override
    public Alphabet[] getAlphabets() {
        return new Alphabet[]{this.dataAlphabet, this.targetAlphabet};
    }
}

