/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.cml;

import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CMLErrorHandler
implements ErrorHandler {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(CMLErrorHandler.class);
    public final boolean reportErrors = true;
    public final boolean abortOnErrors = false;

    public CMLErrorHandler() {
        logger.info((Object)"instantiated");
    }

    private void print(String level, SAXParseException exception) {
        if (level.equals("warning")) {
            logger.warn((Object)("** " + level + ": " + exception.getMessage()));
            logger.warn((Object)("   URI  = " + exception.getSystemId()));
            logger.warn((Object)("   line = " + exception.getLineNumber()));
        } else {
            logger.error((Object)("** " + level + ": " + exception.getMessage()));
            logger.error((Object)("   URI  = " + exception.getSystemId()));
            logger.error((Object)("   line = " + exception.getLineNumber()));
        }
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.print("error", exception);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.print("fatal", exception);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.print("warning", exception);
    }
}

