/*
 * Decompiled with CFR 0.152.
 */
package org.flsgen.solver;

import java.io.IOException;
import java.util.Random;
import java.util.stream.IntStream;
import org.flsgen.exception.FlsgenException;
import org.flsgen.grid.regular.square.RegularSquareGrid;

public class Terrain {
    protected RegularSquareGrid grid;
    protected double[] dem;

    public Terrain(RegularSquareGrid grid) {
        this.grid = grid;
    }

    public void loadFromData(double[] data) throws IOException, FlsgenException {
        if (this.grid.getNbRows() * this.grid.getNbCols() != data.length) {
            throw new FlsgenException("Input terrain raster must have the same dimensions as the landscape to generate");
        }
        this.dem = data;
    }

    public void generateDiamondSquare(double roughnessFactor) {
        int h = Math.max(this.grid.getNbRows(), this.grid.getNbCols());
        double pos = Math.ceil(Math.log(h) / Math.log(2.0));
        h = (int)(Math.pow(2.0, pos) + 1.0);
        double[][] terrain = new double[h][h];
        terrain[0][0] = Terrain.randomDouble(-h, h);
        terrain[0][h - 1] = Terrain.randomDouble(-h, h);
        terrain[h - 1][0] = Terrain.randomDouble(-h, h);
        terrain[h - 1][h - 1] = Terrain.randomDouble(-h, h);
        double r = (double)h * Math.pow(2.0, -2.0 * roughnessFactor);
        int i = h - 1;
        while (i > 1) {
            int id;
            for (int x = id = i / 2; x < h; x += i) {
                for (int y = id; y < h; y += i) {
                    double mean = (terrain[x - id][y - id] + terrain[x - id][y + id] + terrain[x + id][y + id] + terrain[x + id][y - id]) / 4.0;
                    terrain[x][y] = mean + Terrain.randomDouble(-r, r);
                }
            }
            int offset = 0;
            for (int x = 0; x < h; x += id) {
                offset = offset == 0 ? id : 0;
                for (int y = offset; y < h; y += i) {
                    double sum = 0.0;
                    int n = 0;
                    if (x >= id) {
                        sum += terrain[x - id][y];
                        ++n;
                    }
                    if (x + id < h) {
                        sum += terrain[x + id][y];
                        ++n;
                    }
                    if (y >= id) {
                        sum += terrain[x][y - id];
                        ++n;
                    }
                    if (y + id < h) {
                        sum += terrain[x][y + id];
                        ++n;
                    }
                    terrain[x][y] = sum / (double)n + Terrain.randomDouble(-r, r);
                }
            }
            i = id;
            r *= Math.pow(2.0, -2.0 * roughnessFactor);
        }
        this.dem = IntStream.range(0, this.grid.getNbCells()).mapToDouble(v -> {
            int[] c = this.grid.getCoordinatesFromIndex(v);
            return terrain[c[0]][c[1]];
        }).toArray();
    }

    public static double randomDouble(double min, double max) {
        return new Random().nextDouble() * (max - min) + min;
    }

    public double[] getData() {
        return this.dem;
    }

    public RegularSquareGrid getGrid() {
        return this.grid;
    }
}

