/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.org.dhatim.fastexcel;

import java.io.IOException;
import java.util.Objects;
import standalone_spreadsheet.org.dhatim.fastexcel.Alignment;
import standalone_spreadsheet.org.dhatim.fastexcel.Border;
import standalone_spreadsheet.org.dhatim.fastexcel.Fill;
import standalone_spreadsheet.org.dhatim.fastexcel.Font;
import standalone_spreadsheet.org.dhatim.fastexcel.Protection;
import standalone_spreadsheet.org.dhatim.fastexcel.Writer;

public class DifferentialFormat {
    private final String valueFormatting;
    private final Font font;
    private final Fill fill;
    private final Border border;
    private final Alignment alignment;
    private final Protection protection;
    private int numFmtId;

    DifferentialFormat(String valueFormatting, Font font, Fill fill, Border border, Alignment alignment, Protection protection) {
        this.valueFormatting = valueFormatting;
        this.font = font;
        this.fill = fill;
        this.border = border;
        this.alignment = alignment;
        this.protection = protection;
    }

    public String getValueFormatting() {
        return this.valueFormatting;
    }

    public void setNumFmtId(int numFmtId) {
        this.numFmtId = numFmtId;
    }

    public int hashCode() {
        return Objects.hash(this.numFmtId, this.font, this.fill, this.border, this.alignment, this.protection);
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj != null && obj.getClass() == this.getClass()) {
            DifferentialFormat other = (DifferentialFormat)obj;
            result = Objects.equals(this.valueFormatting, other.valueFormatting) && Objects.equals(this.font, other.font) && Objects.equals(this.fill, other.fill) && Objects.equals(this.border, other.border) && Objects.equals(this.alignment, other.alignment) && Objects.equals(this.protection, other.protection);
        } else {
            result = false;
        }
        return result;
    }

    void write(Writer w) throws IOException {
        w.append("<dxf>");
        if (this.valueFormatting != null) {
            w.append("<numFmt numFmtId=\"").append(this.numFmtId).append("\" formatCode=\"").append(this.valueFormatting).append("\"/>");
        }
        if (this.font != null) {
            this.font.write(w);
        }
        if (this.fill != null) {
            this.fill.write(w);
        }
        if (this.border != null) {
            this.border.write(w);
        }
        if (this.alignment != null) {
            this.alignment.write(w);
        }
        if (this.protection != null) {
            this.protection.write(w);
        }
        w.append("</dxf>");
    }
}

