/*
 * Decompiled with CFR 0.152.
 */
package internal.text.base.api;

import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.Year;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import jdplus.text.base.api.XmlBean;
import jdplus.toolkit.base.api.data.DoubleList;
import jdplus.toolkit.base.api.timeseries.Ts;
import jdplus.toolkit.base.api.timeseries.TsCollection;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import jdplus.toolkit.base.tsp.HasFilePaths;
import jdplus.toolkit.base.tsp.fixme.Strings;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.xml.Stax;

public class XmlLoader {
    @NonNull
    private final HasFilePaths filePathSupport;

    @NonNull
    public List<TsCollection> load(@NonNull XmlBean bean) throws IOException {
        if (bean == null) {
            throw new NullPointerException("bean is marked non-null but is null");
        }
        File file = this.filePathSupport.resolveFilePath(bean.getFile());
        return XmlLoader.parse(file);
    }

    public static List<TsCollection> parse(File file) throws IOException {
        return (List)Stax.StreamParser.valueOf(XmlLoader::parseWorkspace).parseFile(file);
    }

    static List<TsCollection> parseWorkspace(XMLStreamReader reader) throws XMLStreamException {
        ArrayList<TsCollection> result = new ArrayList<TsCollection>();
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    if (!reader.getLocalName().equals("tscollection")) break;
                    result.add(XmlLoader.parseCollection(reader));
                }
            }
        }
        return result;
    }

    static TsCollection parseCollection(XMLStreamReader reader) throws XMLStreamException {
        return TsCollection.builder().name(Strings.nullToEmpty((String)reader.getAttributeValue(null, "name"))).items(XmlLoader.parseTss(reader)).build();
    }

    static List<Ts> parseTss(XMLStreamReader reader) throws XMLStreamException {
        ArrayList<Ts> result = new ArrayList<Ts>();
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    if (!reader.getLocalName().equals("ts")) break;
                    result.add(XmlLoader.parseTs(reader));
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals("tscollection")) break;
                    return result;
                }
            }
        }
        return result;
    }

    static Ts parseTs(XMLStreamReader reader) throws XMLStreamException {
        Ts.Builder result = Ts.builder();
        result.name(reader.getAttributeValue(null, "name"));
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    if (!reader.getLocalName().equals("tsdata")) break;
                    result.data(XmlLoader.parseTsData(reader));
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals("ts")) break;
                    return result.build();
                }
            }
        }
        return result.build();
    }

    static TsData parseTsData(XMLStreamReader reader) throws XMLStreamException {
        int frequency = XmlLoader.parseInt(reader.getAttributeValue(null, "freq"));
        int firstYear = XmlLoader.parseInt(reader.getAttributeValue(null, "ystart"));
        int firstPeriod = XmlLoader.parseInt(reader.getAttributeValue(null, "pstart"));
        double[] data = XmlLoader.parseData(reader);
        TsPeriod start = TsPeriod.of((TsUnit)TsUnit.ofAnnualFrequency((int)frequency), (LocalDate)Year.of(firstYear).atDay(1)).plus((long)(firstPeriod - 1));
        return TsData.ofInternal((TsPeriod)start, (double[])data);
    }

    static double[] parseData(XMLStreamReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    if (!reader.getLocalName().equals("data")) break;
                    DoubleList result = new DoubleList();
                    Iterator iter = Strings.splitToIterator((char)' ', (CharSequence)reader.getElementText());
                    while (iter.hasNext()) {
                        result.add(XmlLoader.parseDouble((String)iter.next()));
                    }
                    return result.toArray();
                }
                case 2: {
                    if (!reader.getLocalName().equals("tsdata")) break;
                    return null;
                }
            }
        }
        return null;
    }

    static int parseInt(String value) throws XMLStreamException {
        try {
            return Integer.parseInt(value);
        }
        catch (NullPointerException | NumberFormatException ex) {
            throw new XMLStreamException("Failed to parse integer", ex);
        }
    }

    static double parseDouble(String value) throws XMLStreamException {
        try {
            return Double.parseDouble(value);
        }
        catch (NullPointerException | NumberFormatException ex) {
            throw new XMLStreamException("Failed to parse double", ex);
        }
    }

    @Generated
    public XmlLoader(@NonNull HasFilePaths filePathSupport) {
        if (filePathSupport == null) {
            throw new NullPointerException("filePathSupport is marked non-null but is null");
        }
        this.filePathSupport = filePathSupport;
    }
}

