/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.diagnostics;

import java.util.Collections;
import java.util.List;
import jdplus.sa.base.api.DecompositionMode;
import jdplus.sa.base.core.diagnostics.CoherenceDiagnosticsConfiguration;
import jdplus.sa.base.core.diagnostics.CoherenceDiagnosticsFactory;
import jdplus.toolkit.base.api.data.AggregationType;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.dictionaries.Dictionary;
import jdplus.toolkit.base.api.information.Explorable;
import jdplus.toolkit.base.api.processing.Diagnostics;
import jdplus.toolkit.base.api.processing.ProcQuality;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import jdplus.toolkit.base.core.stats.DescriptiveStatistics;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class CoherenceDiagnostics
implements Diagnostics {
    private final CoherenceDiagnosticsConfiguration config;
    private double maxAnnualDifference;
    private double maxDefinitionDifference;
    private boolean multiplicative;
    private boolean shortSeries;
    private double scale;
    private static final String SHORTSERIES = "Short series";

    public static CoherenceDiagnostics of(CoherenceDiagnosticsConfiguration config, Input data) {
        try {
            if (data == null) {
                return null;
            }
            return new CoherenceDiagnostics(config, data.result, data.getMode());
        }
        catch (Exception ex) {
            return null;
        }
    }

    private CoherenceDiagnostics(CoherenceDiagnosticsConfiguration config, Explorable rslts, DecompositionMode mode) {
        this.config = config;
        this.test(rslts, mode);
    }

    private String decompositionItem(String key) {
        return Dictionary.concatenate((String[])new String[]{"decomposition", key});
    }

    private void test(Explorable rslts, DecompositionMode mode) {
        TsData cy = (TsData)rslts.getData(this.decompositionItem("y_cmp"), TsData.class);
        if (cy != null && cy.length() < this.config.getShortSeriesLimit() * cy.getAnnualFrequency()) {
            this.shortSeries = true;
        }
        this.multiplicative = mode != DecompositionMode.Additive;
        TsData y = (TsData)rslts.getData("yc", TsData.class);
        if (y == null) {
            y = (TsData)rslts.getData("y", TsData.class);
        }
        DescriptiveStatistics ds = DescriptiveStatistics.of((DoubleSeq)y.getValues());
        this.scale = ds.getRmse();
        TsData yc = y;
        TsData sa = (TsData)rslts.getData("sa", TsData.class);
        TsData s = (TsData)rslts.getData("s", TsData.class);
        TsData t = (TsData)rslts.getData("t", TsData.class);
        TsData i = (TsData)rslts.getData("i", TsData.class);
        if (mode == DecompositionMode.PseudoAdditive) {
            TsData df0 = this.sub(y, TsData.multiply((TsData)t, (TsData[])new TsData[]{TsData.add((TsData)s, (TsData)i).subtract(1.0)}));
            TsData df1 = this.sub(sa, TsData.multiply((TsData)t, (TsData[])new TsData[]{i}));
            this.check(df0);
            this.check(df1);
        } else {
            TsData regy = (TsData)rslts.getData("reg_y", TsData.class);
            TsData regsa = (TsData)rslts.getData("reg_sa", TsData.class);
            TsData ct = (TsData)rslts.getData(this.decompositionItem("t_cmp"), TsData.class);
            TsData cs = (TsData)rslts.getData(this.decompositionItem("s_cmp"), TsData.class);
            TsData ci = (TsData)rslts.getData(this.decompositionItem("i_cmp"), TsData.class);
            TsData csa = (TsData)rslts.getData(this.decompositionItem("sa_cmp"), TsData.class);
            TsData ly = (TsData)rslts.getData(this.decompositionItem("y_lin"), TsData.class);
            TsData lt = (TsData)rslts.getData(this.decompositionItem("t_lin"), TsData.class);
            TsData ls = (TsData)rslts.getData(this.decompositionItem("s_lin"), TsData.class);
            TsData li = (TsData)rslts.getData(this.decompositionItem("i_lin"), TsData.class);
            TsData lsa = (TsData)rslts.getData(this.decompositionItem("sa_lin"), TsData.class);
            TsData tde = (TsData)rslts.getData("tde", TsData.class);
            TsData ee = (TsData)rslts.getData("ee", TsData.class);
            TsData omhe = (TsData)rslts.getData("omhe", TsData.class);
            TsData cal = (TsData)rslts.getData("cal", TsData.class);
            TsData outs = (TsData)rslts.getData("out_s", TsData.class);
            TsData regs = (TsData)rslts.getData("reg_s", TsData.class);
            TsData outt = (TsData)rslts.getData("out_t", TsData.class);
            TsData regt = (TsData)rslts.getData("reg_t", TsData.class);
            TsData outi = (TsData)rslts.getData("out_i", TsData.class);
            TsData regi = (TsData)rslts.getData("reg_i", TsData.class);
            yc = this.inv_op(y, regy);
            TsData df0 = this.sub(yc, this.op(t, s, i, regsa));
            TsData df1 = this.sub(sa, this.op(t, i, regsa));
            TsData df3 = this.sub(s, this.op(cs, cal, regs, outs));
            TsData df4 = this.sub(t, this.op(ct, regt, outt));
            TsData df5 = this.sub(i, this.op(ci, regi, outi));
            TsData dcal = this.sub(cal, this.op(tde, ee, omhe));
            TsData dc0 = this.sub(cy, this.op(ct, cs, ci));
            TsData dc1 = this.sub(csa, this.op(ct, ci));
            this.maxDefinitionDifference = Double.NaN;
            this.check(df0);
            this.check(df1);
            this.check(df3);
            this.check(df4);
            this.check(df5);
            this.check(dcal);
            this.check(dc0);
            this.check(dc1);
            if (lsa != null) {
                TsData dl0 = this.sub(ly, this.add(lt, ls, li));
                TsData dl1 = this.sub(lsa, this.add(lt, li));
                this.check(dl0);
                this.check(dl1);
            }
        }
        TsData yca = yc.aggregate(TsUnit.P1Y, AggregationType.Sum, true);
        TsData saa = sa.aggregate(TsUnit.P1Y, AggregationType.Sum, true);
        this.maxAnnualDifference = 0.0;
        for (int k = 0; k < yca.length(); ++k) {
            double dcur = Math.abs(yca.getValue(k) - saa.getValue(k));
            if (!(dcur > this.maxAnnualDifference)) continue;
            this.maxAnnualDifference = dcur;
        }
        this.maxAnnualDifference /= (double)y.getAnnualFrequency() * this.scale;
    }

    private TsData op(TsData l, TsData r) {
        if (this.multiplicative) {
            return TsData.multiply((TsData)l, (TsData[])new TsData[]{r});
        }
        return TsData.add((TsData)l, (TsData)r);
    }

    private TsData op(TsData a, TsData b, TsData c) {
        if (this.multiplicative) {
            return TsData.multiply((TsData)a, (TsData[])new TsData[]{TsData.multiply((TsData)b, (TsData[])new TsData[]{c})});
        }
        return TsData.add((TsData)a, (TsData)TsData.add((TsData)b, (TsData)c));
    }

    private TsData add(TsData l, TsData r) {
        return TsData.add((TsData)l, (TsData)r);
    }

    private TsData add(TsData a, TsData b, TsData c) {
        return TsData.add((TsData)a, (TsData)TsData.add((TsData)b, (TsData)c));
    }

    private TsData op(TsData a, TsData b, TsData c, TsData d) {
        return this.op(this.op(a, b), this.op(c, d));
    }

    private TsData inv_op(TsData l, TsData r) {
        if (this.multiplicative) {
            return TsData.divide((TsData)l, (TsData)r);
        }
        return TsData.subtract((TsData)l, (TsData)r);
    }

    private TsData sub(TsData l, TsData r) {
        return TsData.subtract((TsData)l, (TsData)r);
    }

    public String getName() {
        return "Basic checks";
    }

    public List<String> getTests() {
        return CoherenceDiagnosticsFactory.ALL;
    }

    public ProcQuality getDiagnostic(String test) {
        if (test.equals(CoherenceDiagnosticsFactory.ALL.get(0))) {
            if (Double.isNaN(this.maxDefinitionDifference)) {
                return ProcQuality.Error;
            }
            return this.maxDefinitionDifference < this.config.getTolerance() ? ProcQuality.Good : ProcQuality.Error;
        }
        if (Double.isNaN(this.maxAnnualDifference)) {
            return ProcQuality.Error;
        }
        if (this.maxAnnualDifference > this.config.getSevereThreshold()) {
            return ProcQuality.Severe;
        }
        if (this.maxAnnualDifference > this.config.getBadThreshold()) {
            return ProcQuality.Bad;
        }
        if (this.maxAnnualDifference > this.config.getUncertainThreshold()) {
            return ProcQuality.Uncertain;
        }
        return ProcQuality.Good;
    }

    public double getValue(String test) {
        double val = test.equals(CoherenceDiagnosticsFactory.ALL.get(0)) ? this.maxDefinitionDifference : this.maxAnnualDifference;
        return val;
    }

    public List<String> getWarnings() {
        if (this.shortSeries) {
            return Collections.singletonList(SHORTSERIES);
        }
        return Collections.emptyList();
    }

    public double getLowerBound(ProcQuality quality) {
        return switch (quality) {
            case ProcQuality.Severe -> this.config.getSevereThreshold();
            case ProcQuality.Bad -> this.config.getBadThreshold();
            case ProcQuality.Uncertain -> this.config.getUncertainThreshold();
            default -> 0.0;
        };
    }

    private void check(TsData d) {
        if (d == null || this.scale == 0.0) {
            return;
        }
        DescriptiveStatistics stats = DescriptiveStatistics.of((DoubleSeq)d.getValues());
        double dmax = Math.max(Math.abs(stats.getMax()), Math.abs(stats.getMin())) / this.scale;
        if (Double.isNaN(this.maxDefinitionDifference) || dmax > this.maxDefinitionDifference) {
            this.maxDefinitionDifference = dmax;
        }
    }

    public static final class Input {
        private final DecompositionMode mode;
        private final Explorable result;

        @Generated
        public Input(DecompositionMode mode, Explorable result) {
            this.mode = mode;
            this.result = result;
        }

        @Generated
        public DecompositionMode getMode() {
            return this.mode;
        }

        @Generated
        public Explorable getResult() {
            return this.result;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Input)) {
                return false;
            }
            Input other = (Input)o;
            DecompositionMode this$mode = this.getMode();
            DecompositionMode other$mode = other.getMode();
            if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
                return false;
            }
            Explorable this$result = this.getResult();
            Explorable other$result = other.getResult();
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DecompositionMode $mode = this.getMode();
            result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
            Explorable $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "CoherenceDiagnostics.Input(mode=" + String.valueOf(this.getMode()) + ", result=" + String.valueOf(this.getResult()) + ")";
        }
    }
}

