/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.math.linearfilters;

import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.api.math.ComplexType;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.ComplexComputer;
import jdplus.toolkit.base.core.math.ComplexMath;
import jdplus.toolkit.base.core.math.ComplexUtility;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.decomposition.EigenSystem;
import jdplus.toolkit.base.core.math.matrices.decomposition.IEigenSystem;
import jdplus.toolkit.base.core.math.polynomials.LeastSquaresDivision;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.math.polynomials.UnitRoots;
import jdplus.toolkit.base.core.math.polynomials.UnitRootsSolver;

public class EigenValuesDecomposer2 {
    private double fac;
    private BackFilter bf;
    private static final double EPS = 1.0E-9;

    public BackFilter getBFilter() {
        return this.bf;
    }

    public double getFactor() {
        return this.fac;
    }

    public boolean decompose(SymmetricFilter sf) {
        this.clear();
        try {
            IntToDoubleFunction weights = sf.weights();
            double var = weights.applyAsDouble(0);
            if (var < 0.0) {
                return false;
            }
            if (sf.length() == 1) {
                this.bf = BackFilter.ONE;
                this.fac = var;
            } else {
                double[] w = sf.weightsToArray();
                Polynomial P = Polynomial.of(w);
                int n = (P = this.removeUnitRoots(P)).degree() / 2;
                if (n > 0) {
                    double[] c = P.coefficients().extract(n, n + 1).toArray();
                    Complex[] vals = this.roots(c);
                    Complex[] nvals = new Complex[vals.length];
                    double[] uvals = new double[vals.length / 2];
                    int k = 0;
                    int j = 0;
                    for (int i = 0; i < vals.length; ++i) {
                        Complex u = vals[i];
                        if (u.getIm() == 0.0) {
                            double r = u.getRe();
                            double rho = r * r - 4.0;
                            if (rho < -1.0E-9) {
                                int l;
                                Complex cur = Complex.cart((double)(r / 2.0), (double)(Math.sqrt(-rho) / 2.0));
                                for (l = 0; l < k; ++l) {
                                    if (!(Math.abs(r - uvals[l]) < 1.0E-6)) continue;
                                    uvals[l] = 0.0;
                                    break;
                                }
                                if (l != k) continue;
                                uvals[k++] = r;
                                nvals[j++] = cur;
                                nvals[j++] = cur.conj();
                                continue;
                            }
                            if (rho < 0.0) {
                                rho = 0.0;
                                r = r < 0.0 ? -2.0 : 2.0;
                            }
                            double srho = Math.sqrt(rho);
                            if (r < 0.0) {
                                nvals[j++] = Complex.cart((double)((r - srho) / 2.0));
                                continue;
                            }
                            nvals[j++] = Complex.cart((double)((r + srho) / 2.0));
                            continue;
                        }
                        if (!(u.getIm() > 0.0)) continue;
                        ComplexComputer computer = new ComplexComputer((ComplexType)u);
                        computer.mul((ComplexType)u).sub(4.0);
                        Complex srho = ComplexMath.sqrt(computer);
                        ComplexComputer x1 = new ComplexComputer((ComplexType)u);
                        x1.add((ComplexType)srho).div(2.0);
                        ComplexComputer x2 = new ComplexComputer((ComplexType)u);
                        x2.sub((ComplexType)srho).div(2.0);
                        Complex z = x1.abs() > x2.abs() ? x1.result() : x2.result();
                        nvals[j++] = z;
                        nvals[j++] = z.conj();
                    }
                    ComplexUtility.lejaOrder(nvals);
                    Polynomial Z = Polynomial.fromComplexRoots(nvals);
                    Z = Z.times(1.0 / Z.get(0));
                    this.bf = this.bf.times(new BackFilter(Z));
                }
            }
            this.fac = var / this.bf.asPolynomial().coefficients().ssq();
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }

    private Complex[] roots(double[] c) {
        int n = c.length - 1;
        switch (n) {
            case 0: {
                return new Complex[0];
            }
            case 1: {
                return new Complex[]{Complex.cart((double)(-c[0] / c[1]))};
            }
        }
        FastMatrix M = FastMatrix.square(n);
        DataBlock col = M.column(n - 1);
        double sn = c[n];
        col.set(i -> -c[i] / sn);
        M.subDiagonal(-1).add(1.0);
        M.add(0, 1, 1.0);
        M.subDiagonal(1).add(1.0);
        IEigenSystem es = EigenSystem.create(M, false);
        return es.getEigenValues();
    }

    private Polynomial removeUnitRoots(Polynomial P) {
        UnitRoots ur;
        UnitRoots sur;
        UnitRootsSolver urs = new UnitRootsSolver(0);
        if (urs.factorize(P) && (sur = (ur = urs.getUnitRoots()).sqrt()) != null) {
            Polynomial urp = sur.asPolynomial();
            Polynomial ur2 = urp.times(urp);
            this.bf = new BackFilter(urp);
            LeastSquaresDivision lsd = new LeastSquaresDivision();
            lsd.divide(P, ur2);
            P = lsd.getQuotient();
            double[] c = P.toArray();
            int d = P.degree();
            int n = d / 2;
            for (int i = 0; i < n; ++i) {
                double q;
                c[i] = q = (c[i] + c[d - i]) / 2.0;
                c[d - i] = q;
            }
            P = Polynomial.of(c);
        }
        if (this.bf == null) {
            this.bf = BackFilter.ONE;
        }
        return P;
    }

    private void clear() {
        this.bf = null;
        this.fac = 0.0;
    }
}

