/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.data;

import jdplus.toolkit.base.core.data.DataBlock;

public class DataWindow {
    private final DataBlock cur;

    public static DataWindow windowOf(double[] data, int start, int end, int inc) {
        return new DataWindow(DataBlock.of(data, start, end, inc));
    }

    public static DataWindow startOf(double[] data) {
        return new DataWindow(DataBlock.of(data, 0, 0, 1));
    }

    public static DataWindow startOf(double[] data, int inc) {
        return new DataWindow(DataBlock.of(data, 0, 0, inc));
    }

    private DataWindow(DataBlock cur) {
        this.cur = cur;
    }

    DataWindow(double[] data, int start, int end, int inc) {
        this.cur = new DataBlock(data, start, end, inc);
    }

    public DataBlock get() {
        return this.cur;
    }

    public DataBlock next(int n) {
        this.cur.beg = this.cur.end;
        this.cur.end += n * this.cur.inc;
        return this.cur;
    }

    public DataBlock previous(int n) {
        this.cur.end = this.cur.beg;
        this.cur.beg -= n * this.cur.inc;
        return this.cur;
    }

    public DataBlock bexpand() {
        this.cur.beg -= this.cur.inc;
        return this.cur;
    }

    public DataBlock eexpand() {
        this.cur.end += this.cur.inc;
        return this.cur;
    }

    public DataBlock bshrink() {
        this.cur.beg += this.cur.inc;
        return this.cur;
    }

    public DataBlock eshrink() {
        this.cur.end -= this.cur.inc;
        return this.cur;
    }

    public DataBlock shrink(int nbeg, int nend) {
        this.cur.beg += this.cur.inc * nbeg;
        this.cur.end -= this.cur.inc * nend;
        return this.cur;
    }

    public DataBlock move(int n) {
        int del = this.cur.inc * n;
        this.cur.beg += del;
        this.cur.end += del;
        return this.cur;
    }

    public DataBlock slide(int n) {
        this.cur.beg += n;
        this.cur.end += n;
        return this.cur;
    }

    public DataBlock slideAndShrink(int n) {
        this.cur.beg += n;
        this.cur.end += n - this.cur.inc;
        return this.cur;
    }

    public DataBlock expand(int nbeg, int nend) {
        this.cur.beg -= nbeg * this.cur.inc;
        this.cur.end += nend * this.cur.inc;
        return this.cur;
    }
}

