/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.data;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class LogSign {
    private final double value;
    private final boolean positive;

    public static LogSign of(DoubleSeq reader) {
        double value = 0.0;
        boolean pos = true;
        DoubleSeqCursor cell = reader.cursor();
        int n = reader.length();
        for (int i = 0; i < n; ++i) {
            double x = cell.getAndNext();
            if (x < 0.0) {
                pos = !pos;
                x = -x;
            }
            value += Math.log(x);
        }
        return new LogSign(value, pos);
    }

    public static LogSign of(DoubleSeq reader, boolean chs) {
        double value = 0.0;
        boolean pos = true;
        DoubleSeqCursor cell = reader.cursor();
        int n = reader.length();
        for (int i = 0; i < n; ++i) {
            double x = cell.getAndNext();
            if (x < 0.0) {
                pos = !pos;
                x = -x;
            }
            value += Math.log(x);
        }
        return new LogSign(value, chs ? !pos : pos);
    }

    @Generated
    public LogSign(double value, boolean positive) {
        this.value = value;
        this.positive = positive;
    }

    @Generated
    public double getValue() {
        return this.value;
    }

    @Generated
    public boolean isPositive() {
        return this.positive;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogSign)) {
            return false;
        }
        LogSign other = (LogSign)o;
        if (Double.compare(this.getValue(), other.getValue()) != 0) {
            return false;
        }
        return this.isPositive() == other.isPositive();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value >>> 32 ^ $value);
        result = result * 59 + (this.isPositive() ? 79 : 97);
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "LogSign(value=" + this.getValue() + ", positive=" + this.isPositive() + ")";
    }
}

