/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.linearfilters;

import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.functions.NumericalIntegration;
import jdplus.toolkit.base.core.math.linearfilters.FiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.IFiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.LocalPolynomialFilters;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.toolkit.base.core.math.linearsystem.LinearSystemSolver;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import lombok.Generated;
import lombok.NonNull;

public final class AsymmetricFiltersFactory {
    private static final double Q = 0.15915494309189535;

    public static IFiniteFilter musgraveFilter(SymmetricFilter s, int q, double ic) {
        double[] h = s.weightsToArray();
        int n = s.length();
        int l = (n - 1) / 2;
        int m = l + q + 1;
        double[] c = new double[m];
        double r = Math.PI * ic * ic / 4.0;
        int i = 0;
        while (i < m) {
            c[i] = h[i];
            double p1 = 0.0;
            double p2 = 0.0;
            for (int j = m; j < n; ++j) {
                p1 += h[j];
                p2 += h[j] * ((double)(j + 1) - (double)(m + 1) / 2.0);
            }
            int n2 = i++;
            c[n2] = c[n2] + ((p1 /= (double)m) + (p2 *= ((double)(i + 1) - (double)(m + 1) / 2.0) / (r + (double)(m * (m - 1) * (m + 1)) / 12.0)));
        }
        return FiniteFilter.ofInternal(c, -l);
    }

    public static IFiniteFilter[] musgraveFilters(SymmetricFilter s, double ic) {
        int horizon = s.getUpperBound();
        IFiniteFilter[] ff = new IFiniteFilter[horizon];
        int i = 0;
        int h = horizon - 1;
        while (i < horizon) {
            ff[i] = AsymmetricFiltersFactory.musgraveFilter(s, h, ic);
            ++i;
            --h;
        }
        return ff;
    }

    public static IFiniteFilter cutAndNormalizeFilter(SymmetricFilter s, int q) {
        int i;
        IntToDoubleFunction weights = s.weights();
        int l = s.getLowerBound();
        double[] w = new double[q - l + 1];
        double n = 0.0;
        for (i = 0; i < w.length; ++i) {
            w[i] = weights.applyAsDouble(l + i);
            n += w[i];
        }
        i = 0;
        while (i < w.length) {
            int n2 = i++;
            w[n2] = w[n2] / n;
        }
        return FiniteFilter.ofInternal(w, l);
    }

    public static IFiniteFilter[] cutAndNormalizeFilters(SymmetricFilter s) {
        int horizon = s.getUpperBound();
        IFiniteFilter[] ff = new IFiniteFilter[horizon];
        int i = 0;
        int h = horizon - 1;
        while (i < horizon) {
            ff[i] = AsymmetricFiltersFactory.cutAndNormalizeFilter(s, h);
            ++i;
            --h;
        }
        return ff;
    }

    @Deprecated
    public static IFiniteFilter mmsreFilter2(SymmetricFilter sw, int q, int u, @NonNull double[] dz, IntToDoubleFunction k) {
        if (dz == null) {
            throw new NullPointerException("dz is marked non-null but is null");
        }
        double[] w = sw.weightsToArray();
        int h = w.length / 2;
        int nv = h + q + 1;
        int deg = u + dz.length;
        DataBlock wp = DataBlock.of(w, 0, nv);
        DataBlock wf = DataBlock.of(w, nv, w.length);
        FastMatrix Z = LocalPolynomialFilters.createZ(h, deg);
        FastMatrix Zp = LocalPolynomialFilters.z(Z, -h, q, u + 1, u + dz.length);
        FastMatrix Zf = LocalPolynomialFilters.z(Z, q + 1, h, u + 1, u + dz.length);
        FastMatrix Up = LocalPolynomialFilters.z(Z, -h, q, 0, u);
        FastMatrix Uf = LocalPolynomialFilters.z(Z, q + 1, h, 0, u);
        DataBlock d = DataBlock.of(dz);
        FastMatrix H = SymmetricMatrix.XtX(Up);
        DataBlock a1 = DataBlock.make(u + 1);
        a1.product(Uf.columnsIterator(), wf);
        DataBlock a2 = a1.deepClone();
        LinearSystemSolver.fastSolver().solve(H, a2);
        DataBlock a3 = DataBlock.make(nv);
        a3.product(Up.rowsIterator(), a2);
        DataBlock a4 = DataBlock.make(dz.length);
        a4.product(Zp.columnsIterator(), a3);
        a4.chs();
        a4.addProduct(Zf.columnsIterator(), wf);
        DataBlock a5 = DataBlock.make(nv);
        a5.product(Zp.rowsIterator(), d);
        DataBlock a6 = DataBlock.make(u + 1);
        a6.product(Up.columnsIterator(), a5);
        DataBlock a7 = a6.deepClone();
        LinearSystemSolver.fastSolver().solve(H, a7);
        DataBlock a8 = DataBlock.make(nv);
        a8.product(Up.rowsIterator(), a7);
        DataBlock a9 = a5.deepClone();
        a9.sub(a8);
        DataBlock a10 = DataBlock.make(dz.length);
        a10.product(Zp.columnsIterator(), a9);
        FastMatrix C = FastMatrix.square(dz.length);
        for (int i = 0; i < dz.length; ++i) {
            for (int j = 0; j < dz.length; ++j) {
                double x = a10.get(i) * dz[j];
                if (i == j) {
                    x += 1.0;
                }
                C.set(i, j, x);
            }
        }
        DataBlock a11 = a4.deepClone();
        LinearSystemSolver.fastSolver().solve(C, a11);
        double s = a11.dot(d);
        a9.mul(s);
        wp.add(a9);
        wp.add(a3);
        return FiniteFilter.ofInternal(wp.toArray(), -h);
    }

    public static IFiniteFilter mmsreFilter(SymmetricFilter sw, int q, int u, double[] dz, IntToDoubleFunction k) {
        return AsymmetricFiltersFactory.mmsreFilter(sw, q, u, dz, k, 0.0, 0.0);
    }

    public static IFiniteFilter mmsreFilter(SymmetricFilter sw, int q, int u, double[] dz, IntToDoubleFunction k, double passBand, double tweight) {
        double[] w = sw.weightsToArray();
        int h = w.length / 2;
        int nv = h + q + 1;
        int deg = u + (dz == null ? 0 : dz.length);
        DataBlock wp = DataBlock.of(w, 0, nv);
        DataBlock wf = DataBlock.of(w, nv, w.length);
        FastMatrix Z = LocalPolynomialFilters.createZ(h, deg);
        FastMatrix Up = LocalPolynomialFilters.z(Z, -h, q, 0, u);
        FastMatrix Uf = LocalPolynomialFilters.z(Z, q + 1, h, 0, u);
        FastMatrix Q = FastMatrix.square(nv + u + 1);
        FastMatrix D = Q.extract(0, nv, 0, nv);
        D.diagonal().set(1.0);
        Q.extract(nv, u + 1, 0, nv).copyTranspose(Up);
        Q.extract(0, nv, nv, u + 1).copy(Up);
        DataBlock a = DataBlock.make(Q.getRowsCount());
        a.extract(nv, u + 1).product(wf, Uf.columnsIterator());
        if (dz != null && dz.length > 0) {
            DataBlock d = DataBlock.of(dz);
            FastMatrix Zp = LocalPolynomialFilters.z(Z, -h, q, u + 1, u + dz.length);
            FastMatrix Zf = LocalPolynomialFilters.z(Z, q + 1, h, u + 1, u + dz.length);
            DataBlock Yp = DataBlock.make(nv);
            DataBlockIterator cols = Zp.columnsIterator();
            DoubleSeqCursor.OnMutable cursor = d.cursor();
            while (cols.hasNext()) {
                Yp.addAY(cursor.getAndNext(), cols.next());
            }
            DataBlock Yf = DataBlock.make(wf.length());
            cols = Zf.columnsIterator();
            cursor.moveTo(0);
            while (cols.hasNext()) {
                Yf.addAY(cursor.getAndNext(), cols.next());
            }
            D.addXaXt(1.0, Yp);
            a.extract(0, nv).setAY(Yf.dot(wf), Yp);
        }
        if (passBand > 0.0 && tweight > 0.0) {
            FastMatrix W = AsymmetricFiltersFactory.buildMatrix(passBand, h, q);
            D.addAY(tweight, W);
            DataBlock row = DataBlock.of((DoubleSeq)wp);
            row.mul(-tweight);
            a.addProduct(row, W.columnsIterator());
        }
        LinearSystemSolver.fastSolver().solve(Q, a);
        wp.add(a.extract(0, nv));
        return FiniteFilter.ofInternal(wp.toArray(), -h);
    }

    public static IFiniteFilter mmsreFilter(SymmetricFilter sw, int q, FastMatrix U, FastMatrix Z, double[] dz, IntToDoubleFunction k, double passBand, double tweight) {
        double[] w = sw.weightsToArray();
        int h = w.length / 2;
        FiniteFilter rf = FiniteFilter.ofInternal(w, -h);
        return AsymmetricFiltersFactory.mmsreFilter(rf, q, U, Z, dz, k, passBand, tweight);
    }

    public static IFiniteFilter mmsreFilter(IFiniteFilter rf, int q, FastMatrix U, FastMatrix Z, double[] dz, IntToDoubleFunction k, double passBand, double tweight) {
        double[] w = rf.weightsToArray();
        int h = Math.abs(rf.getLowerBound());
        int nv = h + q + 1;
        int ncolu = U.getColumnsCount();
        DataBlock wp = DataBlock.of(w, 0, nv);
        DataBlock wf = DataBlock.of(w, nv, w.length);
        FastMatrix Up = U.extract(0, nv, 0, ncolu);
        FastMatrix Uf = U.extract(nv, U.getRowsCount() - nv, 0, ncolu);
        FastMatrix Q = FastMatrix.square(nv + ncolu);
        FastMatrix D = Q.extract(0, nv, 0, nv);
        if (k != null) {
            for (int i = 0; i < nv; ++i) {
                D.diagonal().set(i, 1.0 / k.applyAsDouble(i - h));
            }
        } else {
            D.diagonal().set(1.0);
        }
        Q.extract(nv, ncolu, 0, nv).copyTranspose(Up);
        Q.extract(0, nv, nv, ncolu).copy(Up);
        DataBlock a = DataBlock.make(Q.getRowsCount());
        a.extract(nv, ncolu + 1).product(wf, Uf.columnsIterator());
        if (dz != null && dz.length > 0) {
            DataBlock d = DataBlock.of(dz);
            FastMatrix Zp = Z.extract(0, nv, 0, Z.getColumnsCount());
            FastMatrix Zf = Z.extract(nv, Z.getRowsCount() - nv, 0, Z.getColumnsCount());
            DataBlock Yp = DataBlock.make(nv);
            DataBlockIterator cols = Zp.columnsIterator();
            DoubleSeqCursor.OnMutable cursor = d.cursor();
            while (cols.hasNext()) {
                Yp.addAY(cursor.getAndNext(), cols.next());
            }
            DataBlock Yf = DataBlock.make(wf.length());
            cols = Zf.columnsIterator();
            cursor.moveTo(0);
            while (cols.hasNext()) {
                Yf.addAY(cursor.getAndNext(), cols.next());
            }
            D.addXaXt(1.0, Yp);
            a.extract(0, nv).setAY(Yf.dot(wf), Yp);
        }
        if (passBand > 0.0 && tweight > 0.0) {
            FastMatrix W = AsymmetricFiltersFactory.buildMatrix(passBand, h, q);
            D.addAY(tweight, W);
            DataBlock row = DataBlock.of((DoubleSeq)wp);
            row.mul(-tweight);
            a.addProduct(row, W.columnsIterator());
        }
        LinearSystemSolver.fastSolver().solve(Q, a);
        wp.add(a.extract(0, nv));
        return FiniteFilter.ofInternal(wp.toArray(), -h);
    }

    private static FastMatrix buildMatrix(double w, int nlags, int nleads) {
        int i;
        int n = 2 * Math.max(nlags, nleads) + 1;
        int m = nlags + nleads + 1;
        FastMatrix T2 = FastMatrix.square(m);
        double[] sin1 = new double[n];
        for (i = 0; i < n; ++i) {
            sin1[i] = Math.sin((double)i * w);
        }
        for (i = -nlags; i <= nleads; ++i) {
            for (int j = -nlags; j <= nleads; ++j) {
                double dl;
                double dk;
                int sum = Math.abs(i + j);
                int diff = Math.abs(i - j);
                if (sum == 0) {
                    if (diff == 0) continue;
                    dk = w;
                    dl = sin1[diff] / (double)diff;
                    T2.set(i + nlags, j + nlags, 0.5 * (dl - dk));
                    continue;
                }
                if (diff == 0) {
                    dk = sin1[sum] / (double)sum;
                    dl = w;
                    T2.set(i + nlags, j + nlags, 0.5 * (dl - dk));
                    continue;
                }
                dk = sin1[sum] / (double)sum;
                dl = sin1[diff] / (double)diff;
                T2.set(i + nlags, j + nlags, 0.5 * (dl - dk));
            }
        }
        return T2;
    }

    public static IFiniteFilter[] mmsreFilters(SymmetricFilter s, int u, double[] dz, IntToDoubleFunction k) {
        int horizon = s.getUpperBound();
        IFiniteFilter[] ff = new IFiniteFilter[horizon];
        int i = 0;
        int h = horizon - 1;
        while (i < horizon) {
            ff[i] = AsymmetricFiltersFactory.mmsreFilter(s, h, u, dz, k);
            ++i;
            --h;
        }
        return ff;
    }

    public static IFiniteFilter[] mmsreFilters(SymmetricFilter s, int u, double[] dz, IntToDoubleFunction k, double passBand, double tweight) {
        int horizon = s.getUpperBound();
        IFiniteFilter[] ff = new IFiniteFilter[horizon];
        int i = 0;
        int h = horizon - 1;
        while (i < horizon) {
            ff[i] = AsymmetricFiltersFactory.mmsreFilter(s, h, u, dz, k, passBand, tweight);
            ++i;
            --h;
        }
        return ff;
    }

    public static double[] implicitForecasts(IFiniteFilter sfilter, IFiniteFilter[] afilters, DoubleSeq x) {
        int h = sfilter.getUpperBound();
        if (h != afilters.length || x.length() != h + 1) {
            return null;
        }
        double[] f = new double[afilters.length];
        FastMatrix L = FastMatrix.square(h);
        IntToDoubleFunction sw = sfilter.weights();
        for (int i = 0; i < h; ++i) {
            IntToDoubleFunction aw = afilters[i].weights();
            double q = 0.0;
            int j = -h;
            int k = 0;
            while (j <= 0) {
                q += (aw.applyAsDouble(j) - sw.applyAsDouble(j)) * x.get(k);
                ++j;
                ++k;
            }
            f[i] = q;
            while (j <= h - i - 1) {
                L.set(i, j - 1, sw.applyAsDouble(j) - aw.applyAsDouble(j));
                ++j;
            }
            while (j <= h) {
                L.set(i, j - 1, sw.applyAsDouble(j));
                ++j;
            }
        }
        LinearSystemSolver.fastSolver().solve(L, DataBlock.of(f));
        return f;
    }

    public static double[] underlyingForecasts(IFiniteFilter sfilter, IFiniteFilter[] afilters, DoubleSeq x) {
        int h = sfilter.getUpperBound();
        if (h != afilters.length || x.length() != 2 * h) {
            return null;
        }
        double[] f = new double[afilters.length];
        FastMatrix L = FastMatrix.square(h);
        IntToDoubleFunction sw = sfilter.weights();
        for (int i = 0; i < h; ++i) {
            IntToDoubleFunction aw = afilters[h - i - 1].weights();
            double q = 0.0;
            int j = -h;
            int k = h - i - 1;
            while (j <= i) {
                q += (aw.applyAsDouble(j) - sw.applyAsDouble(j)) * x.get(k);
                ++j;
                ++k;
            }
            f[i] = q;
            for (j = 1; j <= h; ++j) {
                if (j <= h - i) {
                    L.set(i, j - 1, sw.applyAsDouble(j + i));
                    continue;
                }
                L.set(i, j - 1, 0.0);
            }
        }
        LinearSystemSolver.fastSolver().solve(L, DataBlock.of(f));
        return f;
    }

    public static Distance frequencyResponseDistance(@NonNull DoubleUnaryOperator spectralDensity) {
        if (spectralDensity == null) {
            throw new NullPointerException("spectralDensity is marked non-null but is null");
        }
        return (sf, af) -> {
            DoubleUnaryOperator fn = x -> spectralDensity.applyAsDouble(x) * sf.frequencyResponse(x).squareDistance(af.frequencyResponse(x));
            return 2.0 * NumericalIntegration.integrate(fn, 0.0, Math.PI);
        };
    }

    public static Distance frequencyResponseDistance() {
        return AsymmetricFiltersFactory.frequencyResponseDistance(x -> 0.15915494309189535);
    }

    public static Distance accuracyDistance(@NonNull DoubleUnaryOperator spectralDensity, double passBand) {
        if (spectralDensity == null) {
            throw new NullPointerException("spectralDensity is marked non-null but is null");
        }
        return (sf, af) -> {
            DoubleUnaryOperator fn = x -> {
                double y = sf.gainFunction().applyAsDouble(x) - af.gainFunction().applyAsDouble(x);
                return y * y * spectralDensity.applyAsDouble(x);
            };
            return 2.0 * NumericalIntegration.integrate(fn, 0.0, passBand);
        };
    }

    public static Distance accuracyDistance(SymmetricFilter sf, FiniteFilter af, double passBand) {
        return AsymmetricFiltersFactory.accuracyDistance(x -> 0.15915494309189535, passBand);
    }

    public static Distance smoothnessDistance(DoubleUnaryOperator spectralDensity, double passBand) {
        return (sf, af) -> {
            DoubleUnaryOperator fn = x -> {
                double y = sf.gainFunction().applyAsDouble(x) - af.gainFunction().applyAsDouble(x);
                return y * y * spectralDensity.applyAsDouble(x);
            };
            return 2.0 * NumericalIntegration.integrate(fn, passBand, Math.PI);
        };
    }

    public static Distance smoothnessDistance(double passBand) {
        return AsymmetricFiltersFactory.smoothnessDistance(x -> 0.15915494309189535, passBand);
    }

    public static Distance timelinessDistance(DoubleUnaryOperator spectralDensity, double passBand) {
        return (sf, af) -> {
            DoubleUnaryOperator fn = x -> {
                double g = Math.abs(sf.realFrequencyResponse(x));
                double ga = af.frequencyResponse(x).abs();
                double s = Math.sin(af.frequencyResponse(x).arg() / 2.0);
                return g * ga * s * s * spectralDensity.applyAsDouble(x);
            };
            return 8.0 * NumericalIntegration.integrate(fn, 0.0, passBand);
        };
    }

    public static Distance timelinessDistance(double passBand) {
        return AsymmetricFiltersFactory.timelinessDistance(x -> 0.15915494309189535, passBand);
    }

    public static Distance timelinessDistance2(DoubleUnaryOperator spectralDensity, double a, double b) {
        return (sf, af) -> {
            DoubleUnaryOperator fn = x -> {
                double p = af.frequencyResponse(x).arg();
                return x == 0.0 ? 0.0 : Math.abs(p / x) * spectralDensity.applyAsDouble(x);
            };
            return 8.0 * NumericalIntegration.integrate(fn, a, b);
        };
    }

    public static Distance timelinessDistance2(double a, double b) {
        return AsymmetricFiltersFactory.timelinessDistance2(x -> 0.15915494309189535, a, b);
    }

    @Generated
    private AsymmetricFiltersFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static interface Distance {
        public double compute(SymmetricFilter var1, FiniteFilter var2);
    }
}

