/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.linearfilters;

import java.util.function.IntFunction;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import lombok.Generated;

public final class CrossValidation {
    public static double[] doCrossValidation(DoubleSeq data, int low, int high, IntFunction<SymmetricFilter> factory) {
        int start = high;
        int end = data.length() - high;
        double[] rslt = new double[high - low];
        double[] pdata = data.toArray();
        for (int i = 0; i < rslt.length; ++i) {
            int h = low + i;
            SymmetricFilter sf = factory.apply(i + low);
            double w0 = sf.weights().applyAsDouble(0);
            double d = 0.0;
            for (int j = start; j < end; ++j) {
                double del = pdata[j] - sf.apply(pdata, j, 1);
                d += del * del;
            }
            rslt[i] = Math.sqrt(d) / (1.0 - w0) / (double)(end - start);
        }
        return rslt;
    }

    @Generated
    private CrossValidation() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

