/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.linearsystem;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearsystem.QRLeastSquaresSolution;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.UpperTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.decomposition.Householder2;
import jdplus.toolkit.base.core.math.matrices.decomposition.HouseholderWithPivoting;
import jdplus.toolkit.base.core.math.matrices.decomposition.QRDecomposition;
import lombok.Generated;

public final class QRLeastSquaresSolver {
    public static QRLeastSquaresSolution fastLeastSquares(DoubleSeq y, FastMatrix X) {
        Householder2 h = new Householder2();
        QRDecomposition qr = h.decompose(X);
        return QRLeastSquaresSolver.leastSquares(qr, y, 0.0);
    }

    public static QRLeastSquaresSolution robustLeastSquares(DoubleSeq y, FastMatrix X) {
        HouseholderWithPivoting h = new HouseholderWithPivoting();
        QRDecomposition qr = h.decompose(X, 0);
        return QRLeastSquaresSolver.leastSquares(qr, y, 1.0E-9);
    }

    public static QRLeastSquaresSolution leastSquares(QRDecomposition qr, DoubleSeq x, double rcond) {
        DoubleSeq b;
        int rank = UpperTriangularMatrix.rank(qr.rawR(), rcond);
        double[] y = x.toArray();
        qr.applyQt(y);
        int m = qr.m();
        int n = qr.n();
        DoubleSeq e = DoubleSeq.of((double[])y, (int)rank, (int)(m - rank));
        UpperTriangularMatrix.solveUx(qr.rawR().extract(0, rank, 0, rank), DataBlock.of(y));
        int[] pivot = qr.pivot();
        if (pivot == null) {
            if (rank == n) {
                b = DoubleSeq.of((double[])y, (int)0, (int)rank);
            } else {
                double[] tmp = new double[n];
                for (int i = 0; i < rank; ++i) {
                    tmp[i] = y[i];
                }
                b = DoubleSeq.of((double[])tmp);
            }
        } else {
            double[] tmp = new double[n];
            for (int i = 0; i < rank; ++i) {
                tmp[pivot[i]] = y[i];
            }
            b = DoubleSeq.of((double[])tmp);
        }
        return new QRLeastSquaresSolution(qr, rank, b, e, e.ssq());
    }

    @Generated
    private QRLeastSquaresSolver() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    public static interface Processor {
        public QRLeastSquaresSolution solve(DoubleSeq var1, FastMatrix var2);
    }
}

