/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.decomposition;

import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;
import jdplus.toolkit.base.core.math.matrices.MatrixWindow;
import jdplus.toolkit.base.core.math.matrices.decomposition.HouseholderReflection;
import lombok.Generated;

public final class SimilarTransformations {
    @Generated
    private SimilarTransformations() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class Hessenberg {
        public static void householder(FastMatrix A) {
            int n = A.getRowsCount();
            if (!A.isSquare()) {
                throw new MatrixException("m_err_square");
            }
            if (n > 2) {
                MatrixWindow wnd = A.all();
                MatrixWindow rwnd = A.all();
                for (int i = 1; i < n - 1; ++i) {
                    DataBlockIterator cols = wnd.bvshrink().columnsIterator();
                    HouseholderReflection hr = HouseholderReflection.of(cols.next(), true);
                    while (cols.hasNext()) {
                        hr.transform(cols.next());
                    }
                    wnd.bhshrink();
                    DataBlockIterator rows = rwnd.bhshrink().rowsIterator();
                    while (rows.hasNext()) {
                        hr.transform(rows.next());
                    }
                }
            }
        }

        public static void gauss(FastMatrix A) {
            int n = A.getRowsCount();
            if (!A.isSquare()) {
                throw new MatrixException("m_err_square");
            }
            if (n > 2) {
                double[] h = A.getStorage();
                int m = 1;
                int idx = 0;
                while (m < n - 1) {
                    double x = 0.0;
                    int i = m;
                    int j = m;
                    int idx2 = idx + j;
                    while (j < n) {
                        if (Math.abs(h[idx2]) > Math.abs(x)) {
                            x = h[idx2];
                            i = j;
                        }
                        ++j;
                        ++idx2;
                    }
                    int idxi = i * n;
                    int idxm = m * n;
                    if (i != m) {
                        int j2 = m - 1;
                        int idx22 = j2 * n;
                        while (j2 < n) {
                            Hessenberg.swap(h, idx22 + i, idx22 + m);
                            ++j2;
                            idx22 += n;
                        }
                        for (j2 = 0; j2 < n; ++j2) {
                            Hessenberg.swap(h, idxi + j2, idxm + j2);
                        }
                    }
                    if (x != 0.0) {
                        for (int l = m + 1; l < n; ++l) {
                            double y = h[idx + l];
                            if (y == 0.0) continue;
                            h[idx + l] = y /= x;
                            int j3 = m;
                            int idxj = m * n;
                            while (j3 < n) {
                                int n2 = idxj + l;
                                h[n2] = h[n2] - y * h[idxj + m];
                                ++j3;
                                idxj += n;
                            }
                            j3 = 0;
                            int idxl = l * n;
                            while (j3 < n) {
                                int n3 = idxm + j3;
                                h[n3] = h[n3] + y * h[idxl];
                                ++j3;
                                ++idxl;
                            }
                        }
                    }
                    ++m;
                    idx += n;
                }
                int i = 0;
                idx = 0;
                while (i < n - 2) {
                    int j = i + 2;
                    int idx2 = idx + j;
                    while (j < n) {
                        h[idx2] = 0.0;
                        ++j;
                        ++idx2;
                    }
                    ++i;
                    idx += n;
                }
            }
        }

        public static boolean isHessenberg(FastMatrix A) {
            int n = A.getColumnsCount() - 2;
            for (int i = 0; i < n; ++i) {
                if (A.column(i).drop(i + 2, 0).isZero(0.0)) continue;
                return false;
            }
            return true;
        }

        private static void swap(double[] x, int i, int j) {
            double tmp = x[i];
            x[i] = x[j];
            x[j] = tmp;
        }

        @Generated
        private Hessenberg() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class Balancing {
        public static final double RADIX = 2.0;

        public static void balance(FastMatrix A) {
            if (!A.isSquare()) {
                throw new MatrixException("m_err_square");
            }
            double sqrd = 4.0;
            int n = A.getColumnsCount();
            double[] a = A.getStorage();
            boolean last = false;
            while (!last) {
                last = true;
                int i = 0;
                int idxci = 0;
                while (i < n) {
                    double r = 0.0;
                    double c = 0.0;
                    int j = 0;
                    int idxji = idxci;
                    int idxij = i;
                    while (j < n) {
                        if (j != i) {
                            c += Math.abs(a[idxji]);
                            r += Math.abs(a[idxij]);
                        }
                        ++j;
                        ++idxji;
                        idxij += n;
                    }
                    if (c != 0.0 && r != 0.0) {
                        double g = r / 2.0;
                        double f = 1.0;
                        double s = c + r;
                        while (c < g) {
                            f *= 2.0;
                            c *= sqrd;
                        }
                        g = r * 2.0;
                        while (c > g) {
                            f /= 2.0;
                            c /= sqrd;
                        }
                        if ((c + r) / f < 0.95 * s) {
                            last = false;
                            g = 1.0 / f;
                            int j2 = 0;
                            int idx = i;
                            while (j2 < n) {
                                int n2 = idx;
                                a[n2] = a[n2] * g;
                                ++j2;
                                idx += n;
                            }
                            idx = idxci;
                            for (j2 = 0; j2 < n; ++j2) {
                                int n3 = idx++;
                                a[n3] = a[n3] * f;
                            }
                        }
                    }
                    ++i;
                    idxci += n;
                }
            }
        }

        @Generated
        private Balancing() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }
}

