/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regular.tests;

import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.ProbabilityType;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.calendars.DayClustering;
import jdplus.toolkit.base.api.timeseries.calendars.GenericTradingDays;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.dstats.Chi2;
import jdplus.toolkit.base.core.math.functions.IParametricMapping;
import jdplus.toolkit.base.core.math.functions.ParamValidation;
import jdplus.toolkit.base.core.math.functions.levmar.LevenbergMarquardtMinimizer;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.GenericTradingDaysFactory;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.sarima.estimation.SarimaMapping;
import jdplus.toolkit.base.core.ssf.arima.SsfArima;
import jdplus.toolkit.base.core.ssf.basic.RegSsf;
import jdplus.toolkit.base.core.ssf.dk.SsfFunction;
import jdplus.toolkit.base.core.ssf.dk.SsfFunctionPoint;
import jdplus.toolkit.base.core.ssf.univariate.Ssf;
import jdplus.toolkit.base.core.ssf.univariate.SsfData;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public class TimeVaryingEstimator {
    private FastMatrix tdvar;
    private FastMatrix td;
    private TsData s;
    private SarimaModel arima0;
    private SarimaModel arima;
    private double ll;
    private double ll0;
    private DoubleSeq p;
    private DoubleSeq p0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatisticalTest process(TsData s, DayClustering dc, boolean onContrasts) {
        this.s = s;
        this.tdvar = TimeVaryingEstimator.generateVar(dc, onContrasts);
        GenericTradingDays gtd = GenericTradingDays.contrasts((DayClustering)dc);
        int n = s.length();
        this.td = FastMatrix.make(n, gtd.getCount());
        GenericTradingDaysFactory.FACTORY.fill(gtd, s.getStart(), this.td);
        try {
            if (!this.compute()) {
                StatisticalTest statisticalTest = null;
                return statisticalTest;
            }
            Chi2 chi2 = new Chi2(1.0);
            double val = 2.0 * (this.ll - this.ll0);
            if (val < 0.0) {
                val = 0.0;
            }
            StatisticalTest statisticalTest = new StatisticalTest(val, chi2.getProbability(val, ProbabilityType.Upper), chi2.getDescription());
            return statisticalTest;
        }
        catch (Exception err) {
            StatisticalTest statisticalTest = null;
            return statisticalTest;
        }
        finally {
            this.cleanUp();
        }
    }

    public static FastMatrix generateVar(DayClustering dc, boolean onContrast) {
        int groupsCount = dc.getGroupsCount() - 1;
        FastMatrix M = FastMatrix.square(groupsCount);
        int[] D = new int[groupsCount];
        for (int i2 = 0; i2 < groupsCount; ++i2) {
            D[i2] = dc.getGroupCount(i2 + 1);
        }
        M.diagonal().set(i -> 1.0 / (double)(D[i] * D[i]));
        if (!onContrast) {
            double vm = (double)(1 + groupsCount) / 49.0;
            M.add(vm);
            for (int i3 = 0; i3 < groupsCount; ++i3) {
                M.add(i3, i3, -2.0 / ((double)D[i3] * 7.0));
                for (int j = 0; j < i3; ++j) {
                    double c = (1.0 / (double)D[i3] + 1.0 / (double)D[j]) / 7.0;
                    M.add(i3, j, -c);
                    M.add(j, i3, -c);
                }
            }
        }
        return M;
    }

    private boolean compute() {
        try {
            SsfData data = new SsfData(this.s.getValues());
            int period = this.s.getAnnualFrequency();
            TDvarData tdVar0 = new TDvarData(SarimaModel.builder(SarimaOrders.airline((int)period)).setDefault(0.0, -0.6).build(), this.td, null);
            TDvarMapping mapping0 = new TDvarMapping(tdVar0);
            this.p0 = mapping0.getDefaultParameters();
            SsfFunction fn0 = SsfFunction.builder(data, mapping0, q -> q.toSsf()).useSqrtInitialization(true).useScalingFactor(true).useLog(true).build();
            LevenbergMarquardtMinimizer min = LevenbergMarquardtMinimizer.builder().functionPrecision(1.0E-9).build();
            min.minimize(fn0.evaluate(this.p0));
            SsfFunctionPoint rfn0 = (SsfFunctionPoint)min.getResult();
            this.arima0 = ((TDvarData)rfn0.getCore()).getArima();
            this.p0 = rfn0.getParameters();
            TDvarData tdVar1 = new TDvarData(this.arima0, this.td, this.tdvar);
            TDvarMapping mapping1 = new TDvarMapping(tdVar1);
            SsfFunction fn1 = SsfFunction.builder(data, mapping1, q -> q.toSsf()).useSqrtInitialization(true).useScalingFactor(true).useLog(true).build();
            double[] np = new double[3];
            this.p0.copyTo(np, 0);
            np[2] = 0.001;
            min.minimize(fn1.evaluate(DoubleSeq.of((double[])np)));
            SsfFunctionPoint rfn1 = (SsfFunctionPoint)min.getResult();
            this.arima = ((TDvarData)rfn1.getCore()).getArima();
            this.p = rfn1.getParameters();
            this.ll = rfn1.getLikelihood().logLikelihood();
            this.ll0 = rfn0.getLikelihood().logLikelihood();
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }

    private void cleanUp() {
    }

    private static final class TDvarData {
        @NonNull
        private final SarimaModel arima;
        @NonNull
        private final FastMatrix td;
        private final FastMatrix nvar;

        boolean hasVar() {
            return this.nvar != null;
        }

        Ssf toSsf() {
            Ssf ssf = SsfArima.ssf(this.arima);
            if (this.nvar != null) {
                return RegSsf.timeVaryingSsf(ssf, this.td, this.nvar);
            }
            return RegSsf.ssf(ssf, this.td);
        }

        @Generated
        public TDvarData(@NonNull SarimaModel arima, @NonNull FastMatrix td, FastMatrix nvar) {
            if (arima == null) {
                throw new NullPointerException("arima is marked non-null but is null");
            }
            if (td == null) {
                throw new NullPointerException("td is marked non-null but is null");
            }
            this.arima = arima;
            this.td = td;
            this.nvar = nvar;
        }

        @NonNull
        @Generated
        public SarimaModel getArima() {
            return this.arima;
        }

        @NonNull
        @Generated
        public FastMatrix getTd() {
            return this.td;
        }

        @Generated
        public FastMatrix getNvar() {
            return this.nvar;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TDvarData)) {
                return false;
            }
            TDvarData other = (TDvarData)o;
            SarimaModel this$arima = this.getArima();
            SarimaModel other$arima = other.getArima();
            if (this$arima == null ? other$arima != null : !((Object)this$arima).equals(other$arima)) {
                return false;
            }
            FastMatrix this$td = this.getTd();
            FastMatrix other$td = other.getTd();
            if (this$td == null ? other$td != null : !this$td.equals(other$td)) {
                return false;
            }
            FastMatrix this$nvar = this.getNvar();
            FastMatrix other$nvar = other.getNvar();
            return !(this$nvar == null ? other$nvar != null : !this$nvar.equals(other$nvar));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SarimaModel $arima = this.getArima();
            result = result * 59 + ($arima == null ? 43 : ((Object)$arima).hashCode());
            FastMatrix $td = this.getTd();
            result = result * 59 + ($td == null ? 43 : $td.hashCode());
            FastMatrix $nvar = this.getNvar();
            result = result * 59 + ($nvar == null ? 43 : $nvar.hashCode());
            return result;
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "TimeVaryingEstimator.TDvarData(arima=" + String.valueOf(this.getArima()) + ", td=" + String.valueOf(this.getTd()) + ", nvar=" + String.valueOf(this.getNvar()) + ")";
        }
    }

    private static class TDvarMapping
    implements IParametricMapping<TDvarData> {
        private static final SarimaMapping AIRLINEMAPPING;
        private final TDvarData data;

        TDvarMapping(TDvarData data) {
            this.data = data;
        }

        @Override
        public boolean checkBoundaries(DoubleSeq inparams) {
            return AIRLINEMAPPING.checkBoundaries(inparams.extract(0, 2));
        }

        @Override
        public double epsilon(DoubleSeq inparams, int idx) {
            if (idx < 2) {
                return AIRLINEMAPPING.epsilon(inparams, idx);
            }
            return Math.max(inparams.get(2) * 0.001, 1.0E-9);
        }

        @Override
        public int getDim() {
            return this.data.getNvar() == null ? 2 : 3;
        }

        @Override
        public double lbound(int idx) {
            if (idx < 2) {
                return AIRLINEMAPPING.lbound(idx);
            }
            return 0.0;
        }

        @Override
        public double ubound(int idx) {
            if (idx < 2) {
                return AIRLINEMAPPING.ubound(idx);
            }
            return 10.0;
        }

        @Override
        public ParamValidation validate(DataBlock ioparams) {
            return AIRLINEMAPPING.validate(ioparams.extract(0, 2));
        }

        @Override
        public String getDescription(int idx) {
            if (idx < 2) {
                return AIRLINEMAPPING.getDescription(idx);
            }
            return "noise stdev";
        }

        @Override
        public TDvarData map(DoubleSeq p) {
            SarimaModel arima = this.data.getArima().toBuilder().theta(1, p.get(0)).btheta(1, p.get(1)).build();
            FastMatrix v = null;
            if (this.data.hasVar()) {
                double nv = p.get(2);
                v = this.data.getNvar().deepClone();
                v.mul(nv * nv);
            }
            return new TDvarData(arima, this.data.getTd(), v);
        }

        @Override
        public DoubleSeq getDefaultParameters() {
            double[] p = new double[this.getDim()];
            p[0] = -0.6;
            p[1] = -0.6;
            if (p.length > 2) {
                p[2] = 0.1;
            }
            return DoubleSeq.of((double[])p);
        }

        static {
            SarimaOrders spec = SarimaOrders.airline((int)12);
            AIRLINEMAPPING = SarimaMapping.of(spec);
        }
    }
}

